/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.types;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.TokenWindowChatMemory;
import dev.langchain4j.model.TokenCountEstimator;
import dev.langchain4j.model.openai.OpenAiChatModelName;
import dev.langchain4j.model.openai.OpenAiTokenCountEstimator;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.experimental.types.ChatModel;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

public class Memory
implements IValue {
    ChatMemory memory = null;

    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "memory", (Object)this.memory);
    }

    public Memory(ChatModel chatModel, Integer n) {
        this.memory = TokenWindowChatMemory.withMaxTokens((int)(n != null && n > 0 ? n : 1000), (TokenCountEstimator)new OpenAiTokenCountEstimator(OpenAiChatModelName.GPT_4_O_MINI));
        chatModel.setMemory(this);
    }

    public ChatMemory getMemory() {
        return this.memory;
    }

    public void addToMemory(String string) {
        if (string == null) {
            return;
        }
        SystemMessage systemMessage = SystemMessage.from((String)string);
        this.memory.add((ChatMessage)systemMessage);
    }

    public Memory(Memory memory) {
        memory.memory.messages();
    }

    public String toString() {
        return "memory(" + this.memory.messages().toString() + ")";
    }

    public String serializeToGaml(boolean bl) {
        return this.toString();
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.toString();
    }

    public Memory copy(IScope iScope) throws GamaRuntimeException {
        return new Memory(this);
    }

    public int hashCode() {
        return this.memory.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Memory memory = (Memory)object;
        return this.memory.equals(memory.memory);
    }

    public IType<?> getGamlType() {
        return Types.get((int)3427233);
    }
}

