/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.mcp.McpToolProvider;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.service.tool.ToolExecutor;
import dev.langchain4j.service.tool.ToolProviderResult;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.kernel.model.IModel;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.GamaPair;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.experimental.types.MCPClient;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.List;
import java.util.Map;

@GamlAnnotations.vars(value={})
public class ToolProvider
implements IValue {
    private dev.langchain4j.service.tool.ToolProvider toolProvider = null;
    private MCPClient client = null;
    private IMap<ToolSpecification, ToolExecutor> parameters = null;

    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "parameters", this.parameters, "toolProvider", (Object)this.toolProvider);
    }

    private static Map<String, Object> toMap(String string) {
        try {
            return (Map)new ObjectMapper().readValue(string, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new RuntimeException(jsonProcessingException);
        }
    }

    public void addToolExecutor(IScope iScope, String string, String string2, ActionDescription actionDescription) {
        ToolExecutor toolExecutor = (toolExecutionRequest, object) -> {
            String string = actionDescription.getName();
            if (iScope.getModel() != null && iScope.getModel().getAction(string) != null) {
                String string2 = toolExecutionRequest.arguments();
                Map<String, Object> map = ToolProvider.toMap(toolExecutionRequest.arguments());
                string2 = map.get("msg") != null ? map.get("msg").toString() : map.get("description").toString();
                IModel iModel = iScope.getModel();
                IStatement.WithArgs withArgs = iModel.getAction(string);
                Arguments arguments = new Arguments();
                arguments.put("msg", (IExpressionDescription)ConstantExpressionDescription.create((Object)string2));
                withArgs.setRuntimeArgs(iScope, arguments);
                return withArgs.executeOn(iScope).toString();
            }
            return toolExecutionRequest.arguments();
        };
        ToolSpecification toolSpecification = ToolSpecification.builder().name(string).description(string2).parameters(JsonObjectSchema.builder().addStringProperty("msg", "The message give to the tool as input, it can be any").build()).build();
        this.addTool(toolSpecification, toolExecutor);
    }

    public void addToolExecutor(IScope iScope, String string, ActionDescription actionDescription) {
        ToolExecutor toolExecutor = (toolExecutionRequest, object2) -> {
            String string2 = actionDescription.getName();
            if (iScope.getModel() != null && iScope.getModel().getAction(string2) != null) {
                toolExecutionRequest.arguments();
                Map<String, Object> map = ToolProvider.toMap(toolExecutionRequest.arguments());
                IModel iModel = iScope.getModel();
                IStatement.WithArgs withArgs = iModel.getAction(string2);
                Arguments arguments = new Arguments();
                map.forEach((string, object) -> arguments.put(string, (IExpressionDescription)ConstantExpressionDescription.create((Object)object)));
                withArgs.setRuntimeArgs(iScope, arguments);
                return withArgs.executeOn(iScope).toString();
            }
            return toolExecutionRequest.arguments();
        };
        try {
            ToolSpecification toolSpecification = ToolProvider.parseToolSpecification(string);
            System.out.println("ToolSpecification created successfully:");
            System.out.println("Name: " + toolSpecification.name());
            System.out.println("Description: " + toolSpecification.description());
            System.out.println("Parameters: " + String.valueOf(toolSpecification.parameters()));
            this.addTool(toolSpecification, toolExecutor);
        }
        catch (JsonProcessingException jsonProcessingException) {
            System.err.println("Error parsing JSON string: " + jsonProcessingException.getMessage());
        }
    }

    public static ToolSpecification parseToolSpecification(String string2) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map map2 = (Map)objectMapper.readValue(string2, Map.class);
        String string3 = (String)map2.get("name");
        String string4 = (String)map2.get("description");
        Map map3 = (Map)map2.get("parameters");
        if (map3 == null) {
            throw new IllegalArgumentException("JSON must contain a 'parameters' object.");
        }
        Map map4 = (Map)map3.get("properties");
        List list = (List)map3.get("required");
        JsonObjectSchema.Builder builder = JsonObjectSchema.builder();
        if (map4 != null) {
            map4.forEach((string, map) -> {
                String string2 = (String)map.get("type");
                String string3 = (String)map.get("description");
                if ("string".equals(string2)) {
                    builder.addStringProperty(string, string3);
                } else if ("integer".equals(string2)) {
                    builder.addIntegerProperty(string, string3);
                }
            });
        }
        if (list != null) {
            list.forEach(string -> {
                JsonObjectSchema.Builder builder2 = builder.required(new String[]{string});
            });
        }
        JsonObjectSchema jsonObjectSchema = builder.build();
        return ToolSpecification.builder().name(string3).description(string4).parameters(jsonObjectSchema).build();
    }

    public ToolProvider() {
    }

    public ToolProvider(MCPClient mCPClient) {
        this.client = mCPClient;
    }

    public MCPClient getClient() {
        return this.client;
    }

    public void setClient(MCPClient mCPClient) {
        this.client = mCPClient;
        this.init();
    }

    public ToolProvider(ToolProvider toolProvider) {
        this.parameters = GamaMapFactory.concurrentMap();
        this.parameters.putAll(toolProvider.parameters);
        this.init();
    }

    public dev.langchain4j.service.tool.ToolProvider getToolProvider() {
        return this.toolProvider;
    }

    public IMap<ToolSpecification, ToolExecutor> getParameters() {
        return this.parameters;
    }

    public void init() {
        this.toolProvider = this.client != null ? McpToolProvider.builder().mcpClients(List.of(this.client.client)).build() : toolProviderRequest -> {
            ToolProviderResult.Builder builder = ToolProviderResult.builder();
            this.parameters.getPairs().stream().forEach(object -> {
                ToolProviderResult.Builder builder2 = builder.add((ToolSpecification)((GamaPair)object).key, (ToolExecutor)((GamaPair)object).value);
            });
            return builder.build();
        };
    }

    public void addTool(ToolSpecification toolSpecification, ToolExecutor toolExecutor) {
        if (this.parameters == null) {
            this.parameters = GamaMapFactory.create();
        }
        this.parameters.put((Object)toolSpecification, (Object)toolExecutor);
        this.init();
    }

    public String toString() {
        return "provider(" + this.toolProvider.toString() + ")";
    }

    public String serializeToGaml(boolean bl) {
        return this.toString();
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.toString();
    }

    public ToolProvider copy(IScope iScope) throws GamaRuntimeException {
        return new ToolProvider(this);
    }

    public int hashCode() {
        return this.toolProvider.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ToolProvider toolProvider = (ToolProvider)object;
        return this.toolProvider.equals(toolProvider.toolProvider);
    }

    public IType<?> getGamlType() {
        return Types.get((int)146707);
    }
}

