/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.netcdf.file;

import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ucar.ma2.Array;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.dt.image.ImageArrayAdapter;
import ucar.nc2.ui.image.ImageViewPanel;

public class TestNetCDF
extends JPanel {
    String netCDF_File = "C:\\git\\gama.experimental\\cict.gaml.extensions.netcdf\\models\\NetCDF\\includes\\ENS_mm_rcp85.2015_2050_MKD_tas.nc";
    private static TestNetCDF tester;
    private static JFrame frame;
    private static ImageViewPanel imgpan;
    NetcdfDataset ds = null;
    private ucar.nc2.dt.GridDataset gridDataset;
    private int nbgrid = 0;
    private int time = 0;
    private int ntimes = 1;
    boolean forward = true;

    public static void main(String[] stringArray) throws Exception {
        frame = new JFrame("NetCDF test");
        imgpan = new ImageViewPanel(frame);
        tester = new TestNetCDF();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(imgpan);
        frame.pack();
        frame.setBounds(new Rectangle(50, 50, 800, 450));
        frame.setVisible(true);
        tester.process();
        new Thread(){

            @Override
            public void run() {
                BufferedImage bufferedImage = null;
                do {
                    if (TestNetCDF.tester.forward) {
                        ++TestNetCDF.tester.time;
                        if (TestNetCDF.tester.time >= TestNetCDF.tester.ntimes) {
                            ++TestNetCDF.tester.nbgrid;
                            TestNetCDF.tester.time = 0;
                        }
                    } else {
                        --TestNetCDF.tester.time;
                        if (TestNetCDF.tester.time < 0) {
                            TestNetCDF.tester.time = TestNetCDF.tester.ntimes - 1;
                        }
                    }
                    try {
                        Array array = tester.getGrid().readDataSlice(TestNetCDF.tester.time, 0, -1, -1);
                        bufferedImage = ImageArrayAdapter.makeGrayscaleImage((Array)array, null);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    imgpan.setImage(bufferedImage);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                } while (bufferedImage != null);
            }
        }.start();
    }

    boolean process() {
        boolean bl;
        block9: {
            bl = false;
            this.ds = NetcdfDataset.openDataset((String)this.netCDF_File, (boolean)true, null);
            this.ds.getCoordinateSystems().get(0);
            if (this.ds != null) break block9;
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + this.netCDF_File);
            return false;
        }
        try {
            this.gridDataset = new GridDataset(this.ds, new Formatter());
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + this.netCDF_File + "\n" + fileNotFoundException.getMessage());
            fileNotFoundException.printStackTrace();
            bl = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bl = true;
        }
        if (this.ds != null) {
            GridDatatype gridDatatype = this.getGrid();
            if (gridDatatype == null) {
                return false;
            }
            this.time = 0;
            GridCoordSystem gridCoordSystem = gridDatatype.getCoordinateSystem();
            if (gridCoordSystem.getTimeAxis() != null) {
                this.ntimes = (int)gridCoordSystem.getTimeAxis().getSize();
            }
            try {
                Array array = gridDatatype.readDataSlice(this.time, 0, -1, -1);
                imgpan.setImage(ImageArrayAdapter.makeGrayscaleImage((Array)array, null));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return !bl;
    }

    public GridDatatype getGrid() {
        List list = this.gridDataset.getGrids();
        if (this.nbgrid >= list.size()) {
            this.nbgrid = 0;
        }
        if (list.size() > 0) {
            return (GridDatatype)list.get(this.nbgrid);
        }
        return null;
    }
}

