/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.image;

import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JOptionPane;
import ucar.nc2.ui.image.PictureCache;
import ucar.nc2.ui.image.ScalablePictureListener;
import ucar.nc2.ui.image.ScaleThread;
import ucar.nc2.ui.image.SourcePicture;
import ucar.nc2.ui.image.SourcePictureListener;
import ucar.nc2.ui.image.Tools;

public class ScalablePicture
implements SourcePictureListener {
    public SourcePicture sourcePicture;
    public BufferedImage scaledPicture = null;
    private double ScaleFactor;
    public URL imageUrl = null;
    private int pictureStatusCode;
    private String pictureStatusMessage;
    private boolean scaleToSize;
    private Dimension TargetSize;
    public static final int UNINITIALISED = 8;
    public static final int GARBAGE_COLLECTION = 9;
    public static final int LOADING = 10;
    public static final int LOADED = 11;
    public static final int SCALING = 12;
    public static final int READY = 13;
    public static final int ERROR = 14;
    private AffineTransformOp op;
    private Vector scalablePictureStatusListeners = new Vector();
    public float jpgQuality = 0.8f;
    public boolean fastScale = true;
    private static RenderingHints rh_quality = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    private static RenderingHints rh_bicubic = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    public boolean scaleAfterLoad = false;

    public ScalablePicture() {
        this.setStatus(8, "Creating uninitialised ScalablePicture object.");
        this.setScaleFactor(1.0);
    }

    public void loadAndScalePictureInThread(URL uRL, int n, double d) {
        this.imageUrl = uRL;
        boolean bl = false;
        Tools.log("ScalablePicture.loadAndScalePictureInThread: checking if picture " + String.valueOf(uRL) + " is already being loaded.");
        if (this.sourcePicture != null && this.sourcePicture.getUrl().equals(uRL)) {
            Tools.log("ScalablePicture.loadAndScalePictureInThread: the SourcePicture is already loading the sourcePictureimage");
            bl = true;
        } else if (PictureCache.isInCache(uRL)) {
            if (this.sourcePicture != null) {
                this.sourcePicture.removeListener(this);
            }
            this.sourcePicture = PictureCache.getSourcePicture(uRL);
            String string = this.sourcePicture.getStatusMessage();
            if (string == null) {
                string = "";
            }
            Tools.log("ScalablePicture.loadAndScalePictureInThread: Picture in cache! Status: " + string);
            if (this.sourcePicture.getRotation() == d) {
                bl = true;
                Tools.log("ScalablePicture.loadAndScalePictureInThread: Picture was even rotated to the correct angle!");
            } else {
                bl = false;
                Tools.log("ScalablePicture.loadAndScalePictureInThread: Picture was in cache but with wrong rotation. Forcing reload.");
            }
        }
        if (bl) {
            switch (this.sourcePicture.getStatusCode()) {
                case 0: {
                    bl = false;
                    Tools.log("ScalablePicture.loadAndScalePictureInThread: pictureStatus was: UNINITIALISED");
                    break;
                }
                case 4: {
                    bl = false;
                    Tools.log("ScalablePicture.loadAndScalePictureInThread: pictureStatus was: ERROR");
                    break;
                }
                case 1: {
                    Tools.log("ScalablePicture.loadAndScalePictureInThread: pictureStatus was: LOADING");
                    this.sourcePicture.addListener(this);
                    this.setStatus(10, "Loading: " + uRL.toString());
                    this.sourceLoadProgressNotification(6, this.sourcePicture.getPercentLoaded());
                    this.scaleAfterLoad = true;
                    break;
                }
                case 2: {
                    Tools.log("ScalablePicture.loadAndScalePictureInThread: pictureStatus was: ROTATING");
                    this.setStatus(10, "Rotating: " + uRL.toString());
                    this.sourceLoadProgressNotification(6, this.sourcePicture.getPercentLoaded());
                    this.scaleAfterLoad = true;
                    break;
                }
                case 3: {
                    Tools.log("ScalablePicture.loadAndScalePictureInThread: pictureStatus was: READY. Sending SCALING status.");
                    this.setStatus(12, "Scaling: " + uRL.toString());
                    this.createScaledPictureInThread(n);
                    break;
                }
                default: {
                    Tools.log("ScalablePicture.loadAndScalePictureInThread: Don't know what status this is:" + Integer.toString(this.sourcePicture.getStatusCode()));
                }
            }
        }
        if (!bl) {
            if (this.sourcePicture != null) {
                this.sourcePicture.removeListener(this);
            }
            this.sourcePicture = new SourcePicture();
            this.sourcePicture.addListener(this);
            this.setStatus(10, "Loading: " + uRL.toString());
            this.scaleAfterLoad = true;
            this.sourcePicture.loadPictureInThread(uRL, n, d);
        }
    }

    public void loadPictureImd(URL uRL, double d) {
        Tools.log("loadPictureImd invoked with URL: " + uRL.toString());
        if (this.sourcePicture != null) {
            this.sourcePicture.removeListener(this);
        }
        this.sourcePicture = new SourcePicture();
        this.sourcePicture.addListener(this);
        this.setStatus(10, "Loading: " + uRL.toString());
        this.scaleAfterLoad = true;
        this.sourcePicture.loadPicture(uRL, d);
    }

    public void stopLoadingExcept(URL uRL) {
        if (this.sourcePicture != null) {
            boolean bl = this.sourcePicture.stopLoadingExcept(uRL);
            PictureCache.stopBackgroundLoadingExcept(uRL);
        }
    }

    @Override
    public void sourceStatusChange(int n, String string, SourcePicture sourcePicture) {
        switch (n) {
            case 0: {
                Tools.log("ScalablePicture.sourceStatusChange: pictureStatus was: UNINITIALISED message: " + string);
                this.setStatus(8, string);
                break;
            }
            case 4: {
                Tools.log("ScalablePicture.sourceStatusChange: pictureStatus was: ERROR message: " + string);
                this.setStatus(14, string);
                this.sourcePicture.removeListener(this);
                break;
            }
            case 1: {
                Tools.log("ScalablePicture.sourceStatusChange: pictureStatus was: LOADING message: " + string);
                this.setStatus(10, string);
                break;
            }
            case 2: {
                Tools.log("ScalablePicture.sourceStatusChange: pictureStatus was: ROTATING message: " + string);
                this.setStatus(10, string);
                break;
            }
            case 3: {
                Tools.log("ScalablePicture.sourceStatusChange: pictureStatus was: READY message: " + string);
                this.setStatus(11, string);
                this.sourcePicture.removeListener(this);
                if (!this.scaleAfterLoad) break;
                this.createScaledPictureInThread(10);
                this.scaleAfterLoad = false;
                break;
            }
            default: {
                Tools.log("ScalablePicture.sourceStatusChange: Don't recognize this status: " + string);
            }
        }
    }

    @Override
    public void sourceLoadProgressNotification(int n, int n2) {
        Enumeration enumeration = this.scalablePictureStatusListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ScalablePictureListener)enumeration.nextElement()).sourceLoadProgressNotification(n, n2);
        }
    }

    public void createScaledPictureInThread(int n) {
        this.setStatus(12, "Scaling picture.");
        ScaleThread scaleThread = new ScaleThread(this);
        scaleThread.setPriority(n);
        scaleThread.start();
    }

    public void scalePicture() {
        Tools.log("ScalablePicture.scalePicture invoked");
        try {
            this.setStatus(12, "Scaling picture.");
            if (this.sourcePicture != null && this.sourcePicture.getSourceBufferedImage() != null) {
                if (this.scaleToSize) {
                    int n = this.TargetSize.width;
                    int n2 = this.TargetSize.height;
                    Tools.log("ScalablePicture.scalePicture: scaleToSize: Windowsize: " + Integer.toString(n) + "x" + Integer.toString(n2));
                    int n3 = this.sourcePicture.getWidth();
                    int n4 = this.sourcePicture.getHeight();
                    this.ScaleFactor = n == 0 || n2 == 0 ? 1.0 : ((double)n4 / (double)n2 > (double)n3 / (double)n ? (double)n2 / (double)n4 : (double)n / (double)n3);
                }
                Tools.log("ScalablePicture.scalePicture: doing an AffineTransform with Factor: " + Double.toString(this.ScaleFactor));
                AffineTransform affineTransform = AffineTransform.getScaleInstance(this.ScaleFactor, this.ScaleFactor);
                this.op = this.fastScale ? new AffineTransformOp(affineTransform, 1) : new AffineTransformOp(affineTransform, 2);
                this.scaledPicture = this.op.filter(this.sourcePicture.getSourceBufferedImage(), null);
                this.scaledPicture.getWidth();
                this.scaledPicture.getHeight();
                this.setStatus(13, "Scaled Picture is ready.");
            } else {
                if (this.getStatusCode() == 10) {
                    Tools.log("ScalablePicture.scalePicture invoked while image is still loading. I wonder why?");
                    return;
                }
                this.setStatus(14, "Could not scale image as SourceImage is null.");
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Tools.log("ScalablePicture.scalePicture caught an OutOfMemoryError while scaling an image.\n" + outOfMemoryError.getMessage());
            this.setStatus(14, "Out of Memory Error while scaling " + this.imageUrl.toString());
            this.scaledPicture = null;
            PictureCache.clear();
            JOptionPane.showMessageDialog(null, "outOfMemoryError", "genericError", 0);
            System.gc();
            System.runFinalization();
            Tools.log("ScalablePicture.scalePicture: JPO has now run a garbage collection and finalization.");
        }
        catch (Exception exception) {
            System.out.println("Exception in ScalablePicture.scalePicture" + String.valueOf(exception));
        }
    }

    public void setScaleFactor(double d) {
        this.scaleToSize = false;
        this.TargetSize = null;
        this.ScaleFactor = d;
    }

    public void setScaleSize(Dimension dimension) {
        this.scaleToSize = true;
        this.TargetSize = dimension;
    }

    public double getScaleFactor() {
        return this.ScaleFactor;
    }

    public Dimension getScaleSize() {
        return this.TargetSize;
    }

    public BufferedImage getScaledPicture() {
        return this.scaledPicture;
    }

    public Dimension getScaledSize() {
        if (this.scaledPicture != null) {
            return new Dimension(this.scaledPicture.getWidth(), this.scaledPicture.getHeight());
        }
        return new Dimension(0, 0);
    }

    public String getScaledSizeString() {
        if (this.scaledPicture != null) {
            return Integer.toString(this.scaledPicture.getWidth()) + " x " + Integer.toString(this.scaledPicture.getHeight());
        }
        return "0 x 0";
    }

    public int getScaledHeight() {
        if (this.scaledPicture != null) {
            return this.scaledPicture.getHeight();
        }
        return 0;
    }

    public int getScaledWidth() {
        if (this.scaledPicture != null) {
            return this.scaledPicture.getWidth();
        }
        return 0;
    }

    public BufferedImage getOriginalImage() {
        return this.sourcePicture.getSourceBufferedImage();
    }

    public SourcePicture getSourcePicture() {
        return this.sourcePicture.getSourcePicture();
    }

    public SourcePicture setSourcePicture(SourcePicture sourcePicture) {
        this.sourcePicture = sourcePicture;
        return this.sourcePicture;
    }

    public Dimension getOriginalSize() {
        return this.sourcePicture.getSize();
    }

    public int getOriginalHeight() {
        return this.sourcePicture.getHeight();
    }

    public int getOriginalWidth() {
        return this.sourcePicture.getWidth();
    }

    public String getFilename() {
        return this.imageUrl.toString();
    }

    public void writeScaledJpg(File file) {
        ScalablePicture.writeJpg(file, this.scaledPicture, this.jpgQuality);
    }

    public static void writeJpg(File file, RenderedImage renderedImage, float f) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
        ImageWriter imageWriter = iterator.next();
        JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(null);
        jPEGImageWriteParam.setCompressionMode(2);
        jPEGImageWriteParam.setCompressionQuality(f);
        jPEGImageWriteParam.setProgressiveMode(0);
        jPEGImageWriteParam.setDestinationType(new ImageTypeSpecifier(IndexColorModel.getRGBdefault(), IndexColorModel.getRGBdefault().createCompatibleSampleModel(16, 16)));
        try {
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new FileOutputStream(file));
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(null, new IIOImage(renderedImage, null, null), jPEGImageWriteParam);
            imageOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        imageWriter.dispose();
    }

    public void addStatusListener(ScalablePictureListener scalablePictureListener) {
        this.scalablePictureStatusListeners.add(scalablePictureListener);
    }

    public void removeStatusListener(ScalablePictureListener scalablePictureListener) {
        this.scalablePictureStatusListeners.remove(scalablePictureListener);
    }

    private void setStatus(int n, String string) {
        String string2 = this.imageUrl == null ? "" : this.imageUrl.toString();
        Tools.log("ScalablePicture.setStatus: sending: " + string + " to all Listeners from Image: " + string2);
        this.pictureStatusCode = n;
        this.pictureStatusMessage = string;
        Enumeration enumeration = this.scalablePictureStatusListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ScalablePictureListener)enumeration.nextElement()).scalableStatusChange(this.pictureStatusCode, this.pictureStatusMessage);
        }
    }

    public int getStatusCode() {
        return this.pictureStatusCode;
    }

    public String getStatusMessage() {
        return this.pictureStatusMessage;
    }

    public void setJpgQuality(float f) {
        if (f >= 0.0f && f <= 1.0f) {
            this.jpgQuality = f;
        }
    }

    public void setFastScale() {
        this.fastScale = true;
    }

    public void setQualityScale() {
        this.fastScale = false;
    }
}

