/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.image;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JOptionPane;
import ucar.nc2.ui.image.LoadThread;
import ucar.nc2.ui.image.PictureCache;
import ucar.nc2.ui.image.SourcePictureListener;
import ucar.nc2.ui.image.Tools;

public class SourcePicture
implements Cloneable {
    public static final int UNINITIALISED = 0;
    public static final int LOADING = 1;
    public static final int ROTATING = 2;
    public static final int READY = 3;
    public static final int ERROR = 4;
    public static final int LOADING_STARTED = 5;
    public static final int LOADING_PROGRESS = 6;
    public static final int LOADING_COMPLETED = 7;
    public BufferedImage sourcePictureBufferedImage = null;
    private URL imageUrl = null;
    private int pictureStatusCode;
    private String pictureStatusMessage;
    public long loadTime = 0L;
    private Vector sourcePictureListeners = new Vector();
    private int percentLoaded = 0;
    protected ImageProgressListener imageProgressListener = new ImageProgressListener();
    private ImageReader reader;
    private boolean abortFlag = false;
    private double rotation = 0.0;

    SourcePicture() {
        this.setStatus(0, "Uninitialised SourcePicture object.");
    }

    public void loadPictureInThread(URL uRL, int n, double d) {
        if (this.pictureStatusCode == 1) {
            this.stopLoadingExcept(uRL);
        }
        this.imageUrl = uRL;
        this.rotation = d;
        LoadThread loadThread = new LoadThread(this);
        loadThread.setPriority(n);
        loadThread.start();
    }

    public void loadPicture(URL uRL, double d) {
        if (this.pictureStatusCode == 1) {
            this.stopLoadingExcept(uRL);
        }
        this.imageUrl = uRL;
        this.rotation = d;
        this.loadPicture();
    }

    public void loadPicture() {
        Tools.log("SourcePicture.loadPicture: " + this.imageUrl.toString() + " loaded into SourcePicture object: " + Integer.toString(this.hashCode()));
        this.setStatus(1, "Loading: " + this.imageUrl.toString());
        this.abortFlag = false;
        long l = System.currentTimeMillis();
        this.loadTime = 0L;
        try {
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(this.imageUrl.openStream());
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (!iterator.hasNext()) {
                throw new IOException("No Readers Available!");
            }
            this.reader = iterator.next();
            this.reader.addIIOReadProgressListener(this.imageProgressListener);
            this.reader.setInput(imageInputStream);
            this.sourcePictureBufferedImage = null;
            try {
                this.sourcePictureBufferedImage = this.reader.read(0);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Tools.log("SourcePicture caught an OutOfMemoryError while loading an image.");
                imageInputStream.close();
                this.reader.removeIIOReadProgressListener(this.imageProgressListener);
                this.reader.dispose();
                iterator = null;
                this.setStatus(4, "Out of Memory Error while reading " + this.imageUrl.toString());
                this.sourcePictureBufferedImage = null;
                JOptionPane.showMessageDialog(null, "outOfMemoryError", "genericError", 0);
                System.gc();
                System.runFinalization();
                Tools.log("JPO has now run a garbage collection and finalization.");
                return;
            }
            imageInputStream.close();
            this.reader.removeIIOReadProgressListener(this.imageProgressListener);
            this.reader.dispose();
            iterator = null;
            if (!this.abortFlag) {
                if (this.rotation != 0.0) {
                    this.setStatus(2, "Rotating: " + this.imageUrl.toString());
                    int n = this.sourcePictureBufferedImage.getWidth() / 2;
                    int n2 = this.sourcePictureBufferedImage.getHeight() / 2;
                    AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(this.rotation), n, n2);
                    AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
                    Rectangle2D rectangle2D = affineTransformOp.getBounds2D(this.sourcePictureBufferedImage);
                    double d = rectangle2D.getMinX();
                    double d2 = rectangle2D.getMinY();
                    AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(d * -1.0, d2 * -1.0);
                    affineTransform.preConcatenate(affineTransform2);
                    affineTransformOp = new AffineTransformOp(affineTransform, 2);
                    rectangle2D = affineTransformOp.getBounds2D(this.sourcePictureBufferedImage);
                    BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
                    this.sourcePictureBufferedImage = affineTransformOp.filter(this.sourcePictureBufferedImage, bufferedImage);
                }
                this.setStatus(3, "Loaded: " + this.imageUrl.toString());
                long l2 = System.currentTimeMillis();
                this.loadTime = l2 - l;
                PictureCache.add(this.imageUrl, (SourcePicture)this.clone());
            } else {
                this.loadTime = 0L;
                this.setStatus(4, "Aborted: " + this.imageUrl.toString());
                this.sourcePictureBufferedImage = null;
            }
        }
        catch (IOException iOException) {
            this.setStatus(4, "Error while reading " + this.imageUrl.toString());
            this.sourcePictureBufferedImage = null;
        }
    }

    public void stopLoading() {
        if (this.imageUrl == null) {
            return;
        }
        Tools.log("SourcePicture.stopLoading: called on " + String.valueOf(this.imageUrl));
        if (this.pictureStatusCode == 1) {
            this.reader.abort();
            this.abortFlag = true;
        }
    }

    public boolean stopLoadingExcept(URL uRL) {
        if (this.imageUrl == null) {
            return false;
        }
        if (this.pictureStatusCode != 1) {
            Tools.log("SourcePicture.stopLoadingExcept: called but pointless since image is not LOADING: " + this.imageUrl.toString());
            return false;
        }
        if (!uRL.equals(this.imageUrl)) {
            Tools.log("SourcePicture.stopLoadingExcept: called with Url " + uRL.toString() + " --> stopping loading of " + this.imageUrl.toString());
            this.stopLoading();
            return true;
        }
        return false;
    }

    public Dimension getSize() {
        if (this.sourcePictureBufferedImage != null) {
            return new Dimension(this.sourcePictureBufferedImage.getWidth(), this.sourcePictureBufferedImage.getHeight());
        }
        return new Dimension(0, 0);
    }

    public int getHeight() {
        if (this.sourcePictureBufferedImage != null) {
            return this.sourcePictureBufferedImage.getHeight();
        }
        return 0;
    }

    public int getWidth() {
        if (this.sourcePictureBufferedImage != null) {
            return this.sourcePictureBufferedImage.getWidth();
        }
        return 0;
    }

    public String getUrlString() {
        return this.imageUrl.toString();
    }

    public URL getUrl() {
        return this.imageUrl;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void addListener(SourcePictureListener sourcePictureListener) {
        Tools.log("SourcePicture.addListener: listener added on SourcePicture " + Integer.toString(this.hashCode()) + " of class: " + sourcePictureListener.getClass().toString());
        this.sourcePictureListeners.add(sourcePictureListener);
    }

    public void removeListener(SourcePictureListener sourcePictureListener) {
        Tools.log("SourcePicture.removeListener: listener removed from SourcePicture " + Integer.toString(this.hashCode()) + " of class: " + sourcePictureListener.getClass().toString());
        this.sourcePictureListeners.remove(sourcePictureListener);
    }

    public void showListeners() {
        Tools.log("SourcePicture.showListeners: SoucePicture " + Integer.toString(this.hashCode()));
        Enumeration enumeration = this.sourcePictureListeners.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Tools.log("    reports to Listener: " + Integer.toString(e.hashCode()) + " of class " + e.getClass().toString());
        }
        Tools.log("    --------");
    }

    public boolean hasNoListeners() {
        return this.sourcePictureListeners.isEmpty();
    }

    private void setStatus(int n, String string) {
        Tools.log("\nSourcePicture.setStatus: sending status: " + string);
        this.pictureStatusCode = n;
        this.pictureStatusMessage = string;
        Vector vector = (Vector)this.sourcePictureListeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SourcePictureListener sourcePictureListener = (SourcePictureListener)enumeration.nextElement();
            sourcePictureListener.sourceStatusChange(this.pictureStatusCode, this.pictureStatusMessage, this);
            Tools.log("\nSourcePicture.setStatus: sending status: " + string + " to " + sourcePictureListener.getClass().toString());
        }
    }

    public int getStatusCode() {
        return this.pictureStatusCode;
    }

    public String getStatusMessage() {
        return this.pictureStatusMessage;
    }

    public int getPercentLoaded() {
        return this.percentLoaded;
    }

    public BufferedImage getSourceBufferedImage() {
        return this.sourcePictureBufferedImage;
    }

    public void setSourceBufferedImage(BufferedImage bufferedImage, String string) {
        this.sourcePictureBufferedImage = bufferedImage;
        this.setStatus(3, string);
    }

    public SourcePicture getSourcePicture() {
        return this;
    }

    public void finalize() {
        Tools.log("SourcePicture.finalize: " + this.imageUrl.toString());
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Tools.log("Cloning not supported on SourcePicture!");
        }
        return object;
    }

    class ImageProgressListener
    implements IIOReadProgressListener {
        private DecimalFormat percentageFormatter = new DecimalFormat("##0");

        ImageProgressListener() {
        }

        private void notifySourceLoadProgressListeners(int n, int n2) {
            SourcePicture.this.percentLoaded = n2;
            Enumeration enumeration = SourcePicture.this.sourcePictureListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((SourcePictureListener)enumeration.nextElement()).sourceLoadProgressNotification(n, n2);
            }
        }

        @Override
        public void imageComplete(ImageReader imageReader) {
            this.notifySourceLoadProgressListeners(7, 100);
            Tools.log("imageComplete");
        }

        @Override
        public void imageProgress(ImageReader imageReader, float f) {
            this.notifySourceLoadProgressListeners(6, new Float(f).intValue());
            Tools.log("imageProgress: " + this.percentageFormatter.format(f) + "%");
        }

        @Override
        public void imageStarted(ImageReader imageReader, int n) {
            this.notifySourceLoadProgressListeners(5, 0);
            Tools.log("imageStarted");
        }

        @Override
        public void readAborted(ImageReader imageReader) {
        }

        @Override
        public void sequenceComplete(ImageReader imageReader) {
        }

        @Override
        public void sequenceStarted(ImageReader imageReader, int n) {
        }

        @Override
        public void thumbnailComplete(ImageReader imageReader) {
        }

        @Override
        public void thumbnailProgress(ImageReader imageReader, float f) {
        }

        @Override
        public void thumbnailStarted(ImageReader imageReader, int n, int n2) {
        }
    }
}

