/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.rjava;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.extension.image.GamaImageFile;
import gama.gaml.skills.Skill;
import gama.gaml.species.ISpecies;
import gama.gaml.types.Types;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RFactor;
import org.rosuda.JRI.RList;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.RVector;
import org.rosuda.JRI.Rengine;

@GamlAnnotations.skill(name="RSkill", concept={"statistic", "skill"})
public class RSkill
extends Skill {
    private final String[] args = new String[]{"--vanilla", "--slave"};
    private Rengine re = null;
    private IList<?> loadedLib = null;
    private String env;

    @GamlAnnotations.action(name="R_eval", args={@GamlAnnotations.arg(name="command", type=4, optional=true, doc={@GamlAnnotations.doc(value="R command to be evaluated")})}, doc={@GamlAnnotations.doc(value="evaluate the R command", returns="value in Gama data type", examples={@GamlAnnotations.example(value=" R_eval(\"data(iris)\")")})})
    public Object primREval(IScope iScope) throws GamaRuntimeException {
        Pattern pattern = Pattern.compile(System.lineSeparator() + "|;");
        String[] stringArray = pattern.split(iScope.getStringArg("command"));
        REXP rEXP = null;
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].trim();
            if (!string.isBlank()) {
                rEXP = this.Reval(iScope, string);
            }
            ++n;
        }
        return this.dataConvert_R2G(rEXP);
    }

    @GamlAnnotations.action(name="R_eval_script", args={@GamlAnnotations.arg(name="file_path", type=4, optional=true, doc={@GamlAnnotations.doc(value="Path to the R script file to be evaluated")})}, doc={@GamlAnnotations.doc(value="evaluate the R script contained at the operand path", returns="value in Gama data type", examples={@GamlAnnotations.example(value=" R_eval_script(RCode.path)")})})
    public Object primREvalScript(IScope iScope) throws GamaRuntimeException {
        String string = "";
        try {
            string = new File(iScope.getStringArg("file_path")).getCanonicalPath().replace("\\", "\\\\");
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create((Throwable)iOException, (IScope)iScope);
        }
        REXP rEXP = this.Reval(iScope, "source(\"" + string + "\")");
        return this.dataConvert_R2G(rEXP);
    }

    @GamlAnnotations.action(name="startR", doc={@GamlAnnotations.doc(value="evaluate the R command")})
    public String startR(IScope iScope2) {
        this.initEnv(iScope2);
        this.re = Rengine.getMainEngine();
        if (this.re == null) {
            this.re = new Rengine(this.args, false, (RMainLoopCallbacks)new TextConsole());
            if (this.loadedLib == null) {
                this.loadedLib = (IList)this.dataConvert_R2G(this.re.eval("search()"));
            }
        } else {
            iScope2.getSimulation().postDisposeAction(iScope -> {
                IList iList = (IList)this.dataConvert_R2G(this.re.eval("search()"));
                int n = 0;
                while (n < iList.size()) {
                    if (((String)iList.get(n)).contains("package:") && this.loadedLib != null && !this.loadedLib.contains(iList.get(n))) {
                        this.re.eval("detach(\"" + String.valueOf(iList.get(n)) + "\")");
                    }
                    ++n;
                }
                this.re.idleEval("rm(list=ls(all=TRUE))");
                this.re.idleEval("gc()");
                return null;
            });
        }
        return "R started";
    }

    @GamlAnnotations.operator(value={"to_R_data"}, content_type=16, index_type=-299, category={"Graphs-related operators"}, concept={"statistic", "cast"})
    @GamlAnnotations.doc(value="to_R_data(speciesname)", masterDoc=true, comment="convert agent attributes to data type of R", examples={@GamlAnnotations.example(value="to_R_data(people)", isExecutable=false)}, see={"R_eval"})
    public static Object toRData(IScope iScope, Object object) {
        return RSkill.dataConvert_G2R(object);
    }

    @GamlAnnotations.operator(value={"to_R_dataframe"}, content_type=16, index_type=-299, category={"Graphs-related operators"}, concept={"statistic", "cast"})
    @GamlAnnotations.doc(value="to_R_dataframe(speciesname)", masterDoc=true, comment="convert agent attributes to dataframe of R", examples={@GamlAnnotations.example(value="to_R_dataframe(people)", isExecutable=false)}, see={"R_eval"})
    public static String toRDataFrame(IScope iScope, ISpecies iSpecies) {
        Object object2;
        ArrayList arrayList = new ArrayList(iSpecies.getAttributeNames(iScope));
        arrayList.remove("host");
        arrayList.remove("peers");
        arrayList.remove("shape");
        Collections.sort(arrayList);
        IList iList = iSpecies.getAgents(iScope).listValue(iScope, Types.AGENT, false);
        ArrayList arrayList2 = new ArrayList();
        for (Object object2 : iList) {
            int n = 0;
            for (String string : arrayList) {
                Object object3 = object2.getDirectVarValue(iScope, string);
                ArrayList<Object> arrayList3 = null;
                if (arrayList2.size() > n) {
                    arrayList3 = (ArrayList<Object>)arrayList2.get(n);
                }
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList<Object>();
                    arrayList3.add(string);
                    arrayList2.add(arrayList3);
                }
                arrayList3.add(object3);
                ++n;
            }
        }
        object2 = "data.frame(";
        for (List list : arrayList2) {
            object2 = (String)object2 + String.valueOf(list.get(0)) + "=c(";
            list.remove(0);
            for (String string : list) {
                object2 = (String)object2 + String.valueOf(RSkill.dataConvert_G2R(string)) + ",";
            }
            if (list.size() > 0) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
            }
            object2 = (String)object2 + "),";
        }
        if (arrayList2.size() > 0) {
            object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
        }
        object2 = (String)object2 + ")";
        return object2;
    }

    public static Object dataConvert_G2R(Object object) {
        Object object2 = "\"" + object.toString() + "\"";
        if (object instanceof Integer || object instanceof Double) {
            object2 = object.toString();
        }
        if (object instanceof Boolean) {
            Object object3 = object2 = (Boolean)object != false ? "TRUE" : "FALSE";
        }
        if (object instanceof GamaColor) {
            object2 = "\"" + ((GamaColor)object).stringValue(null) + "\"";
        }
        if (object instanceof GamaImageFile) {
            object2 = "\"" + ((GamaImageFile)object).getPath(null) + "\"";
        }
        if (object instanceof GamaPoint) {
            object2 = "\"" + ((GamaPoint)object).x + "," + ((GamaPoint)object).y + "\"";
        }
        if (object instanceof GamaShape) {
            object2 = "\"" + ((GamaShape)object).getLocation().x + "," + ((GamaShape)object).getLocation().y + "\"";
        }
        if (object instanceof IList) {
            object2 = "c(";
            for (Object e : (IList)object) {
                object2 = String.valueOf(object2) + String.valueOf(e) + ",";
            }
            if (((String)object2).length() > 2) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                object2 = String.valueOf(object2) + ")";
            } else {
                object2 = "\"\"";
            }
        }
        return object2;
    }

    public void initEnv(IScope iScope) {
        this.env = System.getProperty("java.library.path");
        if (!this.env.contains("jri")) {
            throw GamaRuntimeException.error((String)"The path to the JRI is not set. Add the option -Djava.library.path=a_path to  your  GAMA.ini file (see the documentation for more details).", (IScope)iScope);
        }
        if (System.getenv("R_HOME") == null) {
            throw GamaRuntimeException.error((String)"The R_HOME environment variable is not set. R cannot be run.", (IScope)iScope);
        }
    }

    public REXP Reval(IScope iScope, String string) {
        try {
            this.re = Rengine.getMainEngine();
            if (this.re == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error((String)"R cannot be found ...", (IScope)iScope);
        }
        return this.re.eval(string);
    }

    public Object dataConvert_R2G(Object object) {
        if (!(object instanceof REXP)) {
            return object;
        }
        REXP rEXP = (REXP)object;
        if (rEXP.getType() == 34) {
            String[] stringArray = rEXP.asStringArray();
            IList iList = GamaListFactory.create();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                iList.add(this.dataConvert_R2G(string));
                ++n2;
            }
            return iList;
        }
        if (rEXP.getType() == 17) {
            RList rList = rEXP.asList();
            IList iList = GamaListFactory.create();
            int n = 0;
            while (n < rList.keys().length) {
                iList.add(this.dataConvert_R2G(rList.at(0)));
                ++n;
            }
            return iList;
        }
        if (rEXP.getType() == 37) {
            int[] nArray = rEXP.asIntArray();
            IList iList = GamaListFactory.create();
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n3 = 0;
            while (n3 < n) {
                int n4 = nArray2[n3];
                iList.add((Object)(n4 != 0 ? 1 : 0));
                ++n3;
            }
            return iList;
        }
        if (rEXP.getType() == 33) {
            double[] dArray = rEXP.asDoubleArray();
            IList iList = GamaListFactory.create();
            double[] dArray2 = dArray;
            int n = dArray.length;
            int n5 = 0;
            while (n5 < n) {
                double d = dArray2[n5];
                iList.add((Object)d);
                ++n5;
            }
            return iList;
        }
        if (rEXP.getType() == 32) {
            int[] nArray = rEXP.asIntArray();
            IList iList = GamaListFactory.create();
            int[] nArray3 = nArray;
            int n = nArray.length;
            int n6 = 0;
            while (n6 < n) {
                int n7 = nArray3[n6];
                iList.add((Object)n7);
                ++n6;
            }
            return iList;
        }
        if (rEXP.getType() == 3) {
            return rEXP.getContent();
        }
        if (rEXP.getType() == 127) {
            RFactor rFactor = rEXP.asFactor();
            IList iList = GamaListFactory.create();
            int n = 0;
            while (n < rFactor.size()) {
                iList.add(this.dataConvert_R2G(rFactor.at(n)));
                ++n;
            }
            return iList;
        }
        if (rEXP.getType() == 16) {
            RVector rVector = rEXP.asVector();
            IList iList = GamaListFactory.create();
            int n = 0;
            while (n < rVector.size()) {
                iList.add(this.dataConvert_R2G(rVector.at(n)));
                ++n;
            }
            return iList;
        }
        return rEXP;
    }

    static class TextConsole
    implements RMainLoopCallbacks {
        TextConsole() {
        }

        public void rWriteConsole(Rengine rengine, String string, int n) {
            GAMA.getGui().getConsole().informConsole("R>" + string, null);
        }

        public void rBusy(Rengine rengine, int n) {
            System.out.println("rBusy(" + n + ")");
        }

        public String rReadConsole(Rengine rengine, String string, int n) {
            System.out.print(string);
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String string2 = bufferedReader.readLine();
                return string2 == null || string2.length() == 0 ? string2 : string2 + "\n";
            }
            catch (Exception exception) {
                System.out.println("jriReadConsole exception: " + exception.getMessage());
                return null;
            }
        }

        public void rShowMessage(Rengine rengine, String string) {
            System.out.println("rShowMessage \"" + string + "\"");
        }

        public String rChooseFile(Rengine rengine, int n) {
            FileDialog fileDialog = new FileDialog(new Frame(), n == 0 ? "Select a file" : "Select a new file", n == 0 ? 0 : 1);
            fileDialog.setVisible(true);
            String string = null;
            if (fileDialog.getDirectory() != null) {
                string = fileDialog.getDirectory();
            }
            if (fileDialog.getFile() != null) {
                string = string == null ? fileDialog.getFile() : string + fileDialog.getFile();
            }
            return string;
        }

        public void rFlushConsole(Rengine rengine) {
        }

        public void rLoadHistory(Rengine rengine, String string) {
        }

        public void rSaveHistory(Rengine rengine, String string) {
        }

        public long rExecJCommand(Rengine rengine, String string, long l, int n) {
            System.out.println("rExecJCommand \"" + string + "\"");
            return 0L;
        }

        public void rProcessJEvents(Rengine rengine) {
        }
    }
}

