/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.switchproject.gama.util.deque;

import gama.core.common.util.StringUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.core.util.matrix.IMatrix;
import gama.gaml.types.GamaIntegerType;
import gama.gaml.types.GamaMatrixType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GamaDeque<T>
extends ArrayDeque<T>
implements IContainer<Integer, Object> {
    private static final long serialVersionUID = 1L;
    protected IContainerType<?> type;

    public GamaDeque(IContainerType<?> iContainerType) {
        this.type = iContainerType;
    }

    public GamaDeque(IContainerType<?> iContainerType, List<T> list) {
        this.type = iContainerType;
        this.addAll(list);
    }

    public GamaDeque(IContainerType<?> iContainerType, T[] TArray) {
        this.type = iContainerType;
        this.addAll(TArray);
    }

    public GamaDeque(IContainerType<?> iContainerType, Collection<T> collection) {
        this.type = iContainerType;
        this.addAll(collection);
    }

    public GamaDeque(GamaDeque<T> gamaDeque) {
        super(gamaDeque.clone());
        this.type = gamaDeque.getGamlType();
    }

    private void addAll(List<T> list) {
        for (T t : list) {
            this.add(t);
        }
    }

    private void addAll(T[] TArray) {
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray2[n2];
            this.add(t);
            ++n2;
        }
    }

    public T buildValue(IScope iScope, Object object) {
        IType iType = this.getGamlType().getContentType();
        return (T)iType.cast(iScope, object, null, false);
    }

    public GamaDeque<T> buildValues(IScope iScope, IContainer<?, ?> iContainer) {
        return (GamaDeque)this.getGamlType().cast(iScope, iContainer, null, false);
    }

    public Integer buildIndex(IScope iScope, Object object) {
        return GamaIntegerType.staticCast((IScope)iScope, (Object)object, null, (boolean)false);
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.serialize(false);
    }

    public String serialize(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(this.size() * 10);
        Object[] objectArray = this.toArray();
        stringBuilder.append('[');
        int n = 0;
        while (n < this.size()) {
            if (n != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(StringUtils.toGaml((Object)objectArray[n], (boolean)bl));
            ++n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public JsonValue serializeToJson(Json json) {
        return json.array((Collection)this);
    }

    public GamaDeque<T> copy(IScope iScope) throws GamaRuntimeException {
        return new GamaDeque<T>(this);
    }

    public IContainerType<?> getGamlType() {
        return this.type;
    }

    public boolean contains(IScope iScope, Object object) throws GamaRuntimeException {
        return this.contains(object);
    }

    public boolean containsKey(IScope iScope, Object object) throws GamaRuntimeException {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n >= 0 && n < this.size();
        }
        return false;
    }

    public T firstValue(IScope iScope) throws GamaRuntimeException {
        return (T)this.getFirst();
    }

    public T lastValue(IScope iScope) throws GamaRuntimeException {
        return (T)this.getLast();
    }

    public T anyValue(IScope iScope) {
        int n = iScope.getRandom().between(0, 1);
        return (T)(n == 0 ? this.getFirst() : this.getLast());
    }

    public int length(IScope iScope) {
        return this.size();
    }

    public boolean isEmpty(IScope iScope) {
        return this.isEmpty();
    }

    public IList<Object> listValue(IScope iScope, IType iType, boolean bl) {
        List<Object> list = Arrays.asList(this.toArray());
        return GamaListFactory.wrap((IType)iType, list);
    }

    public Iterable<? extends T> iterable(IScope iScope) {
        return this.listValue(iScope, Types.NO_TYPE, false);
    }

    public IContainer<?, ?> reverse(IScope iScope) throws GamaRuntimeException {
        List<Object> list = Arrays.asList(this.toArray());
        Collections.reverse(list);
        return new GamaDeque<Object>(this.type, list);
    }

    public <D, C> IMap<C, D> mapValue(IScope iScope, IType<C> iType, IType<D> iType2, boolean bl) {
        IMap iMap = GamaMapFactory.create(iType, iType2);
        iMap.setAllValues(iScope, (Object)this.toArray());
        return iMap;
    }

    public IMatrix<?> matrixValue(IScope iScope, IType<?> iType, boolean bl) {
        return this.matrixValue(iScope, iType, null, bl);
    }

    public IMatrix<?> matrixValue(IScope iScope, IType<?> iType, GamaPoint gamaPoint, boolean bl) {
        return GamaMatrixType.from((IScope)iScope, this.listValue(iScope, iType, bl), iType, (GamaPoint)gamaPoint);
    }
}

