/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.switchproject.gama.util.event_manager;

import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaDate;
import gama.core.util.GamaMap;
import gama.core.util.IList;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import gama.gaml.types.IType;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.UUID;

public class Event {
    UUID id = null;
    private GamaDate date;
    private long milli;
    private IScope scope;
    private String species;
    private IStatement.WithArgs action;
    private Arguments arguments;
    private IAgent referredAgent;
    private IAgent agent;
    private boolean isAlive;

    public Event(IScope iScope, IAgent iAgent, ActionDescription actionDescription, GamaMap<String, Object> gamaMap, GamaDate gamaDate, IAgent iAgent2) {
        this.scope = iScope.copy("Later");
        this.species = iAgent.getSpeciesName();
        this.agent = iAgent;
        this.referredAgent = iAgent2;
        this.isAlive = true;
        this.id = UUID.randomUUID();
        this.arguments = actionDescription.createCompiledArgs().resolveAgainst(iScope);
        IList iList = gamaMap.getKeys();
        for (String string : iList) {
            IType iType = this.scope.getType(string);
            Object object = iType.cast(this.scope, gamaMap.get((Object)string), null, true);
            this.scope.addVarWithValue(string, object);
        }
        this.setAction(actionDescription.getName());
        this.setDate(gamaDate);
    }

    private void setDate(GamaDate gamaDate) throws GamaRuntimeException {
        if (gamaDate != null) {
            this.date = gamaDate.copy(this.scope);
            this.milli = gamaDate.getLocalDateTime().atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
        } else {
            this.date = null;
            this.milli = 0L;
        }
    }

    private void setAction(String string) throws GamaRuntimeException {
        ISpecies iSpecies = this.getSpecies();
        if (iSpecies == null) {
            throw GamaRuntimeException.error((String)("Impossible to find a species to execute " + string), (IScope)this.scope);
        }
        this.action = iSpecies.getAction(string);
        if (this.action == null) {
            throw GamaRuntimeException.error((String)("Impossible to find action " + string + " in " + String.valueOf(iSpecies)), (IScope)this.scope);
        }
    }

    private Arguments getRuntimeArgs() throws GamaRuntimeException {
        if (this.arguments == null) {
            return null;
        }
        return this.arguments.resolveAgainst(this.scope);
    }

    private ISpecies getSpecies() throws GamaRuntimeException {
        return this.species != null ? this.scope.getModel().getSpecies(this.species) : this.scope.getAgent().getSpecies();
    }

    public GamaDate getDate() {
        return this.date;
    }

    public IScope getScope() {
        return this.scope;
    }

    public long getMilli() {
        return this.milli;
    }

    public IAgent getAgent() {
        return this.agent;
    }

    public UUID getId() {
        return this.id;
    }

    public boolean isGreaterThan(Event event) {
        return this.milli > event.milli;
    }

    public boolean isTimeReached() {
        return this.scope.getClock().getCurrentDate().isGreaterThan(this.date, false);
    }

    public boolean execute() {
        if (!this.isAlive) {
            return false;
        }
        if (this.date == null) {
            this.date = this.scope.getClock().getCurrentDate();
        }
        this.scope.getAgent().setAttribute("event_date", (Object)this.date);
        this.scope.getAgent().setAttribute("refer_to", (Object)this.referredAgent);
        if (this.referredAgent == null) {
            this.scope.execute((IExecutable)this.action, this.getRuntimeArgs()).getValue();
        } else {
            this.scope.execute((IExecutable)this.action, this.referredAgent, true, this.getRuntimeArgs()).getValue();
        }
        return true;
    }

    public void kill() {
        this.isAlive = false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.action.getName());
        stringBuilder.append(" of ");
        stringBuilder.append(this.getAgent());
        stringBuilder.append(" with ");
        stringBuilder.append(this.arguments.toString());
        stringBuilder.append(" at ");
        stringBuilder.append(this.date);
        return stringBuilder.toString();
    }

    public static class EventComparator
    implements Comparator<Event> {
        IScope scope;

        EventComparator(IScope iScope) {
            this.scope = iScope;
        }

        @Override
        public int compare(Event event, Event event2) {
            if (event.milli < event2.milli) {
                return -1;
            }
            if (event.milli > event2.milli) {
                return 1;
            }
            return this.scope.getRandom().between(0, 1) < 1 ? -1 : 1;
        }
    }
}

