/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.switchproject.gama.util.event_manager;

import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaDate;
import gama.experimental.switchproject.gama.util.event_manager.Event;
import gama.experimental.switchproject.gama.util.event_manager.EventQueue;
import java.util.UUID;

public class EventManager
extends EventQueue {
    private static final long serialVersionUID = 1L;
    private boolean executeActive = false;
    private Event lastEvent = null;
    private int queueSize = 0;

    public EventManager(IScope iScope) {
        super(new Event.EventComparator(iScope));
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public String register(IScope iScope, Event event) throws GamaRuntimeException {
        if (event.getAgent().dead()) {
            return null;
        }
        if (event.getDate() == null) {
            event.execute();
            return null;
        }
        if (this.executeActive) {
            if (this.lastEvent.isGreaterThan(event)) {
                throw GamaRuntimeException.warning((String)("Exec: Past is not allowed " + String.valueOf(this.lastEvent.getDate()) + " vs " + String.valueOf(event.getDate())), (IScope)iScope);
            }
        } else {
            GamaDate gamaDate = iScope.getSimulation().getClock().getCurrentDate();
            if (gamaDate.isGreaterThan(event.getDate(), true)) {
                throw GamaRuntimeException.warning((String)("Past is not allowed " + String.valueOf(iScope.getSimulation().getClock().getCurrentDate()) + " vs " + String.valueOf(event.getDate())), (IScope)iScope);
            }
        }
        this.add(event);
        this.eventMap.put(event.getId(), event);
        ++this.queueSize;
        return event.getId().toString();
    }

    public Object execute(IScope iScope) throws GamaRuntimeException {
        this.executeActive = true;
        while (this.size() > 0 && this.isTimeReached()) {
            this.lastEvent = (Event)this.poll();
            this.eventMap.remove(this.lastEvent.getId());
            if (!this.lastEvent.getAgent().dead()) {
                if (!this.lastEvent.execute()) continue;
                --this.queueSize;
                continue;
            }
            --this.queueSize;
        }
        this.executeActive = false;
        return true;
    }

    public void kill(IScope iScope, String string) {
        Event event = (Event)this.eventMap.get(UUID.fromString(string));
        if (event != null) {
            event.kill();
        }
        --this.queueSize;
    }
}

