/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.switchproject.gaml.architecure.event_manager;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaDate;
import gama.core.util.GamaMap;
import gama.experimental.switchproject.gama.util.event_manager.Event;
import gama.experimental.switchproject.gama.util.event_manager.EventManager;
import gama.gaml.architecture.reflex.ReflexArchitecture;
import gama.gaml.descriptions.ActionDescription;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="size", type=1, doc={@GamlAnnotations.doc(value="Return the size of the all queues")})})
@GamlAnnotations.skill(name="event_manager", concept={"behavior", "architecture"}, doc={@GamlAnnotations.doc(value="Event manager behavior")})
public class EventManagerArchitecture
extends ReflexArchitecture {
    @GamlAnnotations.getter(value="size")
    public int getQueueSize(IAgent iAgent) {
        return this.getCurrentManagerIfExists(iAgent).getQueueSize();
    }

    public Object executeOn(IScope iScope) throws GamaRuntimeException {
        super.executeOn(iScope);
        return this.executeCurrentManager(iScope);
    }

    public boolean init(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        EventManager eventManager = new EventManager(iScope);
        iAgent.setAttribute("event_manager", (Object)eventManager);
        return true;
    }

    protected Object executeCurrentManager(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        if (iScope.interrupted() || iAgent == null) {
            return null;
        }
        return this.getCurrentManagerIfExists(iAgent).execute(iScope);
    }

    protected EventManager getCurrentManager(IAgent iAgent) throws GamaRuntimeException {
        return (EventManager)iAgent.getAttribute("event_manager");
    }

    protected EventManager getCurrentManagerIfExists(IAgent iAgent) throws GamaRuntimeException {
        EventManager eventManager = this.getCurrentManager(iAgent);
        if (eventManager == null) {
            throw GamaRuntimeException.error((String)"No event manager agent was detected", (IScope)iAgent.getScope());
        }
        return eventManager;
    }

    public String register(IScope iScope, IAgent iAgent, ActionDescription actionDescription, GamaMap<String, Object> gamaMap, GamaDate gamaDate, IAgent iAgent2) throws GamaRuntimeException {
        IAgent iAgent3 = (IAgent)this.getCurrentAgent(iScope).getAttribute("event_manager");
        if (iScope.interrupted() || iAgent3 == null) {
            return null;
        }
        return this.getCurrentManagerIfExists(iAgent3).register(iScope, new Event(iScope, iAgent, actionDescription, gamaMap, gamaDate, iAgent2));
    }

    public Object kill(IScope iScope, String string) throws GamaRuntimeException {
        IAgent iAgent = (IAgent)this.getCurrentAgent(iScope).getAttribute("event_manager");
        if (iScope.interrupted() || iAgent == null) {
            return false;
        }
        this.getCurrentManagerIfExists(iAgent).kill(iScope, string);
        return true;
    }
}

