/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.switchproject.gaml.skills.logging;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.skills.Skill;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.data.json.impl.JSONArray;
import org.jfree.data.json.impl.JSONObject;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="log_data", type=0, doc={@GamlAnnotations.doc(value="Logbook data")})})
@GamlAnnotations.skill(name="logging", concept={"logging", "skill"}, internal=true)
public class LoggingSkill
extends Skill {
    @GamlAnnotations.getter(value="log_data")
    public Object getLogData(IAgent iAgent) {
        if (iAgent == null) {
            return null;
        }
        return (JSONObject)iAgent.getAttribute("log_data");
    }

    @GamlAnnotations.action(name="log_plot_1d", args={@GamlAnnotations.arg(name="section", type=4, optional=false, doc={@GamlAnnotations.doc(value="The name of the section")}), @GamlAnnotations.arg(name="entry", type=4, optional=false, doc={@GamlAnnotations.doc(value="The name of the entry")}), @GamlAnnotations.arg(name="x", type=4, optional=false, doc={@GamlAnnotations.doc(value="X data")})}, doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do log_plot_2d section: name data: \"Mean speed\" x: my_date")}, value="Write new line in logbook.")})
    public Object logPlot1d(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getArg("section", 4);
        String string2 = (String)iScope.getArg("entry", 4);
        String string3 = (String)iScope.getArg("x", 4);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date date = new Date(System.currentTimeMillis());
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"name", (Object)string2);
        jSONObject.put((Object)"type", (Object)"1d");
        jSONObject.put((Object)"date", (Object)simpleDateFormat.format(date));
        jSONObject.put((Object)"x", (Object)string3);
        return this.log(iScope, string, jSONObject);
    }

    @GamlAnnotations.action(name="log_plot_2d", args={@GamlAnnotations.arg(name="section", type=4, optional=false, doc={@GamlAnnotations.doc(value="The name of the section")}), @GamlAnnotations.arg(name="entry", type=4, optional=false, doc={@GamlAnnotations.doc(value="The name of the entry")}), @GamlAnnotations.arg(name="x", type=4, optional=false, doc={@GamlAnnotations.doc(value="X data")}), @GamlAnnotations.arg(name="y", type=4, optional=false, doc={@GamlAnnotations.doc(value="Y data")})}, doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do log_plot_2d section: name data: \"Mean speed\" x: my_date y: 30.2")}, value="Write new line in logbook.")})
    public Object logPlot2d(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getArg("section", 4);
        String string2 = (String)iScope.getArg("entry", 4);
        String string3 = (String)iScope.getArg("x", 4);
        String string4 = (String)iScope.getArg("y", 4);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date date = new Date(System.currentTimeMillis());
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"name", (Object)string2);
        jSONObject.put((Object)"type", (Object)"2d");
        jSONObject.put((Object)"date", (Object)simpleDateFormat.format(date));
        jSONObject.put((Object)"x", (Object)string3);
        jSONObject.put((Object)"y", (Object)string4);
        return this.log(iScope, string, jSONObject);
    }

    @GamlAnnotations.action(name="write", args={@GamlAnnotations.arg(name="file_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="File name")}), @GamlAnnotations.arg(name="flush", type=3, optional=true, doc={@GamlAnnotations.doc(value="Flush data if true")})}, doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do write file_name: \"log.txt\" flush: true;")}, value="Write data in file.")})
    public Object write(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getArg("file_name", 4);
        Boolean bl = (Boolean)iScope.getArg("flush", 3);
        FileWriter fileWriter = null;
        IAgent iAgent = iScope.getAgent();
        JSONObject jSONObject = (JSONObject)iAgent.getAttribute("log_data");
        if (jSONObject == null) {
            return false;
        }
        String string2 = FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)string, (boolean)false);
        try {
            try {
                fileWriter = new FileWriter(string2);
                fileWriter.write(jSONObject.toJSONString());
            }
            catch (IOException iOException) {
                throw GamaRuntimeException.error((String)iOException.getMessage(), (IScope)iScope);
            }
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.flush();
                    fileWriter.close();
                }
            }
            catch (IOException iOException) {
                throw GamaRuntimeException.error((String)iOException.getMessage(), (IScope)iScope);
            }
        }
        if (bl.booleanValue()) {
            jSONObject.clear();
        }
        return true;
    }

    @GamlAnnotations.action(name="flush", doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do flush;")}, value="Flush data.")})
    public Object flush(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        JSONObject jSONObject = (JSONObject)iAgent.getAttribute("log_data");
        jSONObject.clear();
        return true;
    }

    public Object log(IScope iScope, String string, JSONObject jSONObject) throws GamaRuntimeException {
        JSONArray jSONArray;
        IAgent iAgent = iScope.getAgent();
        JSONObject jSONObject2 = (JSONObject)iAgent.getAttribute("log_data");
        if (jSONObject2 == null) {
            jSONObject2 = new JSONObject();
            iAgent.setAttribute("log_data", (Object)jSONObject2);
        }
        if ((jSONArray = (JSONArray)jSONObject2.get((Object)string)) == null) {
            jSONArray = new JSONArray();
            jSONObject2.put((Object)string, (Object)jSONArray);
        }
        return jSONArray.add((Object)jSONObject);
    }
}

