/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.switchproject.gaml.skills.traffic;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.path.IPath;
import gama.gaml.operators.Cast;
import gama.gaml.skills.MovingSkill;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="desired_speed", type=2, init="30.0", doc={@GamlAnnotations.doc(value="The desired speed of the vehicle")}), @GamlAnnotations.variable(name="spacing", type=2, init="1.0", doc={@GamlAnnotations.doc(value="The jam distance")}), @GamlAnnotations.variable(name="reaction_time", type=2, init="1.5", doc={@GamlAnnotations.doc(value="The reaction time of the vehicle")}), @GamlAnnotations.variable(name="max_acceleration", type=2, init="4.0", doc={@GamlAnnotations.doc(value="The maximum acceleration of the vehicle")}), @GamlAnnotations.variable(name="desired_deceleration", type=2, init="3.0", doc={@GamlAnnotations.doc(value="The desired deceleration of the vehicle")}), @GamlAnnotations.variable(name="acceleration", type=2, init="0.0", doc={@GamlAnnotations.doc(value="The acceleration of the vehicle")}), @GamlAnnotations.variable(name="delta_speed", type=2, init="0.0", doc={@GamlAnnotations.doc(value="The acceleration of the vehicle")}), @GamlAnnotations.variable(name="actual_gap", type=2, init="0.0", doc={@GamlAnnotations.doc(value="The acceleration of the vehicle")}), @GamlAnnotations.variable(name="desired_minimum_gap", type=2, init="0.0", doc={@GamlAnnotations.doc(value="The acceleration of the vehicle")}), @GamlAnnotations.variable(name="length", type=2, init="5.0", doc={@GamlAnnotations.doc(value="The length of the vehicle")})})
@GamlAnnotations.skill(name="idm", concept={"idm", "skill"}, internal=true)
public class IdmSkill
extends MovingSkill {
    @GamlAnnotations.getter(value="desired_speed")
    public double getDesiredSpeed(IAgent iAgent) {
        if (iAgent == null) {
            return 0.0;
        }
        return (Double)iAgent.getAttribute("desired_speed");
    }

    @GamlAnnotations.getter(value="spacing")
    public double getSpacing(IAgent iAgent) {
        if (iAgent == null) {
            return 0.0;
        }
        return (Double)iAgent.getAttribute("spacing");
    }

    @GamlAnnotations.getter(value="reaction_time")
    public double getReactionTime(IAgent iAgent) {
        if (iAgent == null) {
            return 0.0;
        }
        return (Double)iAgent.getAttribute("reaction_time");
    }

    @GamlAnnotations.getter(value="max_acceleration")
    public double getMaxAcceleration(IAgent iAgent) {
        if (iAgent == null) {
            return 0.0;
        }
        return (Double)iAgent.getAttribute("max_acceleration");
    }

    @GamlAnnotations.getter(value="desired_deceleration")
    public double getDesiredDeceleration(IAgent iAgent) {
        if (iAgent == null) {
            return 0.0;
        }
        return (Double)iAgent.getAttribute("desired_deceleration");
    }

    @GamlAnnotations.getter(value="acceleration")
    public double getAcceleration(IAgent iAgent) {
        if (iAgent == null) {
            return 0.0;
        }
        return (Double)iAgent.getAttribute("acceleration");
    }

    @GamlAnnotations.getter(value="delta_speed")
    public double getDeltaSpeed(IAgent iAgent) {
        if (iAgent == null) {
            return 0.0;
        }
        return (Double)iAgent.getAttribute("delta_speed");
    }

    @GamlAnnotations.getter(value="actual_gap")
    public double getActualGap(IAgent iAgent) {
        if (iAgent == null) {
            return 0.0;
        }
        return (Double)iAgent.getAttribute("actual_gap");
    }

    @GamlAnnotations.getter(value="desired_minimum_gap")
    public double getDesiredMinimumGap(IAgent iAgent) {
        if (iAgent == null) {
            return 0.0;
        }
        return (Double)iAgent.getAttribute("desired_minimum_gap");
    }

    @GamlAnnotations.getter(value="length")
    public double getLength(IAgent iAgent) {
        if (iAgent == null) {
            return 0.0;
        }
        return (Double)iAgent.getAttribute("length");
    }

    @GamlAnnotations.setter(value="desired_speed")
    public void setDesiredSpeed(IAgent iAgent, double d) {
        if (iAgent == null) {
            return;
        }
        iAgent.setAttribute("desired_speed", (Object)d);
    }

    @GamlAnnotations.setter(value="spacing")
    public void setSpacing(IAgent iAgent, double d) {
        if (iAgent == null) {
            return;
        }
        iAgent.setAttribute("spacing", (Object)d);
    }

    @GamlAnnotations.setter(value="reaction_time")
    public void setReactionTime(IAgent iAgent, double d) {
        if (iAgent == null) {
            return;
        }
        iAgent.setAttribute("reaction_time", (Object)d);
    }

    @GamlAnnotations.setter(value="max_acceleration")
    public void setMaxAcceleration(IAgent iAgent, double d) {
        if (iAgent == null) {
            return;
        }
        iAgent.setAttribute("max_acceleration", (Object)d);
    }

    @GamlAnnotations.setter(value="desired_deceleration")
    public void setDesiredDeceleration(IAgent iAgent, double d) {
        if (iAgent == null) {
            return;
        }
        iAgent.setAttribute("desired_deceleration", (Object)d);
    }

    @GamlAnnotations.setter(value="length")
    public void setLength(IAgent iAgent, double d) {
        if (iAgent == null) {
            return;
        }
        iAgent.setAttribute("length", (Object)d);
    }

    @GamlAnnotations.action(name="goto", args={@GamlAnnotations.arg(name="target", type=13, optional=false, doc={@GamlAnnotations.doc(value="the location or entity towards which to move.")}), @GamlAnnotations.arg(name="on", type=0, optional=true, doc={@GamlAnnotations.doc(value="graph, topology, list of geometries or map of geometries that restrain this move")}), @GamlAnnotations.arg(name="follow", type=11, optional=true, doc={@GamlAnnotations.doc(value="the agent to folow")}), @GamlAnnotations.arg(name="desired_speed", type=2, optional=true, doc={@GamlAnnotations.doc(value="the desired speed.")})}, doc={@GamlAnnotations.doc(value="moves the agent towards the target passed in the arguments.", returns="optional: the path followed by the agent.", examples={@GamlAnnotations.example(value="do goto target: (one_of road).location follow: next_car on: road_network;")})})
    public IPath<?, ?, ?> oneStep(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        IAgent iAgent2 = (IAgent)iScope.getArg("follow", 11);
        if (iScope.hasArg("desired_speed")) {
            double d = (Double)iScope.getArg("desired_speed", 2);
            iAgent.setAttribute("desired_speed", (Object)d);
        }
        iAgent.setAttribute("speed", (Object)this.idmOneStep(iScope, iAgent, iAgent2, this.getTopology(iScope)));
        return this.primGoto(iScope);
    }

    protected ITopology getTopology(IScope iScope) {
        Object object = iScope.getArg("on", 0);
        ITopology iTopology = Cast.asTopology((IScope)iScope, (Object)object);
        if (iTopology == null) {
            return iScope.getTopology();
        }
        return iTopology;
    }

    protected double idmOneStep(IScope iScope, IAgent iAgent, IAgent iAgent2, ITopology iTopology) {
        double d = (Double)iAgent.getAttribute("max_acceleration");
        double d2 = (Double)iAgent.getAttribute("desired_deceleration");
        double d3 = (Double)iAgent.getAttribute("speed");
        double d4 = (Double)iAgent.getAttribute("desired_speed");
        if (iAgent2 == null || iAgent2.dead()) {
            return this.computeAsLeader(iScope, iAgent, d2, d, d3, d4);
        }
        double d5 = iTopology.distanceBetween(iScope, (IShape)iAgent, (IShape)iAgent2);
        if (iTopology.distanceBetween(iScope, (IShape)iAgent, (IShape)iAgent2) == Double.MAX_VALUE) {
            return this.computeAsLeader(iScope, iAgent, d2, d, d3, d4);
        }
        double d6 = (Double)iAgent.getAttribute("spacing");
        double d7 = (Double)iAgent.getAttribute("reaction_time");
        double d8 = (Double)iAgent.getAttribute("length");
        double d9 = (Double)iAgent2.getAttribute("speed");
        double d10 = (Double)iAgent2.getAttribute("length");
        double d11 = d9 - d3;
        double d12 = d5 - (d8 / 2.0 + d10 / 2.0);
        double d13 = d6 + d7 * d3 - d3 * d11 / (2.0 * Math.sqrt(d * d2));
        double d14 = d3 / d4;
        double d15 = d13 / d12;
        double d16 = d * (1.0 - d14 * d14 * d14 * d14 - d15 * d15);
        return this.setValuesAndComputeSpeed(iScope, iAgent, d16, d2, d, d3, d11, d12, d13);
    }

    protected double setValuesAndComputeSpeed(IScope iScope, IAgent iAgent, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d < -d2) {
            d = -d2;
        } else if (d > d3) {
            d = d3;
        }
        iAgent.setAttribute("delta_speed", (Object)d5);
        iAgent.setAttribute("actual_gap", (Object)d6);
        iAgent.setAttribute("desired_minimum_gap", (Object)d7);
        iAgent.setAttribute("acceleration", (Object)d);
        return d4 + d * iScope.getClock().getStepInSeconds();
    }

    protected double computeAsLeader(IScope iScope, IAgent iAgent, double d, double d2, double d3, double d4) {
        double d5 = d3 / d4;
        double d6 = d2 * (1.0 - d5 * d5 * d5 * d5);
        return this.setValuesAndComputeSpeed(iScope, iAgent, d6, d, d2, d3, 0.0, 0.0, 0.0);
    }
}

