/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.switchproject.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.experimental.switchproject.gama.util.deque.GamaDeque;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.inside(kinds={3, 11, 6}, symbols={"chart"})
@GamlAnnotations.doc(value="Allows to add, i.e. to insert, a new element in a deque", usages={@GamlAnnotations.usage(value="The new element can be added either at the end of the deque", examples={@GamlAnnotations.example(value="push expr to: stack;\t\t// Add at the end", isExecutable=false), @GamlAnnotations.example(value="push expr to: queue;\t\t// Add at the end", isExecutable=false)})})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="item", type={0}, optional=false, doc={@GamlAnnotations.doc(value="any expression to add in the deque")}), @GamlAnnotations.facet(name="to", type={668, 667}, optional=false, doc={@GamlAnnotations.doc(value="the stack or queue")})}, omissible="item")
public class PushStatement
extends AbstractStatement {
    final IExpression itemExp = this.getFacet(new String[]{"item"});
    final IExpression toExp = this.getFacet(new String[]{"to"});

    public PushStatement(IDescription iDescription) {
        super(iDescription);
        String string = this.toExp != null ? this.toExp.literalValue() : null;
        this.setName("push to " + string);
    }

    private GamaDeque identifyContainer(IScope iScope, IExpression iExpression) throws GamaRuntimeException {
        Object object = iExpression.value(iScope);
        if (object instanceof GamaDeque) {
            return (GamaDeque)object;
        }
        return null;
    }

    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        GamaDeque gamaDeque = this.identifyContainer(iScope, this.toExp);
        Object object = this.itemExp.value(iScope);
        if (gamaDeque != null && object != null) {
            gamaDeque.addLast(object);
        }
        return gamaDeque;
    }
}

