/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.webcam.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaPair;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.IMatrix;
import gama.experimental.webcam.types.GamaWebcam;
import gama.gaml.operators.Cast;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;

public class WebcamOperators {
    public static BufferedImage mirrorImage(BufferedImage bufferedImage, boolean bl, boolean bl2) {
        if (!bl && !bl2) {
            return bufferedImage;
        }
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        BufferedImage bufferedImage2 = new BufferedImage(n2, n, 2);
        if (bl2 && !bl) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                int n5 = n2 - 1;
                while (n4 < n2) {
                    bufferedImage2.setRGB(n5, n3, bufferedImage.getRGB(n4, n3));
                    ++n4;
                    --n5;
                }
                ++n3;
            }
        } else if (!bl2 && bl) {
            int n6 = 0;
            int n7 = n - 1;
            while (n6 < n) {
                int n8 = 0;
                while (n8 < n2) {
                    bufferedImage2.setRGB(n8, n7, bufferedImage.getRGB(n8, n6));
                    ++n8;
                }
                ++n6;
                --n7;
            }
        } else {
            int n9 = 0;
            int n10 = n - 1;
            while (n9 < n) {
                int n11 = 0;
                int n12 = n2 - 1;
                while (n11 < n2) {
                    bufferedImage2.setRGB(n12, n10, bufferedImage.getRGB(n11, n9));
                    ++n11;
                    --n12;
                }
                ++n9;
                --n10;
            }
        }
        return bufferedImage2;
    }

    @GamlAnnotations.operator(value={"cam_shot"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="get a photoshot with the given resolution <pair(width, height) in pixels> from the given webcam, and optionnaly mirror the image, and save it to the file - autoclose or not the webcam after")
    public static IMatrix cam_shot(IScope iScope, GamaWebcam gamaWebcam, GamaPair<Integer, Integer> gamaPair, boolean bl, boolean bl2, String string, boolean bl3) {
        BufferedImage bufferedImage = WebcamOperators.CamShotAct(iScope, gamaWebcam, gamaPair, bl, bl2, bl3);
        if (string != null && !string.isBlank()) {
            String string2 = FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)string, (boolean)false);
            File file = new File(string2);
            try {
                if (!Files.exists(Paths.get(string2, new String[0]).getParent(), new LinkOption[0])) {
                    Files.createDirectories(Paths.get(string2, new String[0]).getParent(), new FileAttribute[0]);
                }
                ImageIO.write((RenderedImage)bufferedImage, com.google.common.io.Files.getFileExtension((String)string2), file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return WebcamOperators.matrixValueFromImage(iScope, bufferedImage);
    }

    @GamlAnnotations.operator(value={"close_webcam"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="close a webcam")
    public static boolean closeWebcam(IScope iScope, GamaWebcam gamaWebcam) {
        gamaWebcam.getWebcam().getLock().disable();
        return gamaWebcam.getWebcam().close();
    }

    @GamlAnnotations.operator(value={"open_webcam"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="open a webcam")
    public static boolean openWebcam(IScope iScope, GamaWebcam gamaWebcam) {
        gamaWebcam.getWebcam().getLock().disable();
        return gamaWebcam.getWebcam().open(false);
    }

    @GamlAnnotations.operator(value={"cam_shot"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="get a photoshot with the default resolution from the given webcam, and optionnaly mirror the image, and save it to the file")
    public static IMatrix cam_shot(IScope iScope, GamaWebcam gamaWebcam, boolean bl, boolean bl2, String string, boolean bl3) {
        return WebcamOperators.cam_shot(iScope, gamaWebcam, null, bl, bl2, string, bl3);
    }

    @GamlAnnotations.operator(value={"cam_shot"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="get a photoshot with the default resolution  from the given webcam and save it to the file")
    public static IMatrix cam_shot(IScope iScope, GamaWebcam gamaWebcam, String string, boolean bl) {
        return WebcamOperators.cam_shot(iScope, gamaWebcam, null, false, false, string, bl);
    }

    @GamlAnnotations.operator(value={"cam_shot"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="get a photoshot with the given resolution <pair(width, height) in pixels> from the given webcam and save it to the file")
    public static IMatrix cam_shot(IScope iScope, GamaWebcam gamaWebcam, GamaPair<Integer, Integer> gamaPair, String string, boolean bl) {
        return WebcamOperators.cam_shot(iScope, gamaWebcam, null, false, false, string, bl);
    }

    @GamlAnnotations.operator(value={"cam_shot"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="get a photoshot with the default resolution from the given webcam, and optionnaly mirror the image")
    public static IMatrix cam_shot(IScope iScope, GamaWebcam gamaWebcam, GamaPair<Integer, Integer> gamaPair, boolean bl, boolean bl2, boolean bl3) {
        return WebcamOperators.cam_shot(iScope, gamaWebcam, gamaPair, bl, bl2, null, bl3);
    }

    @GamlAnnotations.operator(value={"cam_shot"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="get a photoshot with the default resolution from the given webcam, and optionnaly mirror the image")
    public static IMatrix cam_shot(IScope iScope, GamaWebcam gamaWebcam, boolean bl, boolean bl2, boolean bl3) {
        return WebcamOperators.cam_shot(iScope, gamaWebcam, null, bl, bl2, null, bl3);
    }

    @GamlAnnotations.operator(value={"cam_shot"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="get a photoshot with the default resolution  from the given webcam")
    public static IMatrix cam_shot(IScope iScope, GamaWebcam gamaWebcam, boolean bl) {
        return WebcamOperators.cam_shot(iScope, gamaWebcam, null, false, false, null, bl);
    }

    @GamlAnnotations.operator(value={"cam_shot"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="get a photoshot with the given resolution <pair(width, height) in pixels> from the given webcam")
    public static IMatrix cam_shot(IScope iScope, GamaWebcam gamaWebcam, GamaPair<Integer, Integer> gamaPair, boolean bl) {
        return WebcamOperators.cam_shot(iScope, gamaWebcam, null, false, false, null, bl);
    }

    public static BufferedImage CamShotAct(IScope iScope, GamaWebcam gamaWebcam, GamaPair<Integer, Integer> gamaPair, boolean bl, boolean bl2, boolean bl3) {
        if (gamaWebcam == null || gamaWebcam.getWebcam() == null) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)"No webcam detected", (IScope)iScope), (boolean)false);
            return null;
        }
        if (!gamaWebcam.getWebcam().isOpen()) {
            WebcamOperators.openWebcam(iScope, gamaWebcam);
        }
        if (gamaPair != null) {
            Dimension[] dimensionArray;
            int n = Cast.asInt((IScope)iScope, (Object)gamaPair.key);
            int n2 = Cast.asInt((IScope)iScope, (Object)gamaPair.value);
            Dimension dimension = new Dimension(n, n2);
            boolean bl4 = true;
            int n3 = 0;
            int n4 = 0;
            Dimension[] dimensionArray2 = gamaWebcam.getWebcam().getViewSizes();
            int n5 = dimensionArray2.length;
            int n6 = 0;
            while (n6 < n5) {
                dimensionArray = dimensionArray2[n6];
                if (n3 < dimensionArray.width) {
                    n3 = dimensionArray.width;
                    int cfr_ignored_0 = dimensionArray.height;
                }
                if (n4 < dimensionArray.height) {
                    n4 = dimensionArray.height;
                    int cfr_ignored_1 = dimensionArray.width;
                }
                if (dimensionArray.equals(dimension)) {
                    bl4 = false;
                    break;
                }
                ++n6;
            }
            if (!gamaWebcam.getWebcam().getViewSize().equals(dimension)) {
                gamaWebcam.getWebcam().close();
                if (bl4) {
                    dimensionArray = new Dimension[]{dimension};
                    gamaWebcam.getWebcam().setCustomViewSizes(dimensionArray);
                }
                if (!gamaWebcam.getWebcam().isOpen()) {
                    gamaWebcam.getWebcam().setViewSize(dimension);
                }
            }
            if (gamaWebcam.getWebcam().getLock().isLocked()) {
                gamaWebcam.getWebcam().getLock().unlock();
            }
            WebcamOperators.openWebcam(iScope, gamaWebcam);
        }
        BufferedImage bufferedImage = WebcamOperators.mirrorImage(gamaWebcam.getWebcam().getImage(), bl, bl2);
        if (bl3) {
            gamaWebcam.getWebcam().close();
        }
        return bufferedImage;
    }

    public static IMatrix matrixValueFromImage(IScope iScope, BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        BufferedImage bufferedImage2 = bufferedImage;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        GamaIntMatrix gamaIntMatrix = new GamaIntMatrix(n, n2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                gamaIntMatrix.set(iScope, n3, n4, (Object)bufferedImage2.getRGB(n3, n4));
                ++n4;
            }
            ++n3;
        }
        return gamaIntMatrix;
    }
}

