/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.weka.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.experimental.weka.algorithms.CHAID;
import gama.experimental.weka.operators.InstanceManagement;
import gama.experimental.weka.types.GamaClassifier;
import gama.gaml.operators.Cast;
import java.util.Map;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.functions.GaussianProcesses;
import weka.classifiers.functions.MultilayerPerceptron;
import weka.classifiers.functions.RBFNetwork;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.SMOreg;
import weka.classifiers.rules.JRip;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.REPTree;
import weka.classifiers.trees.RandomForest;
import weka.core.Instance;
import weka.core.Instances;

public class Classifying {
    private static GamaClassifier buildClassifier(Classifier classifier, Instances instances, IList<String> iList, Map<String, IList<String>> map) {
        GamaClassifier gamaClassifier = new GamaClassifier();
        gamaClassifier.setClassifier(classifier);
        gamaClassifier.setDataset(instances);
        gamaClassifier.setValsNominal(map);
        return gamaClassifier;
    }

    @GamlAnnotations.operator(value={"train_chaid"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Build and train a CHAID classifier; use: train_j48(data, list of attributes, name of the class, for each nominal attribute and the class, their possible values, the parameters);two parameters can be defined: binary_split: Binary splits on nominal attributes? (default: false); split_point: split point value (default: 0.05)", examples={@GamlAnnotations.example(value="train_j48(data, [ \"weight\", \"size\"],\"sexe\",[\"sexe\"::[\"M\", \"F\"]],map([\"binary_split\"::true, \"split_point\"::0.03]));", isExecutable=false)}, see={"classify", "train_j48"})
    public static GamaClassifier primBuildCHAIDClassifier(IScope iScope, IContainer<?, ?> iContainer, IList<String> iList, String string, IMap<String, IList<String>> iMap, IMap<String, Object> iMap2) throws GamaRuntimeException {
        Instances instances = InstanceManagement.convertToInstances(iScope, string, iList, iMap, iContainer);
        CHAID cHAID = new CHAID();
        if (iMap2 != null) {
            Boolean bl = Cast.asBool((IScope)iScope, (Object)iMap2.get((Object)"binary_split"));
            Double d = Cast.asFloat((IScope)iScope, (Object)iMap2.get((Object)"split_point"));
            if (bl != null) {
                cHAID.setBinarySplits(bl);
            }
            if (d != null) {
                cHAID.setSplitPoint(d);
            }
        }
        try {
            cHAID.buildClassifier(instances);
        }
        catch (Exception exception) {
            GamaRuntimeException.error((String)exception.getMessage(), (IScope)iScope);
        }
        return Classifying.buildClassifier(cHAID, instances, iList, iMap);
    }

    @GamlAnnotations.operator(value={"train_jrip"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Build and train a JRip classifier; use: train_jrip(data, list of attributes, name of the class, for each nominal attribute and the class, their possible values, the parameters);four parameters can be defined: nb_run:Nb of Runs of optimizations  (default: 2); min_nb_obj: The minimal number of instance weights within a split (default: 2.0); prunning: Whether use pruning, i.e. the data is clean or not (default: true); num_folds: The number of folds to split data into Grow and Prune for IREP (default: 3)", examples={@GamlAnnotations.example(value="train_jrip(data, [ \"weight\", \"size\"],\"sexe\",[\"sexe\"::[\"M\", \"F\"]],map([\"prunning\"::true]));", isExecutable=false)}, see={"classify", "train_j48"})
    public static GamaClassifier primBuildJRIPClassifier(IScope iScope, IContainer<?, ?> iContainer, IList<String> iList, String string, IMap<String, IList<String>> iMap, IMap<String, Object> iMap2) throws GamaRuntimeException {
        Instances instances = InstanceManagement.convertToInstances(iScope, string, iList, iMap, iContainer);
        JRip jRip = new JRip();
        jRip.setSeed((long)Math.abs(iScope.getRandom().getSeed().intValue()));
        if (iMap2 != null) {
            Integer n = Cast.asInt((IScope)iScope, (Object)iMap2.get((Object)"nb_run"));
            Double d = Cast.asFloat((IScope)iScope, (Object)iMap2.get((Object)"min_nb"));
            Boolean bl = Cast.asBool((IScope)iScope, (Object)iMap2.get((Object)"prunning"));
            Integer n2 = Cast.asInt((IScope)iScope, (Object)iMap2.get((Object)"num_folds"));
            if (n2 != null) {
                jRip.setFolds(n2.intValue());
            }
            if (d != null) {
                jRip.setMinNo(d.doubleValue());
            }
            if (n != null) {
                jRip.setOptimizations(n.intValue());
            }
            if (bl != null) {
                jRip.setUsePruning(bl.booleanValue());
            }
        }
        try {
            jRip.buildClassifier(instances);
        }
        catch (Exception exception) {
            GamaRuntimeException.error((String)exception.getMessage(), (IScope)iScope);
        }
        return Classifying.buildClassifier((Classifier)jRip, instances, iList, iMap);
    }

    @GamlAnnotations.operator(value={"train_mlp"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Build and train a Multi-layer perceptron classifier; use: train_mlp(data, list of attributes, name of the class, for each nominal attribute and the class, their possible values, the parameters);", examples={@GamlAnnotations.example(value="train_mlp(data, [ \"weight\", \"size\"],\"sexe\",[\"sexe\"::[\"M\", \"F\"]],map([]));", isExecutable=false)}, see={"classify", "train_j48"})
    public static GamaClassifier primBuildMLPClassifier(IScope iScope, IContainer<?, ?> iContainer, IList<String> iList, String string, IMap<String, IList<String>> iMap, IMap<String, Object> iMap2) throws GamaRuntimeException {
        Instances instances = InstanceManagement.convertToInstances(iScope, string, iList, iMap, iContainer);
        MultilayerPerceptron multilayerPerceptron = new MultilayerPerceptron();
        multilayerPerceptron.setSeed(Math.abs(iScope.getRandom().getSeed().intValue()));
        try {
            multilayerPerceptron.buildClassifier(instances);
        }
        catch (Exception exception) {
            GamaRuntimeException.error((String)exception.getMessage(), (IScope)iScope);
        }
        return Classifying.buildClassifier((Classifier)multilayerPerceptron, instances, iList, iMap);
    }

    @GamlAnnotations.operator(value={"train_smo"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Build and train a Support vector classifier; use: train_smo(data, list of attributes, name of the class, for each nominal attribute and the class, their possible values, the parameters);", examples={@GamlAnnotations.example(value="train_smo(data, [ \"weight\", \"size\"],\"sexe\",[\"sexe\"::[\"M\", \"F\"]],map([]));", isExecutable=false)}, see={"classify", "train_j48"})
    public static GamaClassifier primBuildSMOClassifier(IScope iScope, IContainer<?, ?> iContainer, IList<String> iList, String string, IMap<String, IList<String>> iMap, IMap<String, Object> iMap2) throws GamaRuntimeException {
        Instances instances = InstanceManagement.convertToInstances(iScope, string, iList, iMap, iContainer);
        SMO sMO = new SMO();
        sMO.setRandomSeed(Math.abs(iScope.getRandom().getSeed().intValue()));
        try {
            sMO.buildClassifier(instances);
        }
        catch (Exception exception) {
            GamaRuntimeException.error((String)exception.getMessage(), (IScope)iScope);
        }
        return Classifying.buildClassifier((Classifier)sMO, instances, iList, iMap);
    }

    @GamlAnnotations.operator(value={"train_gauss"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Build and train a GAUSSIAN Process Regression classifier; use: train_gauss(data, list of attributes, name of the class, for each nominal attribute and the class, their possible values);", examples={@GamlAnnotations.example(value="train_gauss(data,[ \"weight\", \"size\"],\"Age\");", isExecutable=false)}, see={"classify", "train_j48"})
    public static GamaClassifier primBuildGaussianProcessesClassifier(IScope iScope, IContainer<?, ?> iContainer, IList<String> iList, String string, IMap<String, IList<String>> iMap) throws GamaRuntimeException {
        Instances instances = InstanceManagement.convertToInstances(iScope, string, iList, iMap, iContainer);
        GaussianProcesses gaussianProcesses = new GaussianProcesses();
        try {
            gaussianProcesses.buildClassifier(instances);
        }
        catch (Exception exception) {
            GamaRuntimeException.error((String)exception.getMessage(), (IScope)iScope);
        }
        return Classifying.buildClassifier((Classifier)gaussianProcesses, instances, iList, iMap);
    }

    @GamlAnnotations.operator(value={"train_reptree"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Build and train a REP Decision/Regression classifier; use: train_reptree(data, list of attributes, name of the class, for each nominal attribute and the class, their possible values);", examples={@GamlAnnotations.example(value="train_reptree(data,[ \"weight\", \"size\"],\"Age\");", isExecutable=false)}, see={"classify", "train_j48"})
    public static GamaClassifier primBuildREPTREEClassifier(IScope iScope, IContainer<?, ?> iContainer, IList<String> iList, String string, IMap<String, IList<String>> iMap) throws GamaRuntimeException {
        Instances instances = InstanceManagement.convertToInstances(iScope, string, iList, iMap, iContainer);
        REPTree rEPTree = new REPTree();
        rEPTree.setSeed(Math.abs(iScope.getRandom().getSeed().intValue()));
        try {
            rEPTree.buildClassifier(instances);
        }
        catch (Exception exception) {
            GamaRuntimeException.error((String)exception.getMessage(), (IScope)iScope);
        }
        return Classifying.buildClassifier((Classifier)rEPTree, instances, iList, iMap);
    }

    @GamlAnnotations.operator(value={"train_rbf"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Build and train a normalized Gaussian radial basisbasis function network Regression classifier; use: train_gauss(data, list of attributes, name of the class, for each nominal attribute and the class, their possible values);", examples={@GamlAnnotations.example(value="train_gauss(data, [ \"weight\", \"size\"],\"Age\");", isExecutable=false)}, see={"classify", "train_j48"})
    public static GamaClassifier primBuildRBFNetworkClassifier(IScope iScope, IContainer<?, ?> iContainer, IList<String> iList, String string, IMap<String, IList<String>> iMap) throws GamaRuntimeException {
        Instances instances = InstanceManagement.convertToInstances(iScope, string, iList, iMap, iContainer);
        RBFNetwork rBFNetwork = new RBFNetwork();
        try {
            rBFNetwork.buildClassifier(instances);
        }
        catch (Exception exception) {
            GamaRuntimeException.error((String)exception.getMessage(), (IScope)iScope);
        }
        return Classifying.buildClassifier((Classifier)rBFNetwork, instances, iList, iMap);
    }

    @GamlAnnotations.operator(value={"train_bn"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Build and train a Bayesian Network classifier; use: train_bn(data, list of attributes, name of the class, for each nominal attribute and the class, their possible values);", examples={@GamlAnnotations.example(value="train_bn(data, [ \"weight\", \"size\"],\"sexe\",[\"sexe\"::[\"M\", \"F\"]]);", isExecutable=false)}, see={"classify", "train_j48"})
    public static GamaClassifier primBuildBNClassifier(IScope iScope, IContainer<?, ?> iContainer, IList<String> iList, String string, IMap<String, IList<String>> iMap) throws GamaRuntimeException {
        Instances instances = InstanceManagement.convertToInstances(iScope, string, iList, iMap, iContainer);
        BayesNet bayesNet = new BayesNet();
        try {
            bayesNet.buildClassifier(instances);
        }
        catch (Exception exception) {
            GamaRuntimeException.error((String)exception.getMessage(), (IScope)iScope);
        }
        return Classifying.buildClassifier((Classifier)bayesNet, instances, iList, iMap);
    }

    @GamlAnnotations.operator(value={"train_rf"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Build and train a Random Forest classifier; use: train_rf(data, list of attributes, name of the class, for each nominal attribute and the class, their possible values);", examples={@GamlAnnotations.example(value="train_rf(data, [ \"weight\", \"size\"],\"sexe\",[\"sexe\"::[\"M\", \"F\"]]);", isExecutable=false)}, see={"classify", "train_j48"})
    public static GamaClassifier primBuildRandomForestClassifier(IScope iScope, IContainer<?, ?> iContainer, IList<String> iList, String string, IMap<String, IList<String>> iMap) throws GamaRuntimeException {
        Instances instances = InstanceManagement.convertToInstances(iScope, string, iList, iMap, iContainer);
        RandomForest randomForest = new RandomForest();
        randomForest.setSeed(Math.abs(iScope.getRandom().getSeed().intValue()));
        try {
            randomForest.buildClassifier(instances);
        }
        catch (Exception exception) {
            GamaRuntimeException.error((String)exception.getMessage(), (IScope)iScope);
        }
        return Classifying.buildClassifier((Classifier)randomForest, instances, iList, iMap);
    }

    @GamlAnnotations.operator(value={"train_smo_reg"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Build and train a Support Vector Regression classifier; use: train_smo_reg(data, list of attributes, name of the class, for each nominal attribute and the class, their possible values);", examples={@GamlAnnotations.example(value="train_smo_reg(data, [ \"weight\", \"size\"],\"Age\");", isExecutable=false)}, see={"classify", "train_j48"})
    public static GamaClassifier primBuildSMORegClassifier(IScope iScope, IContainer<?, ?> iContainer, IList<String> iList, String string, IMap<String, IList<String>> iMap) throws GamaRuntimeException {
        Instances instances = InstanceManagement.convertToInstances(iScope, string, iList, iMap, iContainer);
        SMOreg sMOreg = new SMOreg();
        try {
            sMOreg.buildClassifier(instances);
        }
        catch (Exception exception) {
            GamaRuntimeException.error((String)exception.getMessage(), (IScope)iScope);
        }
        return Classifying.buildClassifier((Classifier)sMOreg, instances, iList, iMap);
    }

    @GamlAnnotations.operator(value={"train_j48"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Build and train a J48 classifier; use: train_j48(data, list of attributes, name of the class, for each nominal attribute and the class, their possible values, the parameters);Eight parameters can be defined: binary_split: Binary splits on nominal attributes? (default: false); unpruned: Unpruned tree? (default: false); reduced_error_pruning: Use reduced error pruning? (default: false); sub_tree_raising: Subtree raising to be performed? (default: false); laplace: Determines whether probabilities are smoothed using Laplace correction when predictions are generated (default: false); min_nb_obj: Minimum number of instances (default: 2); numFolds: Number of folds for reduced error pruning (default: 3); confidence_factor: Confidence level (default: 0.25)", examples={@GamlAnnotations.example(value="train_j48(data, [ \"weight\", \"size\"],\"sexe\",[\"sexe\"::[\"M\", \"F\"]],map([\"unpruned\"::true]));", isExecutable=false)}, see={"classify", "train_chaid"})
    public static GamaClassifier primBuildJ48Classifier(IScope iScope, IContainer<?, ?> iContainer, IList<String> iList, String string, IMap<String, IList<String>> iMap, IMap<String, Object> iMap2) throws GamaRuntimeException {
        Instances instances = InstanceManagement.convertToInstances(iScope, string, iList, iMap, iContainer);
        J48 j48 = new J48();
        j48.setSeed(Math.abs(iScope.getRandom().getSeed().intValue()));
        if (iMap2 != null) {
            Boolean bl = Cast.asBool((IScope)iScope, (Object)iMap2.get((Object)"binary_split"));
            Double d = Cast.asFloat((IScope)iScope, (Object)iMap2.get((Object)"confidence_factor"));
            Integer n = Cast.asInt((IScope)iScope, (Object)iMap2.get((Object)"min_nb_obj"));
            Boolean bl2 = Cast.asBool((IScope)iScope, (Object)iMap2.get((Object)"reduced_error_pruning"));
            Boolean bl3 = Cast.asBool((IScope)iScope, (Object)iMap2.get((Object)"sub_tree_raising"));
            Boolean bl4 = Cast.asBool((IScope)iScope, (Object)iMap2.get((Object)"unpruned"));
            Boolean bl5 = Cast.asBool((IScope)iScope, (Object)iMap2.get((Object)"laplace"));
            Integer n2 = Cast.asInt((IScope)iScope, (Object)iMap2.get((Object)"num_folds"));
            if (bl != null) {
                j48.setBinarySplits(bl.booleanValue());
            }
            if (d != null) {
                j48.setConfidenceFactor(d.floatValue());
            }
            if (d != null) {
                j48.setMinNumObj(n.intValue());
            }
            if (n2 != null) {
                j48.setNumFolds(n2.intValue());
            }
            if (bl2 != null) {
                j48.setReducedErrorPruning(bl2.booleanValue());
            }
            if (bl3 != null) {
                j48.setSubtreeRaising(bl3.booleanValue());
            }
            if (bl4 != null) {
                j48.setUnpruned(bl4.booleanValue());
            }
            if (bl5 != null) {
                j48.setUseLaplace(bl5.booleanValue());
            }
        }
        try {
            j48.buildClassifier(instances);
        }
        catch (Exception exception) {
            GamaRuntimeException.error((String)exception.getMessage(), (IScope)iScope);
        }
        return Classifying.buildClassifier((Classifier)j48, instances, iList, iMap);
    }

    @GamlAnnotations.operator(value={"classify"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="use a classifier to classify an instance; use: train_j48(classifier, map of attribute values)", examples={@GamlAnnotations.example(value="my_classifier classify [\"weight\"::65,\"size\"::175]", isExecutable=false)}, see={"train_chaid", "train_j48"})
    public static String primClassify(IScope iScope, GamaClassifier gamaClassifier, IAgent iAgent) throws GamaRuntimeException {
        if (gamaClassifier == null || gamaClassifier.getClassifier() == null) {
            return null;
        }
        Instance instance = InstanceManagement.createInstance(iScope, iAgent, gamaClassifier.getDataset(), gamaClassifier.getDataset().classAttribute(), gamaClassifier.getValsNominal());
        instance.setDataset(gamaClassifier.getDataset());
        try {
            double d = gamaClassifier.getClassifier().classifyInstance(instance);
            if (gamaClassifier.getDataset().classAttribute().isNominal()) {
                return gamaClassifier.getDataset().classAttribute().value((int)d);
            }
            return String.valueOf(d);
        }
        catch (Exception exception) {
            GamaRuntimeException.error((String)exception.getMessage(), (IScope)iScope);
            return null;
        }
    }

    @GamlAnnotations.operator(value={"classify"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="use a classifier to classify an instance; use: classify(classifier, an agent)", examples={@GamlAnnotations.example(value="my_classifier classify self", isExecutable=false)}, see={"train_chaid", "train_j48"})
    public static String primClassify(IScope iScope, GamaClassifier gamaClassifier, IMap<String, ?> iMap) throws GamaRuntimeException {
        if (gamaClassifier == null || gamaClassifier.getClassifier() == null) {
            return null;
        }
        Instance instance = InstanceManagement.createInstance(iScope, iMap, gamaClassifier.getDataset(), null, gamaClassifier.getValsNominal());
        instance.setDataset(gamaClassifier.getDataset());
        try {
            double d = gamaClassifier.getClassifier().classifyInstance(instance);
            if (gamaClassifier.getDataset().classAttribute().isNominal()) {
                return gamaClassifier.getDataset().classAttribute().value((int)d);
            }
            return String.valueOf(d);
        }
        catch (Exception exception) {
            GamaRuntimeException.error((String)exception.getMessage(), (IScope)iScope);
            return null;
        }
    }
}

