/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.pmml.skills;

import com.google.common.base.Strings;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.GamaFile;
import gama.gaml.skills.Skill;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.LoadingModelEvaluatorBuilder;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.TargetField;
import org.xml.sax.SAXException;

@GamlAnnotations.skill(name="predicting", doc={@GamlAnnotations.doc(value="Add the capacity to load and manipulate machine learning models saved in pmml files.")})
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="models", type=5, doc={@GamlAnnotations.doc(value="The list of all loaded models")})})
public class PredictingSkill
extends Skill {
    public static final String EVALUATOR_NAME = "evaluator_name";
    public static final String EVALUATOR_FILE = "evaluator_file";
    public static final String ARGUMENTS = "arguments";
    private Map<String, Evaluator> evaluators = new HashMap<String, Evaluator>();
    private String latestEvaluator;

    PredictingSkill() {
    }

    @GamlAnnotations.action(name="load_evaluator", args={@GamlAnnotations.arg(name="evaluator_name", type=4, doc={@GamlAnnotations.doc(value="The name of the evaluator. It will be required later to retrieve on which evaluator to perform operations (verify, predict etc.)")}), @GamlAnnotations.arg(name="evaluator_file", type=12, doc={@GamlAnnotations.doc(value="The file containing the predictor to load.")})})
    public boolean loadEvaluator(IScope iScope) {
        try {
            String string = (String)iScope.getTypedArgIfExists(EVALUATOR_NAME, 4);
            GamaFile gamaFile = (GamaFile)iScope.getTypedArgIfExists(EVALUATOR_FILE, 12);
            this.evaluators.put(string, (Evaluator)new LoadingModelEvaluatorBuilder().load(gamaFile.getFile(iScope)).build());
            this.latestEvaluator = string;
        }
        catch (JAXBException | IOException | ParserConfigurationException | SAXException throwable) {
            throwable.printStackTrace();
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)throwable, (IScope)iScope), (boolean)false);
            return false;
        }
        return true;
    }

    @GamlAnnotations.action(name="verify_evaluator", args={@GamlAnnotations.arg(name="evaluator_name", type=4, doc={@GamlAnnotations.doc(value="The name of the evaluator to verify. If not provided the latest loaded will be used.")}, optional=true)}, doc={@GamlAnnotations.doc(value="Verifies the evaluator. Returns false if the evaluator hasn't been loaded yet or if the verification failed.")})
    public Boolean verifyEvaluator(IScope iScope) {
        String string;
        String string2 = (String)iScope.getTypedArgIfExists(EVALUATOR_NAME, 4);
        String string3 = string = Strings.isNullOrEmpty((String)string2) ? this.latestEvaluator : string2;
        if (this.evaluators.containsKey(string)) {
            try {
                Evaluator evaluator = this.evaluators.get(string).verify();
                this.evaluators.put(string, evaluator);
                return true;
            }
            catch (Exception exception) {
                GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)exception, (IScope)iScope), (boolean)false);
                return false;
            }
        }
        return false;
    }

    @GamlAnnotations.action(name="get_input_field_names", args={@GamlAnnotations.arg(name="evaluator_name", type=4, doc={@GamlAnnotations.doc(value="The name of the evaluator from which to fetch input fields. If not provided the latest loaded will be used.")}, optional=true)}, doc={@GamlAnnotations.doc(value="Fetch the input fields. Returns a list of the field names. In case of error or if the evaluator doesn't exist, returns an empty list.")})
    public IList<String> getInputFieldNames(IScope iScope) {
        String string = (String)iScope.getTypedArgIfExists(EVALUATOR_NAME, 4);
        String string2 = Strings.isNullOrEmpty((String)string) ? this.latestEvaluator : string;
        IList iList = GamaListFactory.create();
        if (this.evaluators.containsKey(string2)) {
            try {
                for (InputField inputField : this.evaluators.get(string2).getInputFields()) {
                    iList.add((Object)inputField.getName());
                }
            }
            catch (Exception exception) {
                GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)exception, (IScope)iScope), (boolean)false);
                return GamaListFactory.EMPTY_LIST;
            }
        }
        return iList;
    }

    @GamlAnnotations.action(name="get_target_field_names", args={@GamlAnnotations.arg(name="evaluator_name", type=4, doc={@GamlAnnotations.doc(value="The name of the evaluator from which to fetch target fields. If not provided the latest loaded will be used.")}, optional=true)}, doc={@GamlAnnotations.doc(value="Fetch the target fields. Returns a list of the field names. In case of error or if the evaluator doesn't exist, returns an empty list.")})
    public IList<String> getTargetFieldNames(IScope iScope) {
        String string = (String)iScope.getTypedArgIfExists(EVALUATOR_NAME, 4);
        String string2 = Strings.isNullOrEmpty((String)string) ? this.latestEvaluator : string;
        IList iList = GamaListFactory.create();
        if (this.evaluators.containsKey(string2)) {
            try {
                for (TargetField targetField : this.evaluators.get(string2).getTargetFields()) {
                    iList.add((Object)targetField.getName());
                }
            }
            catch (Exception exception) {
                GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)exception, (IScope)iScope), (boolean)false);
                return GamaListFactory.EMPTY_LIST;
            }
        }
        return iList;
    }

    @GamlAnnotations.action(name="get_output_field_names", args={@GamlAnnotations.arg(name="evaluator_name", type=4, doc={@GamlAnnotations.doc(value="The name of the evaluator from which to fetch output fields. If not provided the latest loaded will be used.")}, optional=true)}, doc={@GamlAnnotations.doc(value="Fetch the output fields. Returns a list of the field names. In case of error or if the evaluator doesn't exist, returns an empty list.")})
    public IList<String> getOutputFieldNames(IScope iScope) {
        String string = (String)iScope.getTypedArgIfExists(EVALUATOR_NAME, 4);
        String string2 = Strings.isNullOrEmpty((String)string) ? this.latestEvaluator : string;
        IList iList = GamaListFactory.create();
        if (this.evaluators.containsKey(string2)) {
            try {
                for (OutputField outputField : this.evaluators.get(string2).getOutputFields()) {
                    iList.add((Object)outputField.getName());
                }
            }
            catch (Exception exception) {
                GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)exception, (IScope)iScope), (boolean)false);
                return GamaListFactory.EMPTY_LIST;
            }
        }
        return iList;
    }

    @GamlAnnotations.action(name="evaluate", args={@GamlAnnotations.arg(name="evaluator_name", type=4, doc={@GamlAnnotations.doc(value="The name of the evaluator to call. If not provided the latest loaded will be used.")}, optional=true), @GamlAnnotations.arg(name="arguments", type=10, doc={@GamlAnnotations.doc(value="The map containing all the arguments to evaluate the model. The keys representing the name of the fields and the value being their actual value.")}, optional=false)}, doc={@GamlAnnotations.doc(value="Evaluates a model given a set of parameters. Returns a map of the field names associated with their values. In case of error or if the evaluator doesn't exist, returns an empty map.")})
    public IMap<String, ?> evaluateEvaluator(IScope iScope) {
        String string = (String)iScope.getTypedArgIfExists(EVALUATOR_NAME, 4);
        String string2 = Strings.isNullOrEmpty((String)string) ? this.latestEvaluator : string;
        IMap iMap = (IMap)iScope.getTypedArgIfExists(ARGUMENTS, 10);
        if (!this.evaluators.containsKey(string2)) {
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.warning((String)("Cannot find evaluator: '" + string2 + "' make sure it has been loaded with the `load_evaluator` action before calling this action"), (IScope)iScope), (boolean)false);
            return GamaMapFactory.create((IType)Types.STRING, (IType)Types.NO_TYPE);
        }
        if (iMap == null) {
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.warning((String)"Value for the `arguments` facet is nil or not a map", (IScope)iScope), (boolean)false);
            return GamaMapFactory.create((IType)Types.STRING, (IType)Types.NO_TYPE);
        }
        try {
            Map map = this.evaluators.get(string2).evaluate((Map)iMap);
            return GamaMapFactory.create((IScope)iScope, (IType)Types.STRING, (IType)Types.NO_TYPE, (Map)map);
        }
        catch (Exception exception) {
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)exception, (IScope)iScope), (boolean)false);
            return GamaMapFactory.create((IType)Types.STRING, (IType)Types.NO_TYPE);
        }
    }

    @GamlAnnotations.getter(value="models")
    public IList<String> getAllLoadedModels() {
        return GamaListFactory.create((IType)Types.LIST, this.evaluators.keySet().stream());
    }
}

