/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.pmml.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.extension.pmml.types.PMMLEvaluator;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.LoadingModelEvaluatorBuilder;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.TargetField;
import org.xml.sax.SAXException;

public class PredictionOperators {
    @GamlAnnotations.operator(value={"load_eval_prediction"}, can_be_const=false)
    @GamlAnnotations.doc(value="Loads the PMML evaluator saved in the given file and returns it as an object of type unknown.")
    public static Evaluator loadEvaluator(IScope iScope, String string) {
        try {
            File file = new File(FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)string, (boolean)true));
            return new LoadingModelEvaluatorBuilder().load(file).build();
        }
        catch (JAXBException | IOException | ParserConfigurationException | SAXException throwable) {
            throwable.printStackTrace();
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)throwable, (IScope)iScope), (boolean)false);
            return null;
        }
    }

    @GamlAnnotations.operator(value={"verify_evaluator"}, doc={@GamlAnnotations.doc(value="Verifies the evaluator. Returns false if the evaluator hasn't been loaded yet or if the verification failed.")})
    public static Boolean verifyEvaluator(IScope iScope, PMMLEvaluator pMMLEvaluator) {
        try {
            Evaluator evaluator = pMMLEvaluator.verify();
            if (evaluator != null) {
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)exception, (IScope)iScope), (boolean)false);
            return false;
        }
    }

    @GamlAnnotations.operator(value={"get_input_field_names"}, doc={@GamlAnnotations.doc(value="Fetch the input fields. Returns a list of the field names. In case of error or if the evaluator doesn't exist, returns an empty list.")})
    public static IList<String> getInputFieldNames(IScope iScope, PMMLEvaluator pMMLEvaluator) {
        IList iList = GamaListFactory.create();
        try {
            for (InputField inputField : pMMLEvaluator.getInputFields()) {
                iList.add((Object)inputField.getName());
            }
        }
        catch (Exception exception) {
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)exception, (IScope)iScope), (boolean)false);
            return GamaListFactory.EMPTY_LIST;
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_target_field_names"}, doc={@GamlAnnotations.doc(value="Fetch the target fields. Returns a list of the field names. In case of error or if the evaluator doesn't exist, returns an empty list.")})
    public static IList<String> getTargetFieldNames(IScope iScope, PMMLEvaluator pMMLEvaluator) {
        IList iList = GamaListFactory.create();
        try {
            for (TargetField targetField : pMMLEvaluator.getTargetFields()) {
                iList.add((Object)targetField.getName());
            }
        }
        catch (Exception exception) {
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)exception, (IScope)iScope), (boolean)false);
            return GamaListFactory.EMPTY_LIST;
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_output_field_names"}, doc={@GamlAnnotations.doc(value="Fetch the output fields. Returns a list of the field names. In case of error or if the evaluator doesn't exist, returns an empty list.")})
    public static IList<String> getOutputFieldNames(IScope iScope, PMMLEvaluator pMMLEvaluator) {
        IList iList = GamaListFactory.create();
        try {
            for (OutputField outputField : pMMLEvaluator.getOutputFields()) {
                iList.add((Object)outputField.getName());
            }
        }
        catch (Exception exception) {
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)exception, (IScope)iScope), (boolean)false);
            return GamaListFactory.EMPTY_LIST;
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"evaluate"}, doc={@GamlAnnotations.doc(value="Evaluates a model given a set of parameters. Returns a map of the field names associated with their values. In case of error or if the evaluator doesn't exist, returns an empty map.")})
    public static IMap<String, ?> evaluateEvaluator(IScope iScope, PMMLEvaluator pMMLEvaluator, IMap iMap) {
        if (iMap == null) {
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.warning((String)"Value for the `arguments` facet is nil or not a map", (IScope)iScope), (boolean)false);
            return GamaMapFactory.create((IType)Types.STRING, (IType)Types.NO_TYPE);
        }
        try {
            Map<String, ?> map = pMMLEvaluator.evaluate((Map<String, ?>)iMap);
            Map map2 = EvaluatorUtil.decodeAll(map);
            return GamaMapFactory.create((IScope)iScope, (IType)Types.STRING, (IType)Types.NO_TYPE, (Map)map2);
        }
        catch (Exception exception) {
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)exception, (IScope)iScope), (boolean)false);
            return GamaMapFactory.create((IType)Types.STRING, (IType)Types.NO_TYPE);
        }
    }
}

