/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.argumentation.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMap;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.GamaFile;
import gama.core.util.graph.GamaGraph;
import gama.core.util.graph.IGraph;
import gama.core.util.matrix.IMatrix;
import gama.experimental.argumentation.types.GamaArgument;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ArgumentationOperators {
    @GamlAnnotations.operator(value={"load_graph"}, category={"argumentation"}, concept={"argumentation"})
    public static IGraph<GamaArgument, Object> loadGraph(IScope iScope, GamaFile gamaFile, IList<GamaArgument> iList) {
        GamaGraph gamaGraph = new GamaGraph(iScope, Types.get((int)175769925), (IType)Types.PAIR);
        gamaGraph.setDirected(true);
        Map map = iList.stream().collect(Collectors.toMap(GamaArgument::getId, Function.identity()));
        for (Object t : gamaFile.getContents(iScope).iterable(iScope)) {
            String[] stringArray;
            String string = t.toString();
            if (string.contains("arg")) {
                stringArray = string.replace("arg(", "").replace(").", "");
                if (!map.containsKey(stringArray)) continue;
                gamaGraph.addVertex(map.get(stringArray));
                continue;
            }
            if (!string.contains("att(") || (stringArray = string.split(",")).length != 2) continue;
            String string2 = stringArray[0].replace("att(", "");
            String string3 = stringArray[1].replace(").", "");
            GamaArgument gamaArgument = (GamaArgument)map.get(string2);
            GamaArgument gamaArgument2 = (GamaArgument)map.get(string3);
            if (gamaArgument == null || gamaArgument2 == null) continue;
            gamaGraph.addEdge((Object)gamaArgument, (Object)gamaArgument2);
        }
        return gamaGraph;
    }

    @GamlAnnotations.operator(value={"load_arguments"}, category={"argumentation"}, concept={"argumentation"})
    public static IList<GamaArgument> loadArguments(IScope iScope, String string, GamaFile gamaFile) {
        IList iList = GamaListFactory.create();
        IMatrix iMatrix = gamaFile.getContents(iScope).matrixValue(iScope, (IType)Types.STRING, false);
        int n = 0;
        while (n < iMatrix.getRows(iScope)) {
            String string2 = (String)iMatrix.get(iScope, 0, n);
            if (string2 != null && !string2.isEmpty()) {
                String string3 = (String)iMatrix.get(iScope, 1, n);
                GamaMap gamaMap = (GamaMap)GamaMapFactory.create((IType)Types.STRING, (IType)Types.FLOAT);
                int n2 = 2;
                while (n2 < iMatrix.getCols(iScope)) {
                    String string4 = (String)iMatrix.get(iScope, n2, n);
                    if (string4 != null) {
                        if (string4.contains("::")) {
                            String[] stringArray = string4.split("::");
                            gamaMap.put((Object)stringArray[0], (Object)Double.valueOf(stringArray[1]));
                        } else {
                            gamaMap.put((Object)string4, (Object)1.0);
                        }
                    }
                    ++n2;
                }
                GamaArgument gamaArgument = new GamaArgument(string2, string, string3, "", "", (IMap<String, Double>)gamaMap, null, "");
                iList.add((Object)gamaArgument);
            }
            ++n;
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"load_myChoice_arguments"}, category={"argumentation"}, concept={"argumentation"})
    public static IList<GamaArgument> loadMyChoiceArguments(IScope iScope, GamaFile gamaFile) {
        IList iList = GamaListFactory.create();
        IMatrix iMatrix = gamaFile.getContents(iScope).matrixValue(iScope, (IType)Types.STRING, false);
        int n = 1;
        while (n < iMatrix.getRows(iScope)) {
            String string = (String)iMatrix.get(iScope, 0, n);
            String string2 = (String)iMatrix.get(iScope, 2, n);
            String string3 = (String)iMatrix.get(iScope, 3, n);
            GamaMap gamaMap = (GamaMap)GamaMapFactory.create((IType)Types.STRING, (IType)Types.FLOAT);
            gamaMap.put((Object)((String)iMatrix.get(iScope, 4, n)), (Object)1.0);
            String string4 = (String)iMatrix.get(iScope, 16, n);
            iList.add((Object)new GamaArgument(string, string2, string3, "", "", (IMap<String, Double>)gamaMap, null, string4));
            ++n;
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"add_argument"}, category={"argumentation"}, concept={"argumentation"})
    public static Boolean addArgument(GamaGraph gamaGraph, GamaArgument gamaArgument) {
        if (gamaGraph != null && gamaArgument != null) {
            return gamaGraph.addVertex((Object)gamaArgument);
        }
        return false;
    }

    @GamlAnnotations.operator(value={"add_attack"}, category={"argumentation"}, concept={"argumentation"})
    public static Boolean addAttack(GamaGraph gamaGraph, GamaArgument gamaArgument, GamaArgument gamaArgument2) {
        if (gamaGraph != null && gamaArgument != null && gamaArgument2 != null) {
            if (gamaGraph.containsVertex((Object)gamaArgument) && gamaGraph.containsVertex((Object)gamaArgument2)) {
                Object object = gamaGraph.getEdge((Object)gamaArgument, (Object)gamaArgument2);
                if (object != null) {
                    return false;
                }
                gamaGraph.addEdge((Object)gamaArgument, (Object)gamaArgument2);
                return true;
            }
            return false;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"set_actor"}, category={"argumentation"}, concept={"argumentation"})
    public static GamaArgument setActor(GamaArgument gamaArgument, IAgent iAgent) {
        gamaArgument.setActor(iAgent);
        return gamaArgument;
    }
}

