/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.argumentation.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.GamaPair;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.graph.GamaGraph;
import gama.core.util.graph.IGraph;
import gama.experimental.argumentation.types.GamaArgument;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.operators.Random;
import gama.gaml.skills.Skill;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jargsemsat.jargsemsat.datastructures.DungAF;

@GamlAnnotations.skill(name="argumenting")
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="argumentation_graph", type=15, init="directed(graph([]))"), @GamlAnnotations.variable(name="source_type_confidence", type=10), @GamlAnnotations.variable(name="crit_importance", type=10)})
public class ArgumentingSkill
extends Skill {
    public static final String ARGUMENTATION_GRAPH = "argumentation_graph";
    public static final String CRIT_IMPORTANCE = "crit_importance";
    public static final String SOURCE_TYPE_CONFIDENCE = "source_type_confidence";
    public static int BLANK = 0;
    public static int IN = 1;
    public static int OUT = 2;
    public static int MUST_OUT = 3;
    public static int UNDEC = 4;

    @GamlAnnotations.getter(value="argumentation_graph")
    public static GamaGraph<GamaArgument, ?> getArgGraph(IAgent iAgent) {
        return (GamaGraph)iAgent.getAttribute(ARGUMENTATION_GRAPH);
    }

    @GamlAnnotations.setter(value="argumentation_graph")
    public static void setArgGraph(IAgent iAgent, IGraph iGraph) {
        iAgent.setAttribute(ARGUMENTATION_GRAPH, (Object)iGraph);
    }

    @GamlAnnotations.getter(value="crit_importance")
    public static IMap getCritImp(IAgent iAgent) {
        return (IMap)iAgent.getAttribute(CRIT_IMPORTANCE);
    }

    @GamlAnnotations.setter(value="crit_importance")
    public static void setCritImpo(IAgent iAgent, IMap iMap) {
        iAgent.setAttribute(CRIT_IMPORTANCE, (Object)iMap);
    }

    @GamlAnnotations.getter(value="source_type_confidence")
    public static IMap getSourceConf(IAgent iAgent) {
        return (IMap)iAgent.getAttribute(SOURCE_TYPE_CONFIDENCE);
    }

    @GamlAnnotations.setter(value="source_type_confidence")
    public static void setSourceConf(IAgent iAgent, IMap iMap) {
        iAgent.setAttribute(SOURCE_TYPE_CONFIDENCE, (Object)iMap);
    }

    @GamlAnnotations.action(name="evaluate_argument", args={@GamlAnnotations.arg(name="argument", type=175769925, optional=false, doc={@GamlAnnotations.doc(value="the argument to evaluate")})}, doc={@GamlAnnotations.doc(value="evaluate the strength  of an argument for the agent", returns="the strength of argument", examples={@GamlAnnotations.example(value="float val <- evaluate_argument(one_argument);")})})
    public Double primEvaluateArg(IScope iScope) throws GamaRuntimeException {
        GamaArgument gamaArgument = iScope.hasArg("argument") ? (GamaArgument)iScope.getArg("argument", 175769925) : null;
        return this.evaluate_arg(iScope, gamaArgument);
    }

    private DungAF toDungAF(IGraph iGraph) {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : iGraph.getVertices()) {
            arrayList.add(((GamaArgument)object2).getId());
        }
        object2 = new ArrayList();
        for (Iterator iterator : iGraph.getEdges()) {
            String[] stringArray = new String[]{((GamaArgument)iGraph.getEdgeSource((Object)iterator)).getId(), ((GamaArgument)iGraph.getEdgeTarget((Object)iterator)).getId()};
            object2.add((String[])stringArray);
        }
        return new DungAF(arrayList, object2);
    }

    private Map<String, GamaArgument> argumentPerName(IGraph iGraph) {
        Hashtable<String, GamaArgument> hashtable = new Hashtable<String, GamaArgument>();
        for (Object e : iGraph.getVertices()) {
            hashtable.put(((GamaArgument)e).getId(), (GamaArgument)e);
        }
        return hashtable;
    }

    private IList<IList> toGAMAList(IGraph iGraph, HashSet<HashSet<String>> hashSet) {
        Map<String, GamaArgument> map = this.argumentPerName(iGraph);
        IList iList = GamaListFactory.create();
        for (HashSet<String> hashSet2 : hashSet) {
            IList iList2 = GamaListFactory.create();
            for (String string : hashSet2) {
                iList2.add((Object)map.get(string));
            }
            iList.add((Object)iList2);
        }
        return iList;
    }

    @GamlAnnotations.action(name="preferred_extensions", args={@GamlAnnotations.arg(name="graph", type=15, optional=true, doc={@GamlAnnotations.doc(value="the graph to evaluate")})}, doc={@GamlAnnotations.doc(value="evaluate the preferred extensions of an argument graph", returns="a list of list of arguments representing the preferred extensions", examples={@GamlAnnotations.example(value="list<list<argument>> results <- preferred_extensions(a_graph);")})})
    public IList<IList> primComputePreferedExtension(IScope iScope) throws GamaRuntimeException {
        GamaGraph<GamaArgument, ?> gamaGraph = (GamaGraph<GamaArgument, ?>)iScope.getArg("graph", 15);
        if (gamaGraph == null) {
            gamaGraph = ArgumentingSkill.getArgGraph(iScope.getAgent());
        }
        DungAF dungAF = this.toDungAF((IGraph)gamaGraph);
        return this.toGAMAList((IGraph)gamaGraph, dungAF.getPreferredExts());
    }

    @GamlAnnotations.action(name="complete_extensions", args={@GamlAnnotations.arg(name="graph", type=15, optional=true, doc={@GamlAnnotations.doc(value="the graph to evaluate")})}, doc={@GamlAnnotations.doc(value="evaluate the complete extensions of an argument graph", returns="a list of list of arguments representing the complete extensions", examples={@GamlAnnotations.example(value="list<list<argument>> results <-complete_extensions(a_graph);")})})
    public IList<IList> primComputeCompletedExtension(IScope iScope) throws GamaRuntimeException {
        GamaGraph<GamaArgument, ?> gamaGraph = (GamaGraph<GamaArgument, ?>)iScope.getArg("graph", 15);
        if (gamaGraph == null) {
            gamaGraph = ArgumentingSkill.getArgGraph(iScope.getAgent());
        }
        DungAF dungAF = this.toDungAF((IGraph)gamaGraph);
        return this.toGAMAList((IGraph)gamaGraph, dungAF.getCompleteExts());
    }

    @GamlAnnotations.action(name="stable_extensions", args={@GamlAnnotations.arg(name="graph", type=15, optional=true, doc={@GamlAnnotations.doc(value="the graph to evaluate")})}, doc={@GamlAnnotations.doc(value="evaluate the stable extensions of an argument graph", returns="a list of list of arguments representing the stable extensions", examples={@GamlAnnotations.example(value="list<list<argument>> results <-stable_extensions(a_graph);")})})
    public IList<IList> primComputeStableExtension(IScope iScope) throws GamaRuntimeException {
        GamaGraph<GamaArgument, ?> gamaGraph = (GamaGraph<GamaArgument, ?>)iScope.getArg("graph", 15);
        if (gamaGraph == null) {
            gamaGraph = ArgumentingSkill.getArgGraph(iScope.getAgent());
        }
        DungAF dungAF = this.toDungAF((IGraph)gamaGraph);
        return this.toGAMAList((IGraph)gamaGraph, dungAF.getStableExts());
    }

    @GamlAnnotations.action(name="add_attack", args={@GamlAnnotations.arg(name="graph", type=15, optional=true, doc={@GamlAnnotations.doc(value="the graph to which add an attack")}), @GamlAnnotations.arg(name="source", type=175769925, optional=false, doc={@GamlAnnotations.doc(value="the source (argument) of the attack")}), @GamlAnnotations.arg(name="target", type=175769925, optional=false, doc={@GamlAnnotations.doc(value="the target (argument) of the attack")})}, doc={@GamlAnnotations.doc(value="add an attack to the argumention graph", examples={@GamlAnnotations.example(value="bool is_added <-add_attack(source_arg, target_arg);")})})
    public boolean primAddAttacks(IScope iScope) throws GamaRuntimeException {
        GamaArgument gamaArgument;
        GamaGraph<GamaArgument, ?> gamaGraph = (GamaGraph<GamaArgument, ?>)iScope.getArg("graph", 15);
        if (gamaGraph == null) {
            gamaGraph = ArgumentingSkill.getArgGraph(iScope.getAgent());
        }
        GamaArgument gamaArgument2 = iScope.hasArg("source") ? (GamaArgument)iScope.getArg("source", 175769925) : null;
        GamaArgument gamaArgument3 = gamaArgument = iScope.hasArg("target") ? (GamaArgument)iScope.getArg("target", 175769925) : null;
        if (gamaGraph != null && gamaArgument2 != null && gamaGraph.containsVertex((Object)gamaArgument2) && gamaArgument != null && gamaGraph.containsVertex((Object)gamaArgument)) {
            Object object = gamaGraph.addEdge((Object)gamaArgument2, (Object)gamaArgument);
            IAgent iAgent = iScope.getAgent();
            ISpecies iSpecies = iAgent.getSpecies();
            IStatement.WithArgs withArgs = iSpecies.getAction("evaluate_argument");
            Arguments arguments = new Arguments();
            arguments.put("argument", (IExpressionDescription)ConstantExpressionDescription.create((Object)gamaArgument2));
            withArgs.setRuntimeArgs(iScope, arguments);
            Double d = (Double)withArgs.executeOn(iScope);
            gamaGraph.setEdgeWeight(object, d.doubleValue());
            return true;
        }
        return false;
    }

    @GamlAnnotations.action(name="semi_stable_extensions", args={@GamlAnnotations.arg(name="graph", type=15, optional=true, doc={@GamlAnnotations.doc(value="the graph to evaluate")})}, doc={@GamlAnnotations.doc(value="evaluate the semi stable extensions of an argument graph", returns="a list of list of arguments representing the semi stable extensions", examples={@GamlAnnotations.example(value="list<list<argument>> results <-semi_stable_extensions(a_graph);")})})
    public IList<IList> primComputeSemiStableExtension(IScope iScope) throws GamaRuntimeException {
        GamaGraph<GamaArgument, ?> gamaGraph = (GamaGraph<GamaArgument, ?>)iScope.getArg("graph", 15);
        if (gamaGraph == null) {
            gamaGraph = ArgumentingSkill.getArgGraph(iScope.getAgent());
        }
        DungAF dungAF = this.toDungAF((IGraph)gamaGraph);
        return this.toGAMAList((IGraph)gamaGraph, dungAF.getSemiStableExts());
    }

    @GamlAnnotations.action(name="extensions", args={@GamlAnnotations.arg(name="graph", type=15, optional=true, doc={@GamlAnnotations.doc(value="the graph to evaluate")})}, doc={@GamlAnnotations.doc(value="evaluate the extensions of an argument graph", returns="a list of list of arguments representing the extensions", examples={@GamlAnnotations.example(value="list<list<argument>> results <- extensions();")})})
    public IList<IList> primComputeExtension(IScope iScope) throws GamaRuntimeException {
        return this.primComputePreferedExtension(iScope);
    }

    @GamlAnnotations.action(name="update_graph", doc={@GamlAnnotations.doc(value="update the weight of the argumentation graph", examples={@GamlAnnotations.example(value="do update_graph;")})})
    public void primUpdateArgumentationGraph(IScope iScope) throws GamaRuntimeException {
        GamaGraph<GamaArgument, ?> gamaGraph = ArgumentingSkill.getArgGraph(iScope.getAgent());
        ISpecies iSpecies = iScope.getAgent().getSpecies();
        IStatement.WithArgs withArgs = iSpecies.getAction("evaluate_argument");
        Arguments arguments = new Arguments();
        for (Object e : gamaGraph.getVertices()) {
            arguments.put("argument", (IExpressionDescription)ConstantExpressionDescription.create(e));
            withArgs.setRuntimeArgs(iScope, arguments);
            Double d = (Double)withArgs.executeOn(iScope);
            Set set = gamaGraph.outgoingEdgesOf(e);
            for (Object e2 : set) {
                gamaGraph.setEdgeWeight(e2, d.doubleValue());
            }
        }
    }

    @GamlAnnotations.action(name="simplify_graph", doc={@GamlAnnotations.doc(value="simplify the argumentation graph", examples={@GamlAnnotations.example(value="do simplify_graph;")})})
    public IGraph primSimplifyArgumentationGraph(IScope iScope) throws GamaRuntimeException {
        IGraph iGraph = ArgumentingSkill.getArgGraph(iScope.getAgent()).copy(iScope);
        IList iList = iGraph.getEdges().copy(iScope);
        for (Object e : iList) {
            if (!iGraph.containsEdge(e)) continue;
            Object object = iGraph.getEdgeSource(e);
            Object object2 = iGraph.getEdgeTarget(e);
            Object object3 = iGraph.getEdge(object2, object);
            if (object3 == null) continue;
            Double d = iGraph.getWeightOf(e);
            Double d2 = iGraph.getWeightOf(object3);
            if (d > d2) {
                iGraph.removeEdge(object3);
                continue;
            }
            if (!(d2 < d)) continue;
            iGraph.removeEdge(e);
        }
        return iGraph;
    }

    @GamlAnnotations.action(name="evaluate_conclusion", args={@GamlAnnotations.arg(name="arguments", type=16, optional=false, doc={@GamlAnnotations.doc(value="the list of arguments to evaluate")})}, doc={@GamlAnnotations.doc(value="evaluate the conclusion that can be taken from a list of arguments", returns="the conclusion of the list of arguments", examples={@GamlAnnotations.example(value="float val <- evaluate_conclusion(args);")})})
    public Double primEvaluateConcl(IScope iScope) throws GamaRuntimeException {
        IList iList;
        IList iList2 = iList = iScope.hasArg("arguments") ? (IList)iScope.getArg("arguments", 5) : null;
        if (iList == null || iList.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        IAgent iAgent = iScope.getAgent();
        ISpecies iSpecies = iAgent.getSpecies();
        IStatement.WithArgs withArgs = iSpecies.getAction("evaluate_argument");
        Arguments arguments = new Arguments();
        double d2 = 0.0;
        for (Object e : iList) {
            GamaArgument gamaArgument = (GamaArgument)e;
            arguments.put("argument", (IExpressionDescription)ConstantExpressionDescription.create((Object)gamaArgument));
            withArgs.setRuntimeArgs(iScope, arguments);
            Double d3 = (Double)withArgs.executeOn(iScope);
            d2 += d3.doubleValue();
            d += (gamaArgument.getConclusion().equals("+") ? 1.0 : (gamaArgument.getConclusion().equals("-") ? -1.0 : 0.0)) * d3;
        }
        return d2 == 0.0 ? 0.0 : d / d2;
    }

    @GamlAnnotations.action(name="add_argument", args={@GamlAnnotations.arg(name="agent", type=11, optional=true, doc={@GamlAnnotations.doc(value="the agent of which to compute the attitude")}), @GamlAnnotations.arg(name="argument", type=175769925, optional=false, doc={@GamlAnnotations.doc(value="the argument to add")}), @GamlAnnotations.arg(name="graph", type=15, optional=false, doc={@GamlAnnotations.doc(value="the global argumentation graph with all the arguments and attacks")})}, doc={@GamlAnnotations.doc(value="add an argument and all the attacks to the agent argumentation graph", examples={@GamlAnnotations.example(value="do add_argument(new_agrument, reference_graph);")})})
    public boolean primAddArguments(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent;
        IAgent iAgent2 = iAgent = iScope.hasArg("agent") ? (IAgent)iScope.getArg("agent", 11) : null;
        if (iAgent == null) {
            iAgent = iScope.getAgent();
        }
        GamaGraph<GamaArgument, ?> gamaGraph = ArgumentingSkill.getArgGraph(iAgent);
        IGraph iGraph = iScope.hasArg("graph") ? (IGraph)iScope.getArg("graph", 15) : null;
        GamaArgument gamaArgument = iScope.hasArg("argument") ? (GamaArgument)iScope.getArg("argument", 175769925) : null;
        GamaArgument gamaArgument2 = (GamaArgument)gamaArgument.copy(iScope);
        if (gamaGraph != null && gamaArgument != null && !gamaGraph.containsVertex((Object)gamaArgument2)) {
            gamaGraph.addVertex((Object)gamaArgument2);
            if (iGraph != null) {
                GamaArgument gamaArgument3;
                Set set = iGraph.outgoingEdgesOf((Object)gamaArgument2);
                for (Object e : set) {
                    gamaArgument3 = (GamaArgument)iGraph.getEdgeTarget(e);
                    if (!gamaGraph.containsVertex((Object)gamaArgument3)) continue;
                    gamaGraph.addEdge((Object)gamaArgument2, (Object)gamaArgument3);
                }
                set = iGraph.incomingEdgesOf((Object)gamaArgument2);
                for (Object e : set) {
                    gamaArgument3 = (GamaArgument)iGraph.getEdgeSource(e);
                    if (!gamaGraph.containsVertex((Object)gamaArgument3)) continue;
                    gamaGraph.addEdge((Object)gamaArgument3, (Object)gamaArgument2);
                }
            }
            return true;
        }
        return false;
    }

    @GamlAnnotations.action(name="remove_argument", args={@GamlAnnotations.arg(name="argument", type=175769925, optional=false, doc={@GamlAnnotations.doc(value="the argument to remove")})}, doc={@GamlAnnotations.doc(value="remove and arguments and all the attacks concerning this argument from the agent argumentation graph", examples={@GamlAnnotations.example(value="do remove_argument(an_agrument);")})})
    public static boolean primRemoveArguments(IScope iScope) throws GamaRuntimeException {
        GamaArgument gamaArgument;
        GamaGraph<GamaArgument, ?> gamaGraph = ArgumentingSkill.getArgGraph(iScope.getAgent());
        GamaArgument gamaArgument2 = gamaArgument = iScope.hasArg("argument") ? (GamaArgument)iScope.getArg("argument", 175769925) : null;
        if (gamaGraph != null && gamaArgument != null && gamaGraph.getVertices().contains((Object)gamaArgument)) {
            gamaGraph.removeVertex((Object)gamaArgument);
            return true;
        }
        return false;
    }

    @GamlAnnotations.action(name="make_decision", doc={@GamlAnnotations.doc(value="make decision concerning the option proposed by the argumentation graph", returns="a pair best extension:value: if the value is > 0, pro option; if value < 0, cons option, elsewere neutral", examples={@GamlAnnotations.example(value="do make_decision;")})})
    public GamaPair<IList<GamaArgument>, Double> primMakeDecision(IScope iScope) throws GamaRuntimeException {
        return (GamaPair)iScope.getAgent().getSpecies().getAction("get_best_extension").executeOn(iScope);
    }

    @GamlAnnotations.action(name="get_best_extension")
    public GamaPair<IList<GamaArgument>, Double> primGetBestExtension(IScope iScope) throws GamaRuntimeException {
        IStatement.WithArgs withArgs = iScope.getAgent().getSpecies().getAction("evaluate_extensions");
        IMap iMap = (IMap)withArgs.executeOn(iScope);
        Iterator iterator = Random.opShuffle((IScope)iScope, (IContainer)iMap.getKeys()).iterator();
        IList iList = iterator.hasNext() ? (IList)iterator.next() : null;
        double d = iList == null ? 0.0 : Math.abs((Double)iMap.get((Object)iList));
        while (iterator.hasNext()) {
            IList iList2 = (IList)iterator.next();
            double d2 = Math.abs((Double)iMap.get((Object)iList2));
            if (!(d2 > d)) continue;
            iList = iList2;
            d = d2;
        }
        return new GamaPair((Object)iList, (Object)((Double)iMap.get((Object)iList)), (IType)Types.LIST, (IType)Types.FLOAT);
    }

    @GamlAnnotations.action(name="evaluate_extensions")
    public IMap<IList<GamaArgument>, Double> primEvaluateExtensions(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        ISpecies iSpecies = iAgent.getSpecies();
        IStatement.WithArgs withArgs = iSpecies.getAction("update_graph");
        withArgs.executeOn(iScope);
        IStatement.WithArgs withArgs2 = iSpecies.getAction("simplify_graph");
        IGraph iGraph = (IGraph)withArgs2.executeOn(iScope);
        IStatement.WithArgs withArgs3 = iSpecies.getAction("extensions");
        Arguments arguments = new Arguments();
        arguments.put("graph", (IExpressionDescription)ConstantExpressionDescription.create((Object)iGraph));
        withArgs3.setRuntimeArgs(iScope, arguments);
        IList iList = (IList)withArgs3.executeOn(iScope);
        IMap iMap = GamaMapFactory.create((IType)Types.LIST, (IType)Types.FLOAT);
        IStatement.WithArgs withArgs4 = iSpecies.getAction("evaluate_conclusion");
        Arguments arguments2 = new Arguments();
        IList cfr_ignored_0 = (IList)iList.get(0);
        for (IList iList2 : iList) {
            arguments2.put("arguments", (IExpressionDescription)ConstantExpressionDescription.create((Object)iList2));
            withArgs4.setRuntimeArgs(iScope, arguments2);
            iMap.addValueAtIndex(iScope, (Object)iList2, (Object)((Double)withArgs4.executeOn(iScope)));
        }
        return iMap;
    }

    @GamlAnnotations.action(name="get_arguments_acceptabilities", args={@GamlAnnotations.arg(name="agent", type=11, optional=true, doc={@GamlAnnotations.doc(value="the agent of which to compute the arguments acceptabilities")}), @GamlAnnotations.arg(name="semantics", type=4, optional=true, doc={@GamlAnnotations.doc(value="the type of semantics used to compute the arguments acceptabilities: 'max', 'card', 'categorizer'")})}, doc={@GamlAnnotations.doc(value="compute acceptability values for all known arguments using the Amgoud and al. acceptability semantics for weighted argumentation graphs", returns="a map with arguments as key and acceptability as their respectives values", examples={@GamlAnnotations.example(value="map<argument,float> acceptability_values <- get_arg_acceptability();")})})
    public IMap<GamaArgument, Double> primGetArgumentsAcceptabilities(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent;
        IAgent iAgent2 = iAgent = iScope.hasArg("agent") ? (IAgent)iScope.getArg("agent", 11) : null;
        if (iAgent == null) {
            iAgent = iScope.getAgent();
        }
        String string = iScope.hasArg("semantics") ? iScope.getStringArg("semantics") : "max";
        GamaGraph<GamaArgument, ?> gamaGraph = ArgumentingSkill.getArgGraph(iAgent);
        IMap iMap = GamaMapFactory.create();
        IMap iMap2 = GamaMapFactory.create();
        for (GamaArgument gamaArgument : gamaGraph.getVertices()) {
            iMap.addValueAtIndex(iScope, (Object)gamaArgument, (Object)this.evaluate_arg(iScope, gamaArgument));
            iMap2.addValueAtIndex(iScope, (Object)gamaArgument, (Object)this.evaluate_arg(iScope, gamaArgument));
        }
        double d = 0.001f;
        double d2 = 1.0;
        boolean bl = false;
        boolean bl2 = false;
        if ("card".equals(string)) {
            bl2 = true;
        } else if ("max".equals(string)) {
            bl = true;
        }
        while (d2 > d) {
            d2 = 0.0;
            for (GamaArgument gamaArgument : gamaGraph.getVertices()) {
                double d3 = 0.0;
                Set set = gamaGraph.incomingEdgesOf((Object)gamaArgument);
                if (set.size() > 0) {
                    int n = set.size();
                    for (Object e : set) {
                        double d4 = (Double)iMap2.get(gamaGraph.getEdgeSource(e));
                        if (bl) {
                            d3 = Math.max(d4, d3);
                            continue;
                        }
                        d3 += d4;
                    }
                    if (bl2) {
                        d3 = (double)n + d3 / (double)n;
                    }
                }
                double d5 = (Double)iMap.get((Object)gamaArgument) / (1.0 + d3);
                d2 = Math.max((Double)iMap2.get((Object)gamaArgument) - d5, d2);
                iMap2.addValueAtIndex(iScope, (Object)gamaArgument, (Object)d5);
            }
        }
        return iMap2;
    }

    private double evaluate_arg(IScope iScope, GamaArgument gamaArgument) {
        IMap iMap;
        double d = 0.0;
        IAgent iAgent = iScope.getAgent();
        if (gamaArgument.getCriteria().isEmpty()) {
            d = 1.0;
        } else {
            iMap = ArgumentingSkill.getCritImp(iAgent);
            for (String string : gamaArgument.getCriteria().keySet()) {
                d += (Double)gamaArgument.getCriteria().get((Object)string) * (iMap.containsKey(string) ? (Double)iMap.get(string) : 1.0);
            }
        }
        if (gamaArgument.getSourceType() != null && !gamaArgument.getSourceType().isBlank() && (iMap = ArgumentingSkill.getSourceConf(iAgent)).containsKey(gamaArgument.getSourceType())) {
            d *= ((Double)iMap.get(gamaArgument.getSourceType())).doubleValue();
        }
        return d;
    }
}

