/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.argumentation.species;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.GamlAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.GamaPair;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.graph.GamaGraph;
import gama.core.util.graph.IGraph;
import gama.experimental.argumentation.skills.ArgumentingSkill;
import gama.experimental.argumentation.species.CommunicationChannel;
import gama.experimental.argumentation.types.GamaArgument;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.operators.Random;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Set;

@GamlAnnotations.species(name="abstract_adopter", skills={"argumenting"})
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="intention", type=2), @GamlAnnotations.variable(name="attitude", type=2), @GamlAnnotations.variable(name="social_norm", type=2), @GamlAnnotations.variable(name="pbc", type=2), @GamlAnnotations.variable(name="weight_attitude", type=2, init="1.0"), @GamlAnnotations.variable(name="weight_social_norm", type=2, init="1.0"), @GamlAnnotations.variable(name="weight_pbc", type=2, init="1.0"), @GamlAnnotations.variable(name="adoption_state", type=4, init="'knowledge'"), @GamlAnnotations.variable(name="persuasion_threshold", type=2, init="0.1"), @GamlAnnotations.variable(name="decision_threshold", type=1, init="5"), @GamlAnnotations.variable(name="adoption_threshold", type=2, init="0.5"), @GamlAnnotations.variable(name="confirmation_time", type=2, init="200.0"), @GamlAnnotations.variable(name="addoption_time", type=2, init="0.0"), @GamlAnnotations.variable(name="social_network", type=5, of=11), @GamlAnnotations.variable(name="proba_communication_channel", type=10), @GamlAnnotations.variable(name="influence_factor", type=2), @GamlAnnotations.variable(name="known_arguments", type=10), @GamlAnnotations.variable(name="intention_uncertainty", type=2, init="1.0"), @GamlAnnotations.variable(name="convergence_speed", type=2), @GamlAnnotations.variable(name="sigmoid_coeff", type=2, init="1.0"), @GamlAnnotations.variable(name="probability_exchange", type=2, init="1.0"), @GamlAnnotations.variable(name="argument_lifespan", type=2, init="100.0"), @GamlAnnotations.variable(name="global_argumentation_graph", type=15), @GamlAnnotations.variable(name="usage_arguments", type=5, of=175769925), @GamlAnnotations.variable(name="probability_innovation_usage", type=2, init="1.0"), @GamlAnnotations.variable(name="semantics", type=4, init="max")})
public class MIDAO
extends GamlAgent {
    static final String INTENTION = "intention";
    static final String ATTITUDE = "attitude";
    static final String SOCIAL_NORM = "social_norm";
    static final String PBC = "pbc";
    static final String WEIGHT_ATTITUDE = "weight_attitude";
    static final String WEIGHT_SOCIAL_NORM = "weight_social_norm";
    static final String WEIGHT_PBC = "weight_pbc";
    static final String KNOWLEDGE = "knowledge";
    static final String PERSUASION = "persuasion";
    static final String IMPLEMENTATION = "implementation";
    static final String DECISION = "decision";
    static final String CONFIRMATION = "confirmation";
    static final String PERSUASION_THRESHOLD = "persuasion_threshold";
    static final String DECISION_THRESHOLD = "decision_threshold";
    static final String ADOPTION_THRESHOLD = "adoption_threshold";
    static final String ADOPTION_STATE = "adoption_state";
    static final String CONFIRMATION_TIME = "confirmation_time";
    static final String ADOPTION_TIME = "addoption_time";
    static final String SOCIAL_NETWORK = "social_network";
    static final String PROBA_COMMUNICATION_CHANNEL = "proba_communication_channel";
    static final String INFLUENCE_FACTOR = "influence_factor";
    static final String KNWON_ARGUMENTS = "known_arguments";
    static final String INTENTION_UNCERTAINTY = "intention_uncertainty";
    static final String CONVERGENCE_SPEED = "convergence_speed";
    static final String SIGMOID_COEFF = "sigmoid_coeff";
    static final String PROBABILITY_EXCHANGE = "probability_exchange";
    static final String ARGUMENT_LIFESPAN = "argument_lifespan";
    static final String GLOBAL_ARGUMENTATION_GRAPH = "global_argumentation_graph";
    static final String USAGE_ARGUMENTS = "usage_arguments";
    static final String PROBABILITY_INNOVATION_USAGE = "probability_innovation_usage";
    static final String SEMANTICS = "semantics";

    public MIDAO(IPopulation<? extends IAgent> iPopulation, int n) {
        super(iPopulation, n);
    }

    @GamlAnnotations.getter(value="intention")
    public Double getIntention(IAgent iAgent) {
        return (Double)iAgent.getAttribute(INTENTION);
    }

    @GamlAnnotations.setter(value="intention")
    public void setIntention(IAgent iAgent, Double d) {
        iAgent.setAttribute(INTENTION, (Object)d);
    }

    @GamlAnnotations.getter(value="attitude")
    public Double getAttitude(IAgent iAgent) {
        return (Double)iAgent.getAttribute(ATTITUDE);
    }

    @GamlAnnotations.setter(value="attitude")
    public void setAttitude(IAgent iAgent, Double d) {
        iAgent.setAttribute(ATTITUDE, (Object)d);
    }

    @GamlAnnotations.getter(value="social_norm")
    public Double getSocialNorm(IAgent iAgent) {
        return (Double)iAgent.getAttribute(SOCIAL_NORM);
    }

    @GamlAnnotations.setter(value="social_norm")
    public void setSocialNorm(IAgent iAgent, Double d) {
        iAgent.setAttribute(SOCIAL_NORM, (Object)d);
    }

    @GamlAnnotations.getter(value="pbc")
    public Double getPBC(IAgent iAgent) {
        return (Double)iAgent.getAttribute(PBC);
    }

    @GamlAnnotations.setter(value="pbc")
    public void setPBC(IAgent iAgent, Double d) {
        iAgent.setAttribute(PBC, (Object)d);
    }

    @GamlAnnotations.getter(value="weight_attitude")
    public Double getWeightAttitude(IAgent iAgent) {
        return (Double)iAgent.getAttribute(WEIGHT_ATTITUDE);
    }

    @GamlAnnotations.setter(value="weight_attitude")
    public void setWeightAttitude(IAgent iAgent, Double d) {
        iAgent.setAttribute(WEIGHT_ATTITUDE, (Object)d);
    }

    @GamlAnnotations.getter(value="weight_social_norm")
    public Double getWeightSocialNorm(IAgent iAgent) {
        return (Double)iAgent.getAttribute(WEIGHT_SOCIAL_NORM);
    }

    @GamlAnnotations.setter(value="weight_social_norm")
    public void setWeightSocialNorm(IAgent iAgent, Double d) {
        iAgent.setAttribute(WEIGHT_SOCIAL_NORM, (Object)d);
    }

    @GamlAnnotations.getter(value="weight_pbc")
    public Double getWeightPBC(IAgent iAgent) {
        return (Double)iAgent.getAttribute(WEIGHT_PBC);
    }

    @GamlAnnotations.setter(value="weight_pbc")
    public void setWeightPBC(IAgent iAgent, Double d) {
        iAgent.setAttribute(WEIGHT_PBC, (Object)d);
    }

    @GamlAnnotations.getter(value="persuasion_threshold")
    public Double getPersuasionThreshold(IAgent iAgent) {
        return (Double)iAgent.getAttribute(PERSUASION_THRESHOLD);
    }

    @GamlAnnotations.setter(value="persuasion_threshold")
    public void setPersuasionThreshold(IAgent iAgent, Double d) {
        iAgent.setAttribute(PERSUASION_THRESHOLD, (Object)d);
    }

    @GamlAnnotations.getter(value="decision_threshold")
    public Integer getDecisionThreshold(IAgent iAgent) {
        return (Integer)iAgent.getAttribute(DECISION_THRESHOLD);
    }

    @GamlAnnotations.setter(value="decision_threshold")
    public void setDecisionThreshold(IAgent iAgent, Integer n) {
        iAgent.setAttribute(DECISION_THRESHOLD, (Object)n);
    }

    @GamlAnnotations.getter(value="adoption_threshold")
    public Double getAdoptionThreshold(IAgent iAgent) {
        return (Double)iAgent.getAttribute(ADOPTION_THRESHOLD);
    }

    @GamlAnnotations.setter(value="adoption_threshold")
    public void setAdoptionThreshold(IAgent iAgent, Double d) {
        iAgent.setAttribute(ADOPTION_THRESHOLD, (Object)d);
    }

    @GamlAnnotations.getter(value="adoption_state")
    public String getAdoptionState(IAgent iAgent) {
        return (String)iAgent.getAttribute(ADOPTION_STATE);
    }

    @GamlAnnotations.setter(value="adoption_state")
    public void setAdoptionState(IAgent iAgent, String string) {
        iAgent.setAttribute(ADOPTION_STATE, (Object)string);
    }

    @GamlAnnotations.getter(value="confirmation_time")
    public Double getConfirmationTime(IAgent iAgent) {
        return (Double)iAgent.getAttribute(CONFIRMATION_TIME);
    }

    @GamlAnnotations.setter(value="confirmation_time")
    public void setConfirmationTime(IAgent iAgent, Double d) {
        iAgent.setAttribute(CONFIRMATION_TIME, (Object)d);
    }

    @GamlAnnotations.getter(value="addoption_time")
    public Double getAdoptionTime(IAgent iAgent) {
        return (Double)iAgent.getAttribute(ADOPTION_TIME);
    }

    @GamlAnnotations.setter(value="addoption_time")
    public void setAdoptionTime(IAgent iAgent, Double d) {
        iAgent.setAttribute(ADOPTION_TIME, (Object)d);
    }

    @GamlAnnotations.getter(value="usage_arguments")
    public IList<GamaArgument> getUsageArguments(IAgent iAgent) {
        return (IList)iAgent.getAttribute(USAGE_ARGUMENTS);
    }

    @GamlAnnotations.setter(value="usage_arguments")
    public void setUsageArguments(IAgent iAgent, IList<GamaArgument> iList) {
        iAgent.setAttribute(USAGE_ARGUMENTS, iList);
    }

    @GamlAnnotations.getter(value="social_network")
    public IList<IAgent> getSocialNetwork(IAgent iAgent) {
        return (IList)iAgent.getAttribute(SOCIAL_NETWORK);
    }

    @GamlAnnotations.setter(value="social_network")
    public void setSocialNetwork(IAgent iAgent, IList<IAgent> iList) {
        iAgent.setAttribute(SOCIAL_NETWORK, iList);
    }

    @GamlAnnotations.getter(value="proba_communication_channel")
    public IMap<IAgent, Double> getProbaCommunicationChannel(IAgent iAgent) {
        return (IMap)iAgent.getAttribute(PROBA_COMMUNICATION_CHANNEL);
    }

    @GamlAnnotations.setter(value="proba_communication_channel")
    public void setProbaCommunicationChannel(IAgent iAgent, IMap<IAgent, Double> iMap) {
        iAgent.setAttribute(PROBA_COMMUNICATION_CHANNEL, iMap);
    }

    @GamlAnnotations.getter(value="known_arguments")
    public IMap<GamaArgument, GamaPair<Double, Double>> getKnownArguments(IAgent iAgent) {
        return (IMap)iAgent.getAttribute(KNWON_ARGUMENTS);
    }

    @GamlAnnotations.setter(value="known_arguments")
    public void setKnownArguments(IAgent iAgent, IMap<GamaArgument, GamaPair<Double, Double>> iMap) {
        iAgent.setAttribute(KNWON_ARGUMENTS, iMap);
    }

    @GamlAnnotations.getter(value="influence_factor")
    public Double getInfluenceFactor(IAgent iAgent) {
        return (Double)iAgent.getAttribute(INFLUENCE_FACTOR);
    }

    @GamlAnnotations.setter(value="influence_factor")
    public void setInfluenceFactor(IAgent iAgent, Double d) {
        iAgent.setAttribute(INFLUENCE_FACTOR, (Object)d);
    }

    @GamlAnnotations.getter(value="intention_uncertainty")
    public Double getIntentionUncertainty(IAgent iAgent) {
        return (Double)iAgent.getAttribute(INTENTION_UNCERTAINTY);
    }

    @GamlAnnotations.setter(value="intention_uncertainty")
    public void setIntentionUncertainty(IAgent iAgent, Double d) {
        iAgent.setAttribute(INTENTION_UNCERTAINTY, (Object)d);
    }

    @GamlAnnotations.getter(value="convergence_speed")
    public Double getConvergenceSpeed(IAgent iAgent) {
        return (Double)iAgent.getAttribute(CONVERGENCE_SPEED);
    }

    @GamlAnnotations.setter(value="convergence_speed")
    public void setConvergenceSpeed(IAgent iAgent, Double d) {
        iAgent.setAttribute(CONVERGENCE_SPEED, (Object)d);
    }

    @GamlAnnotations.getter(value="sigmoid_coeff")
    public Double getSigmoidCoeff(IAgent iAgent) {
        return (Double)iAgent.getAttribute(SIGMOID_COEFF);
    }

    @GamlAnnotations.setter(value="sigmoid_coeff")
    public void setSigmoidCoeff(IAgent iAgent, Double d) {
        iAgent.setAttribute(SIGMOID_COEFF, (Object)d);
    }

    @GamlAnnotations.getter(value="probability_innovation_usage")
    public Double getProbaInnovationUsage(IAgent iAgent) {
        return (Double)iAgent.getAttribute(PROBABILITY_INNOVATION_USAGE);
    }

    @GamlAnnotations.setter(value="probability_innovation_usage")
    public void setProbaInnovationUsage(IAgent iAgent, Double d) {
        iAgent.setAttribute(PROBABILITY_INNOVATION_USAGE, (Object)d);
    }

    @GamlAnnotations.getter(value="probability_exchange")
    public Double getProbaExchange(IAgent iAgent) {
        return (Double)iAgent.getAttribute(PROBABILITY_EXCHANGE);
    }

    @GamlAnnotations.setter(value="probability_exchange")
    public void setProbaExchange(IAgent iAgent, Double d) {
        iAgent.setAttribute(PROBABILITY_EXCHANGE, (Object)d);
    }

    @GamlAnnotations.getter(value="argument_lifespan")
    public Double getArgumentLifespan(IAgent iAgent) {
        return (Double)iAgent.getAttribute(ARGUMENT_LIFESPAN);
    }

    @GamlAnnotations.setter(value="argument_lifespan")
    public void setArgumentLifespan(IAgent iAgent, Double d) {
        iAgent.setAttribute(ARGUMENT_LIFESPAN, (Object)d);
    }

    @GamlAnnotations.getter(value="global_argumentation_graph")
    public static IGraph<GamaArgument, Object> getGlobalArgGraph(IAgent iAgent) {
        return (IGraph)iAgent.getAttribute(GLOBAL_ARGUMENTATION_GRAPH);
    }

    @GamlAnnotations.setter(value="global_argumentation_graph")
    public static void setGlobalArgGraph(IAgent iAgent, IGraph<GamaArgument, Object> iGraph) {
        iAgent.setAttribute(GLOBAL_ARGUMENTATION_GRAPH, iGraph);
    }

    @GamlAnnotations.getter(value="semantics")
    public String getSemantics(IAgent iAgent) {
        return (String)iAgent.getAttribute(SEMANTICS);
    }

    @GamlAnnotations.setter(value="semantics")
    public void setSemantics(IAgent iAgent, String string) {
        iAgent.setAttribute(SEMANTICS, (Object)string);
    }

    public boolean doStep(IScope iScope) {
        if (super.doStep(iScope)) {
            IAgent iAgent = this.getAgent();
            this.updateArgumentLifeSpan(iScope);
            String string = this.getAdoptionState(iAgent);
            if (KNOWLEDGE.equals(string)) {
                if (this.getIntention(iAgent) >= this.getPersuasionThreshold(iAgent)) {
                    this.setAdoptionState(iAgent, PERSUASION);
                }
            } else if (PERSUASION.equals(string)) {
                this.doActionNoArg(iScope, "search_information");
                if (this.getKnownArguments(iAgent).size() >= this.getDecisionThreshold(iAgent)) {
                    this.setAdoptionState(iAgent, DECISION);
                }
            } else if (DECISION.equals(string)) {
                this.doActionNoArg(iScope, "search_information");
                if (this.getIntention(iAgent) >= this.getAdoptionThreshold(iAgent)) {
                    this.setAdoptionState(iAgent, IMPLEMENTATION);
                    this.setAdoptionTime(iAgent, 0.0);
                }
            } else if (IMPLEMENTATION.equals(string)) {
                double d = this.getAdoptionTime(iAgent);
                this.setAdoptionTime(iAgent, d += iScope.getSimulation().getTimeStep(iScope));
                if (d >= this.getConfirmationTime(iAgent)) {
                    this.setAdoptionState(iAgent, CONFIRMATION);
                }
            }
            if (IMPLEMENTATION.equals(string) || CONFIRMATION.equals(string)) {
                if (!CONFIRMATION.equals(string) || this.getIntention(iAgent) >= this.getAdoptionThreshold(iAgent)) {
                    this.doActionNoArg(iScope, "get_usage_knowledge");
                }
                if (!this.getSocialNetwork(iAgent).isEmpty() && Random.opFlip((IScope)iScope, (Double)this.getProbaExchange(iAgent)).booleanValue()) {
                    IAgent iAgent2 = (IAgent)this.getSocialNetwork(iAgent).anyValue(iScope);
                    this.doAction1Arg(iScope, "interaction_with_other", "other", iAgent2);
                }
            }
            return true;
        }
        return false;
    }

    public void updateArgumentLifeSpan(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        IMap<GamaArgument, GamaPair<Double, Double>> iMap = this.getKnownArguments(iAgent);
        double d = iScope.getSimulation().getTimeStep(iScope);
        ArrayList arrayList = new ArrayList(iMap.keySet());
        boolean bl = false;
        for (GamaArgument gamaArgument : arrayList) {
            GamaPair gamaPair = (GamaPair)iMap.get((Object)gamaArgument);
            gamaPair.value = (Double)gamaPair.value - d;
            if (!((Double)gamaPair.value <= 0.0)) continue;
            ArgumentingSkill.getArgGraph(iAgent).removeVertex((Object)gamaArgument);
            iMap.remove((Object)gamaArgument);
            bl = true;
        }
        if (bl) {
            this.doAction1Arg(iScope, "change_in_known_arguments", "agent", iAgent);
        }
    }

    @GamlAnnotations.action(name="get_usage_knowledge", doc={@GamlAnnotations.doc(value="get new knwoledge for usage of the innovation", examples={@GamlAnnotations.example(value="do get_usage_knowledge;")})})
    public void primGetUsageKnowledge(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        IList<GamaArgument> iList = this.getUsageArguments(iAgent);
        if (!iList.isEmpty() && Random.opFlip((IScope)iScope, (Double)this.getProbaInnovationUsage(iAgent)).booleanValue()) {
            GamaArgument gamaArgument = (GamaArgument)iList.anyValue(iScope);
            this.addArguments(iScope, iAgent, gamaArgument, MIDAO.getGlobalArgGraph(iAgent));
        }
    }

    @GamlAnnotations.action(name="search_information", doc={@GamlAnnotations.doc(value="search for new information", examples={@GamlAnnotations.example(value="do search_information;")})})
    public void primSearchForInformation(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent;
        IAgent iAgent2 = iScope.getAgent();
        if (!this.getSocialNetwork(iAgent2).isEmpty() && Random.opFlip((IScope)iScope, (Double)this.getProbaExchange(iAgent2)).booleanValue()) {
            iAgent = (IAgent)this.getSocialNetwork(iAgent2).anyValue(iScope);
            this.doAction1Arg(iScope, "interaction_with_other", "other", iAgent);
        }
        if ((iAgent = this.getProbaCommunicationChannel(iAgent2)) != null) {
            for (IAgent iAgent3 : iAgent.keySet()) {
                IList<GamaArgument> iList;
                if (!Random.opFlip((IScope)iScope, (Double)((Double)iAgent.get((Object)iAgent3))).booleanValue() || (iList = CommunicationChannel.getArguments(iAgent3)).isEmpty()) continue;
                GamaArgument gamaArgument = (GamaArgument)iList.anyValue(iScope);
                this.addArguments(iScope, iAgent2, gamaArgument, MIDAO.getGlobalArgGraph(iAgent2));
            }
        }
    }

    @GamlAnnotations.action(name="compute_intention", args={@GamlAnnotations.arg(name="agent", type=11, optional=true, doc={@GamlAnnotations.doc(value="the agent of which to compute the attitude")})}, doc={@GamlAnnotations.doc(value="compute the intention from the attitude, social norm and the PBC", examples={@GamlAnnotations.example(value="do compute_intention;")})})
    public Double primComputeIntention(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = (IAgent)iScope.getArg("agent", 11);
        Double d = this.getWeightAttitude(iAgent);
        Double d2 = this.getWeightSocialNorm(iAgent);
        Double d3 = this.getWeightPBC(iAgent);
        Double d4 = d + d2 + d3;
        Double d5 = 0.0;
        d5 = d4 == 0.0 ? Double.valueOf((this.getAttitude(iAgent) + this.getSocialNorm(iAgent) + this.getPBC(iAgent)) / 3.0) : Double.valueOf((d * this.getAttitude(iAgent) + d2 * this.getSocialNorm(iAgent) + d3 * this.getPBC(iAgent)) / d4);
        this.setIntention(iAgent, d5);
        return d5;
    }

    @GamlAnnotations.action(name="change_in_known_arguments", args={@GamlAnnotations.arg(name="agent", type=2, optional=true, doc={@GamlAnnotations.doc(value="the agent of which to compute the attitude")})}, doc={@GamlAnnotations.doc(value="compute the attitude from the arguments", examples={@GamlAnnotations.example(value="do compute_attitude;")})})
    public void primKnownArgumentsModification(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent;
        IAgent iAgent2 = iAgent = iScope.hasArg("agent") ? (IAgent)iScope.getArg("agent", 11) : null;
        if (iAgent == null) {
            iAgent = iScope.getAgent();
        }
        this.doAction1Arg(iScope, "compute_attitude", "agent", iAgent);
        this.doAction1Arg(iScope, "compute_uncertainty", "agent", iAgent);
        this.doAction1Arg(iScope, "compute_intention", "agent", iAgent);
    }

    @GamlAnnotations.action(name="compute_attitude", args={@GamlAnnotations.arg(name="agent", type=2, optional=true, doc={@GamlAnnotations.doc(value="the agent of which to compute the attitude")})}, doc={@GamlAnnotations.doc(value="compute the attitude from the arguments", examples={@GamlAnnotations.example(value="do compute_attitude;")})})
    public Double primComputeAttitude(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent;
        IAgent iAgent2 = iAgent = iScope.hasArg("agent") ? (IAgent)iScope.getArg("agent", 11) : null;
        if (iAgent == null) {
            iAgent = iScope.getAgent();
        }
        Double d = 0.0;
        IMap<GamaArgument, GamaPair<Double, Double>> iMap = this.getKnownArguments(iAgent);
        if (!iMap.isEmpty()) {
            IMap iMap2 = (IMap)this.doAction2Arg(iScope, "get_arguments_acceptabilities", "agent", iAgent, SEMANTICS, this.getSemantics(iAgent));
            for (GamaArgument gamaArgument : iMap2.keySet()) {
                double d2 = (Double)iMap2.get((Object)gamaArgument);
                ((GamaPair)iMap.get((Object)gamaArgument)).key = d2;
                if (gamaArgument.getConclusion().equals("+")) {
                    d = d + d2;
                    continue;
                }
                if (!gamaArgument.getConclusion().equals("-")) continue;
                d = d + -1.0 * d2;
            }
            d = (Double)this.doAction2Arg(iScope, "normalize_attitude", "agent", iAgent, ATTITUDE, d);
        }
        this.setAttitude(iAgent, d);
        return d;
    }

    @GamlAnnotations.action(name="normalize_attitude", args={@GamlAnnotations.arg(name="agent", type=2, optional=true, doc={@GamlAnnotations.doc(value="the agent of which to compute the attitude")}), @GamlAnnotations.arg(name="attitude", type=2, optional=false, doc={@GamlAnnotations.doc(value="the value of attitude before normalization")})}, doc={@GamlAnnotations.doc(value="compute the normalize value of the attitude", examples={@GamlAnnotations.example(value="do normalize_attitude;")})})
    public Double primNormalizeAttitude(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent;
        IAgent iAgent2 = iAgent = iScope.hasArg("agent") ? (IAgent)iScope.getArg("agent", 11) : null;
        if (iAgent == null) {
            iAgent = iScope.getAgent();
        }
        Double d = iScope.getFloatArg(ATTITUDE);
        Double d2 = this.getSigmoidCoeff(iAgent);
        Double d3 = Math.exp(-1.0 * d2 * d);
        return (1.0 - d3) / (1.0 + d3);
    }

    @GamlAnnotations.action(name="compute_uncertainty", args={@GamlAnnotations.arg(name="agent", type=2, optional=true, doc={@GamlAnnotations.doc(value="the agent of which to compute the attitude")})}, doc={@GamlAnnotations.doc(value="compute the uncertainty of the agent", examples={@GamlAnnotations.example(value="do compute_uncertainty;")})})
    public Double primUpdateUncertainty(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent;
        IAgent iAgent2 = iAgent = iScope.hasArg("agent") ? (IAgent)iScope.getArg("agent", 11) : null;
        if (iAgent == null) {
            iAgent = iScope.getAgent();
        }
        Double d = 1.0;
        Double d2 = 0.0;
        IMap iMap = ArgumentingSkill.getSourceConf(iAgent);
        for (GamaArgument gamaArgument : this.getKnownArguments(iAgent).keySet()) {
            d2 = d2 + (Double)iMap.get((Object)gamaArgument.getSourceType());
        }
        d = 1.0 - Math.min(1.0, d2 / (double)this.getDecisionThreshold(iAgent).intValue());
        this.setIntentionUncertainty(iAgent, d);
        return d;
    }

    @GamlAnnotations.action(name="interaction_with_other", args={@GamlAnnotations.arg(name="other", type=11, optional=false, doc={@GamlAnnotations.doc(value="the other agent with which interact")})}, doc={@GamlAnnotations.doc(value="Interact with another agent - exchange arguments and update the social norm", examples={@GamlAnnotations.example(value="do interaction_with_other;")})})
    public void primInteractionWithOther(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        IAgent iAgent2 = (IAgent)iScope.getArg("other", 11);
        this.doAction1Arg(iScope, "update_social_norm", "other", iAgent2);
        if (!this.getKnownArguments(iAgent).isEmpty()) {
            this.doAction1Arg(iScope, "exchange_arguments", "other", iAgent2);
        }
    }

    @GamlAnnotations.action(name="exchange_arguments", args={@GamlAnnotations.arg(name="other", type=11, optional=false, doc={@GamlAnnotations.doc(value="the other agent with which interact")}), @GamlAnnotations.arg(name="graph", type=15, optional=false, doc={@GamlAnnotations.doc(value="the global argumentation graph with all the arguments and attacks")})}, doc={@GamlAnnotations.doc(value="exchane arguments with another agent, return true if at least one argument was exchanged", examples={@GamlAnnotations.example(value="do exchange_arguments(graph);")})})
    public void primExchangeArgument(IScope iScope) throws GamaRuntimeException {
        GamaArgument gamaArgument2;
        IAgent iAgent = iScope.getAgent();
        IAgent iAgent2 = (IAgent)iScope.getArg("other", 11);
        IGraph iGraph = iScope.hasArg("graph") ? (IGraph)iScope.getArg("graph", 15) : null;
        IMap iMap = GamaMapFactory.create();
        IMap<GamaArgument, GamaPair<Double, Double>> iMap2 = this.getKnownArguments(iAgent);
        for (GamaArgument gamaArgument2 : iMap2.keySet()) {
            iMap.put((Object)gamaArgument2, (Object)((Double)((GamaPair)iMap2.get((Object)gamaArgument2)).key));
        }
        gamaArgument2 = (GamaArgument)Random.opRndCoice((IScope)iScope, (IMap)iMap);
        this.doAction5Arg(iScope, "argument_react", "agent_proposing", iAgent, "agent_receiving", iAgent2, "arguments_exchanged", GamaListFactory.create(), "argument_proposed", gamaArgument2, "graph", iGraph);
    }

    @GamlAnnotations.action(name="update_social_norm", args={@GamlAnnotations.arg(name="other", type=11, optional=false, doc={@GamlAnnotations.doc(value="the other agent with which interact")})}, doc={@GamlAnnotations.doc(value="update the social norm according to the other agent", examples={@GamlAnnotations.example(value="do update_social_norm;")})})
    public void primUpdateSocialNorm(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        IAgent iAgent2 = (IAgent)iScope.getArg("other", 11);
        double d = this.getSocialNorm(iAgent);
        double d2 = this.getSocialNorm(iAgent2);
        d += this.getConvergenceSpeed(iAgent) * (1.0 - this.getIntentionUncertainty(iAgent2)) * (this.getIntention(iAgent2) - d);
        this.setSocialNorm(iAgent, d);
        d2 += this.getConvergenceSpeed(iAgent2) * (1.0 - this.getIntentionUncertainty(iAgent)) * (this.getIntention(iAgent) - d2);
        this.setSocialNorm(iAgent2, d2);
        this.doAction1Arg(iScope, "compute_intention", "agent", iAgent);
        this.doAction1Arg(iScope, "compute_intention", "agent", iAgent2);
    }

    @GamlAnnotations.action(name="new_argument", args={@GamlAnnotations.arg(name="argument", type=175769925, optional=false, doc={@GamlAnnotations.doc(value="the new argument to add")}), @GamlAnnotations.arg(name="lifespan", type=2, optional=true, doc={@GamlAnnotations.doc(value="the lifespan of the new argument to add")})}, doc={@GamlAnnotations.doc(value="add a new argument", examples={@GamlAnnotations.example(value="do new_argument(arg1);")})})
    public void primNewArgument(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        GamaArgument gamaArgument = (GamaArgument)iScope.getArg("argument", 175769925);
        Double d = iScope.hasArg("lifespan") ? (Double)iScope.getArg("lifespan", 2) : -1.0;
        Double d2 = this.getArgumentLifespan(iAgent);
        if (d >= 0.0) {
            this.setArgumentLifespan(iAgent, d);
        }
        this.addArguments(iScope, iAgent, gamaArgument, MIDAO.getGlobalArgGraph(iAgent));
        if (d >= 0.0) {
            this.setArgumentLifespan(iAgent, d2);
        }
    }

    private void addArguments(IScope iScope, IAgent iAgent, GamaArgument gamaArgument, IGraph<GamaArgument, Object> iGraph) {
        IMap<GamaArgument, GamaPair<Double, Double>> iMap = this.getKnownArguments(iAgent);
        if (iMap.keySet().contains(gamaArgument)) {
            GamaPair gamaPair = (GamaPair)iMap.get((Object)gamaArgument);
            gamaPair.setValue((Object)this.getArgumentLifespan(iAgent));
            iMap.put((Object)gamaArgument, (Object)gamaPair);
        } else {
            GamaPair gamaPair = new GamaPair((Object)0.0, (Object)this.getArgumentLifespan(iAgent), (IType)Types.FLOAT, (IType)Types.FLOAT);
            iMap.put((Object)gamaArgument, (Object)gamaPair);
            this.setKnownArguments(iAgent, iMap);
            this.doAction3Arg(iScope, "add_argument", "agent", iAgent, "argument", gamaArgument, "graph", iGraph);
            this.doAction1Arg(iScope, "change_in_known_arguments", "agent", iAgent);
        }
    }

    @GamlAnnotations.action(name="argument_react", args={@GamlAnnotations.arg(name="agent_proposing", type=11, optional=false, doc={@GamlAnnotations.doc(value="the agent proposing the argument")}), @GamlAnnotations.arg(name="agent_receiving", type=11, optional=false, doc={@GamlAnnotations.doc(value="the agent receiving the argument")}), @GamlAnnotations.arg(name="arguments_exchanged", type=5, optional=false, doc={@GamlAnnotations.doc(value="the argument already exchanged by the two agents")}), @GamlAnnotations.arg(name="argument_proposed", type=175769925, optional=false, doc={@GamlAnnotations.doc(value="the argument proposed by the other agent")}), @GamlAnnotations.arg(name="graph", type=15, optional=false, doc={@GamlAnnotations.doc(value="the global argumentation graph with all the arguments and attacks")})}, doc={@GamlAnnotations.doc(value="behavior of an agent receiving a argument from another agent", examples={@GamlAnnotations.example(value="do argument_react(ap,ar,arguments, arg, global_graph);")})})
    public void primArgumentReact(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = (IAgent)iScope.getArg("agent_receiving", 11);
        IAgent iAgent2 = (IAgent)iScope.getArg("agent_proposing", 11);
        GamaArgument gamaArgument = (GamaArgument)iScope.getArg("argument_proposed", 175769925);
        IMap<GamaArgument, GamaPair<Double, Double>> iMap = this.getKnownArguments(iAgent2);
        GamaPair gamaPair = (GamaPair)iMap.get((Object)gamaArgument);
        gamaPair.setValue((Object)this.getArgumentLifespan(iAgent2));
        iMap.put((Object)gamaArgument, (Object)gamaPair);
        IList iList = (IList)iScope.getArg("arguments_exchanged", 5);
        IGraph iGraph = iScope.hasArg("graph") ? (IGraph)iScope.getArg("graph", 15) : null;
        GamaArgument gamaArgument2 = (GamaArgument)this.doAction3Arg(iScope, "argument_attacking", "agent_receiving", iAgent, "argument_proposed", gamaArgument, "arguments_exchanged", iList);
        if (gamaArgument2 != null && ((Boolean)this.doAction3Arg(iScope, "argument_consistency", "agent_proposing", iAgent, "agent_receiving", iAgent2, "argument_proposed", gamaArgument2)).booleanValue()) {
            if (!iList.contains((Object)gamaArgument2)) {
                iList.add((Object)gamaArgument2);
                this.addArguments(iScope, iAgent, gamaArgument, (IGraph<GamaArgument, Object>)iGraph);
                this.doAction5Arg(iScope, "argument_react", "agent_proposing", iAgent, "agent_receiving", iAgent2, "arguments_exchanged", iList, "argument_proposed", gamaArgument2, "graph", iGraph);
            }
        } else if (((Boolean)this.doAction2Arg(iScope, "trust_other", "agent_proposing", iAgent2, "agent_receiving", iAgent)).booleanValue()) {
            this.addArguments(iScope, iAgent, gamaArgument, (IGraph<GamaArgument, Object>)iGraph);
        }
    }

    @GamlAnnotations.action(name="argument_consistency", args={@GamlAnnotations.arg(name="agent_proposing", type=11, optional=false, doc={@GamlAnnotations.doc(value="the agent proposing the argument")}), @GamlAnnotations.arg(name="agent_receiving", type=11, optional=false, doc={@GamlAnnotations.doc(value="the agent receiving the argument")}), @GamlAnnotations.arg(name="argument_proposed", type=175769925, optional=false, doc={@GamlAnnotations.doc(value="the argument proposed by the other agent")})}, doc={@GamlAnnotations.doc(value="return true if the agent proposing the argument considers its consistent in the discussion with the other agent", examples={@GamlAnnotations.example(value="do argument_consistence(ap,ar,arg);")})})
    public Boolean primArgumentConsistency(IScope iScope) throws GamaRuntimeException {
        Double d;
        IAgent iAgent = (IAgent)iScope.getArg("agent_receiving", 11);
        IAgent iAgent2 = (IAgent)iScope.getArg("agent_proposing", 11);
        GamaArgument gamaArgument = (GamaArgument)iScope.getArg("argument_proposed", 175769925);
        Double d2 = this.getIntention(iAgent);
        if (d2 == (d = this.getIntention(iAgent2))) {
            return true;
        }
        if (d > d2) {
            return gamaArgument.getConclusion().equals("+");
        }
        return gamaArgument.getConclusion().equals("-");
    }

    @GamlAnnotations.action(name="argument_attacking", args={@GamlAnnotations.arg(name="agent_receiving", type=11, optional=false, doc={@GamlAnnotations.doc(value="the agent receiving the argument")}), @GamlAnnotations.arg(name="argument_proposed", type=175769925, optional=false, doc={@GamlAnnotations.doc(value="the argument proposed by the other agent")}), @GamlAnnotations.arg(name="arguments_exchanged", type=5, optional=false, doc={@GamlAnnotations.doc(value="the argument already exchanged by the two agents")})}, doc={@GamlAnnotations.doc(value="return an argument known by the agent receiving that attacks the argument proposed, nil otherwise", examples={@GamlAnnotations.example(value="do argument_attacking(ar,ap,args);")})})
    public GamaArgument primArgumentAttacking(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = (IAgent)iScope.getArg("agent_receiving", 11);
        GamaArgument gamaArgument = (GamaArgument)iScope.getArg("argument_proposed", 175769925);
        IMap<GamaArgument, GamaPair<Double, Double>> iMap = this.getKnownArguments(iAgent);
        GamaGraph<GamaArgument, ?> gamaGraph = ArgumentingSkill.getArgGraph(iAgent);
        IList iList = (IList)iScope.getArg("arguments_exchanged", 5);
        GamaArgument gamaArgument2 = null;
        Double d = -1.7976931348623157E308;
        Set set = gamaGraph.incomingEdgesOf((Object)gamaArgument);
        for (Object e : set) {
            Double d2;
            GamaArgument gamaArgument3 = (GamaArgument)gamaGraph.getEdgeSource(e);
            if (iList.contains((Object)gamaArgument3) || !((d2 = (Double)((GamaPair)iMap.get((Object)gamaArgument3)).key) > d)) continue;
            d = d2;
            gamaArgument2 = gamaArgument3;
        }
        return gamaArgument2;
    }

    @GamlAnnotations.action(name="trust_other", args={@GamlAnnotations.arg(name="agent_proposing", type=11, optional=false, doc={@GamlAnnotations.doc(value="the agent proposing the argument")}), @GamlAnnotations.arg(name="agent_receiving", type=11, optional=false, doc={@GamlAnnotations.doc(value="the agent receiving the argument")})}, doc={@GamlAnnotations.doc(value="return true if the agent tu the social norm according to the other agent", examples={@GamlAnnotations.example(value="do trust_other(ap,ar);")})})
    public Boolean primTrustOther(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = (IAgent)iScope.getArg("agent_receiving", 11);
        IAgent iAgent2 = (IAgent)iScope.getArg("agent_proposing", 11);
        Double d = this.getIntention(iAgent);
        Double d2 = this.getInfluenceFactor(iAgent);
        Double d3 = this.getIntentionUncertainty(iAgent);
        Double d4 = this.getIntention(iAgent2);
        Double d5 = this.getInfluenceFactor(iAgent2);
        if (d + d3 >= d4 - d5 + d2 && d - d3 <= d4 + d5 - d2) {
            return true;
        }
        return false;
    }

    private Object doActionNoArg(IScope iScope, String string) {
        IStatement.WithArgs withArgs = this.getAgent().getSpecies().getAction(string);
        return withArgs.executeOn(iScope);
    }

    private Object doAction1Arg(IScope iScope, String string, String string2, Object object) {
        Arguments arguments = new Arguments();
        arguments.put(string2, (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)object));
        IStatement.WithArgs withArgs = this.getAgent().getSpecies().getAction(string);
        withArgs.setRuntimeArgs(iScope, arguments);
        return withArgs.executeOn(iScope);
    }

    private Object doAction2Arg(IScope iScope, String string, String string2, Object object, String string3, Object object2) {
        Arguments arguments = new Arguments();
        arguments.put(string2, (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)object));
        arguments.put(string3, (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)object2));
        IStatement.WithArgs withArgs = this.getAgent().getSpecies().getAction(string);
        withArgs.setRuntimeArgs(iScope, arguments);
        return withArgs.executeOn(iScope);
    }

    private Object doAction3Arg(IScope iScope, String string, String string2, Object object, String string3, Object object2, String string4, Object object3) {
        Arguments arguments = new Arguments();
        arguments.put(string2, (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)object));
        arguments.put(string3, (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)object2));
        arguments.put(string4, (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)object3));
        IStatement.WithArgs withArgs = this.getAgent().getSpecies().getAction(string);
        withArgs.setRuntimeArgs(iScope, arguments);
        return withArgs.executeOn(iScope);
    }

    private Object doAction5Arg(IScope iScope, String string, String string2, Object object, String string3, Object object2, String string4, Object object3, String string5, Object object4, String string6, Object object5) {
        Arguments arguments = new Arguments();
        arguments.put(string2, (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)object));
        arguments.put(string3, (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)object2));
        arguments.put(string4, (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)object3));
        arguments.put(string5, (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)object4));
        arguments.put(string6, (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)object5));
        IStatement.WithArgs withArgs = this.getAgent().getSpecies().getAction(string);
        withArgs.setRuntimeArgs(iScope, arguments);
        return withArgs.executeOn(iScope);
    }
}

