/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.bayesiannetwork.operators;

import cc.kave.repackaged.jayes.BayesNode;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMap;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.experimental.bayesiannetwork.types.GamaBayesianNetwork;
import gama.gaml.operators.Cast;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BayesianNetworkOperator {
    @GamlAnnotations.operator(value={"create_node"}, category={"bayesian_network"}, concept={"bayesian_network"})
    public static GamaBayesianNetwork createNode(IScope iScope, GamaBayesianNetwork gamaBayesianNetwork, String string) {
        if (gamaBayesianNetwork == null) {
            return null;
        }
        gamaBayesianNetwork.getNetwork().createNode(string);
        return gamaBayesianNetwork;
    }

    @GamlAnnotations.operator(value={"add_node_outcome"}, category={"bayesian_network"}, concept={"bayesian_network"})
    public static GamaBayesianNetwork addNodeOutcome(IScope iScope, GamaBayesianNetwork gamaBayesianNetwork, String string, String string2) {
        if (gamaBayesianNetwork == null) {
            return null;
        }
        BayesNode bayesNode = gamaBayesianNetwork.getNetwork().getNode(string);
        if (bayesNode != null) {
            bayesNode.addOutcome(string2);
        } else {
            GamaRuntimeException.error((String)("Node " + string + " does not exist in network " + gamaBayesianNetwork.getId()), (IScope)iScope);
        }
        return gamaBayesianNetwork;
    }

    @GamlAnnotations.operator(value={"add_node_parent"}, category={"bayesian_network"}, concept={"bayesian_network"})
    public static GamaBayesianNetwork addNodeParent(IScope iScope, GamaBayesianNetwork gamaBayesianNetwork, String string, String string2) {
        if (gamaBayesianNetwork == null) {
            return null;
        }
        BayesNode bayesNode = gamaBayesianNetwork.getNetwork().getNode(string);
        BayesNode bayesNode2 = gamaBayesianNetwork.getNetwork().getNode(string2);
        if (bayesNode == null) {
            GamaRuntimeException.error((String)("Node " + string + " does not exist in network " + gamaBayesianNetwork.getId()), (IScope)iScope);
        } else if (bayesNode2 == null) {
            GamaRuntimeException.error((String)("Node " + string2 + " does not exist in network " + gamaBayesianNetwork.getId()), (IScope)iScope);
        } else {
            ArrayList<BayesNode> arrayList = new ArrayList<BayesNode>();
            arrayList.addAll(bayesNode.getParents());
            arrayList.add(bayesNode2);
            bayesNode.setParents(arrayList);
        }
        return gamaBayesianNetwork;
    }

    @GamlAnnotations.operator(value={"add_node_probabilities"}, category={"bayesian_network"}, concept={"bayesian_network"})
    public static GamaBayesianNetwork addNodeProbabilities(IScope iScope, GamaBayesianNetwork gamaBayesianNetwork, String string, GamaMap<Object, Object> gamaMap) {
        if (gamaBayesianNetwork == null) {
            return null;
        }
        BayesNode bayesNode = gamaBayesianNetwork.getNetwork().getNode(string);
        if (bayesNode == null) {
            GamaRuntimeException.error((String)("Node " + string + " does not exist in network " + gamaBayesianNetwork.getId()), (IScope)iScope);
        } else if (bayesNode.getParents().isEmpty()) {
            int n = bayesNode.getOutcomeCount();
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                Object object = gamaMap.get(bayesNode.getOutcomes().get(n2));
                if (object == null || !(object instanceof Double) && !(object instanceof Integer)) {
                    GamaRuntimeException.error((String)("problem with probabilities " + String.valueOf(gamaMap) + ": inconsistency with network " + gamaBayesianNetwork.getId()), (IScope)iScope);
                } else {
                    dArray[n2] = Cast.asFloat((IScope)iScope, (Object)object);
                }
                ++n2;
            }
            bayesNode.setProbabilities(dArray);
        } else {
            IList iList = GamaListFactory.create();
            BayesianNetworkOperator.combinaison((List<Map<String, String>>)iList, (Map<String, String>)GamaMapFactory.create(), 0, bayesNode);
            double[] dArray = new double[iList.size() * bayesNode.getOutcomeCount()];
            int n = 0;
            for (Map map : iList) {
                Map map2 = (Map)gamaMap.get((Object)map);
                for (String string2 : bayesNode.getOutcomes()) {
                    Object v = map2.get(string2);
                    if (v == null || !(v instanceof Double) && !(v instanceof Integer)) {
                        GamaRuntimeException.error((String)("problem with probabilities " + String.valueOf(gamaMap) + ": inconsistency with network " + gamaBayesianNetwork.getId()), (IScope)iScope);
                    } else {
                        dArray[n] = Cast.asFloat((IScope)iScope, v);
                    }
                    ++n;
                }
            }
            bayesNode.setProbabilities(dArray);
        }
        return gamaBayesianNetwork;
    }

    static void combinaison(List<Map<String, String>> list, Map<String, String> map, int n, BayesNode bayesNode) {
        if (n >= bayesNode.getParents().size()) {
            list.add(map);
        } else {
            BayesNode bayesNode2 = (BayesNode)bayesNode.getParents().get(n);
            for (String string : bayesNode2.getOutcomes()) {
                IMap iMap = GamaMapFactory.create();
                iMap.putAll(map);
                iMap.put(bayesNode2.getName(), string);
                BayesianNetworkOperator.combinaison(list, (Map<String, String>)iMap, n + 1, bayesNode);
            }
        }
    }

    @GamlAnnotations.operator(value={"add_node_evidence"}, category={"bayesian_network"}, concept={"bayesian_network"})
    public static GamaBayesianNetwork addNodeEvidence(IScope iScope, GamaBayesianNetwork gamaBayesianNetwork, String string, String string2) {
        if (gamaBayesianNetwork == null) {
            return null;
        }
        gamaBayesianNetwork.getInference().setNetwork(gamaBayesianNetwork.getNetwork());
        BayesNode bayesNode = gamaBayesianNetwork.getNetwork().getNode(string);
        if (bayesNode == null) {
            GamaRuntimeException.error((String)("Node " + string + " does not exist in network " + gamaBayesianNetwork.getId()), (IScope)iScope);
        } else {
            gamaBayesianNetwork.getInference().addEvidence(bayesNode, string2);
        }
        return gamaBayesianNetwork;
    }

    @GamlAnnotations.operator(value={"get_beliefs"}, category={"bayesian_network"}, concept={"bayesian_network"})
    public static GamaMap<String, Double> getBeliefs(IScope iScope, GamaBayesianNetwork gamaBayesianNetwork, String string) {
        GamaMap gamaMap = (GamaMap)GamaMapFactory.create();
        if (gamaBayesianNetwork == null) {
            return gamaMap;
        }
        BayesNode bayesNode = gamaBayesianNetwork.getNetwork().getNode(string);
        if (bayesNode == null) {
            GamaRuntimeException.error((String)("Node " + string + " does not exist in network " + gamaBayesianNetwork.getId()), (IScope)iScope);
        } else {
            double[] dArray = gamaBayesianNetwork.getInference().getBeliefs(bayesNode);
            int n = 0;
            while (n < dArray.length) {
                gamaMap.put((Object)((String)bayesNode.getOutcomes().get(n)), (Object)dArray[n]);
                ++n;
            }
        }
        return gamaMap;
    }
}

