/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.bayesiannetwork.types;

import cc.kave.repackaged.jayes.BayesNet;
import cc.kave.repackaged.jayes.BayesNode;
import cc.kave.repackaged.jayes.inference.IBayesInferer;
import cc.kave.repackaged.jayes.inference.junctionTree.JunctionTreeAlgorithm;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import java.util.List;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="id", type=4), @GamlAnnotations.variable(name="nodes", type=5)})
public class GamaBayesianNetwork
implements IValue {
    private BayesNet network;
    private IBayesInferer inference;

    public GamaBayesianNetwork(String string) {
        this.network = new BayesNet();
        this.inference = new JunctionTreeAlgorithm();
        this.network.setName(string);
    }

    public GamaBayesianNetwork(BayesNet bayesNet) {
        this.network = bayesNet;
        this.inference = new JunctionTreeAlgorithm();
        this.inference.setNetwork(this.network);
    }

    @GamlAnnotations.getter(value="id")
    public String getId() {
        return this.network.getName();
    }

    @GamlAnnotations.getter(value="nodes")
    public IList<String> getNodes() {
        List list = this.network.getNodes();
        IList iList = GamaListFactory.EMPTY_LIST;
        for (BayesNode bayesNode : list) {
            iList.add((Object)bayesNode.getName());
        }
        return iList;
    }

    public BayesNet getNetwork() {
        return this.network;
    }

    public void setNetwork(BayesNet bayesNet) {
        this.network = bayesNet;
    }

    public IBayesInferer getInference() {
        return this.inference;
    }

    public void setInference(IBayesInferer iBayesInferer) {
        this.inference = iBayesInferer;
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.getId() + " -> " + String.valueOf(this.getNodes());
    }

    public IValue copy(IScope iScope) throws GamaRuntimeException {
        GamaBayesianNetwork gamaBayesianNetwork = new GamaBayesianNetwork(this.network);
        return gamaBayesianNetwork;
    }

    public JsonValue serializeToJson(Json json) {
        return null;
    }
}

