/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.apsf.spaces;

import gama.core.runtime.IScope;
import gama.experimental.apsf.exception.APSFException;
import gama.experimental.apsf.exception.AlreadyCreatedParticle;
import gama.experimental.apsf.exception.UnBreakableParticle;
import gama.experimental.apsf.spaces.OrganicMatter;
import gama.experimental.apsf.spaces.Particle;
import gama.experimental.apsf.spaces.SoilLocation;
import gama.experimental.apsf.spaces.WhiteParticle;
import gama.experimental.apsf.template.Template;
import java.util.Enumeration;
import java.util.Hashtable;

public class Agglomerate
extends Particle {
    private Template template;
    private final Hashtable<String, Particle> subParticle;
    private double referenceOMWeight;
    private double referenceSolidWeight;
    private double organicMatterMassPerCell;
    private double solidMassPerCell;
    private double fractalMassPerCell;

    public void deploySubParticles(IScope iScope) {
        int n = this.template.getSize();
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n) {
                    SoilLocation soilLocation = this.getSubParticleLocation(n2, n3, n4);
                    this.getWorld().getParticleAtLocation(iScope, soilLocation);
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public SoilLocation getSubParticleLocation(int n, int n2, int n3) {
        SoilLocation soilLocation = SoilLocation.changeScale(this.location, this.location.getScale() + 1);
        return new SoilLocation(soilLocation.getX() + n, soilLocation.getY() + n2, soilLocation.getZ() + n3, soilLocation.getScale(), this.getWorld());
    }

    @Override
    public void setParent(Agglomerate agglomerate) {
        super.setParent(agglomerate);
        int n = this.getWorld().getDivisionPerLevel();
        this.organicMatterWeight = (agglomerate.referenceOMWeight - agglomerate.organicMatterMassPerCell * agglomerate.getTemplate().getOrganic() * (double)this.getWorld().getDivisionPerLevel()) / (agglomerate.getTemplate().getFractal() * (double)n);
        this.solidWeight = (agglomerate.referenceSolidWeight - agglomerate.solidMassPerCell * agglomerate.getTemplate().getSolid() * (double)this.getWorld().getDivisionPerLevel()) / (agglomerate.getTemplate().getFractal() * (double)n);
        this.precomputeMatters();
    }

    public float countSolidQuantity() {
        float f = 0.0f;
        Enumeration<Particle> enumeration = this.subParticle.elements();
        while (enumeration.hasMoreElements()) {
            Particle particle = enumeration.nextElement();
            if (particle instanceof OrganicMatter) {
                f += 1.0f;
            }
            if (!(particle instanceof Agglomerate)) continue;
            f += ((Agglomerate)particle).countSolidQuantity();
        }
        return f / (float)(this.getWorld().getDivisionPerLevel() * this.getWorld().getDivisionPerLevel() * this.getWorld().getDivisionPerLevel());
    }

    public float countDeployedOrganicQuantityInFractal() {
        float f = 0.0f;
        Enumeration<Particle> enumeration = this.subParticle.elements();
        while (enumeration.hasMoreElements()) {
            Particle particle = enumeration.nextElement();
            if (!(particle instanceof Agglomerate)) continue;
            f = (float)((double)f + ((Agglomerate)particle).getOrganicMatter());
        }
        return f / (float)(this.getWorld().getDivisionPerLevel() * this.getWorld().getDivisionPerLevel() * this.getWorld().getDivisionPerLevel());
    }

    public int countDeployedFractal() {
        int n = 0;
        Enumeration<Particle> enumeration = this.subParticle.elements();
        while (enumeration.hasMoreElements()) {
            Particle particle = enumeration.nextElement();
            if (!(particle instanceof Agglomerate)) continue;
            ++n;
        }
        return n;
    }

    public int countDeployedOrganicMatter() {
        int n = 0;
        Enumeration<Particle> enumeration = this.subParticle.elements();
        while (enumeration.hasMoreElements()) {
            Particle particle = enumeration.nextElement();
            Class<? extends Particle> clazz = this.getTemplate().getParticleClass(particle.getPI(), particle.getPJ(), particle.getPK());
            if (!clazz.equals(OrganicMatter.class)) continue;
            ++n;
        }
        return n;
    }

    public Enumeration<Particle> getSubParticle() {
        return this.subParticle.elements();
    }

    public Agglomerate() {
        this.subParticle = new Hashtable();
        this.organicMatterWeight = 0.0;
        this.referenceOMWeight = 0.0;
    }

    public Agglomerate(Template template) {
        this.subParticle = new Hashtable();
        this.template = template;
        this.organicMatterWeight = 0.0;
        this.referenceOMWeight = 0.0;
    }

    public Agglomerate(Agglomerate agglomerate) {
        super(agglomerate);
        this.organicMatterWeight = agglomerate.organicMatterWeight;
        this.subParticle = new Hashtable();
        this.template = agglomerate.template;
        this.referenceOMWeight = agglomerate.referenceOMWeight;
        this.agent = agglomerate.agent;
    }

    @Override
    public void setAttribute(String string, Object object) {
    }

    @Override
    public Object getAttribute(String string) {
        return null;
    }

    @Override
    public String toString() {
        return this.level + ":" + (int)this.size + ":" + this.pI + ":" + this.pJ + ":" + this.pK + ":" + this.organicMatterWeight + ":" + this.solidWeight + ":" + this.referenceOMWeight + ":" + this.referenceSolidWeight + ":" + this.organicMatterMassPerCell + ":" + this.solidMassPerCell + ":" + this.fractalMassPerCell + ":" + this.getTemplateName();
    }

    @Override
    public Object parseString(String string) {
        String[] stringArray = string.split(":");
        this.level = Integer.valueOf(stringArray[0]);
        this.pI = Integer.valueOf(stringArray[2]);
        this.pJ = Integer.valueOf(stringArray[3]);
        this.pK = Integer.valueOf(stringArray[4]);
        this.organicMatterWeight = Float.valueOf(stringArray[5]).floatValue();
        this.solidWeight = Float.valueOf(stringArray[6]).floatValue();
        this.referenceOMWeight = Float.valueOf(stringArray[7]).floatValue();
        this.referenceSolidWeight = Float.valueOf(stringArray[8]).floatValue();
        this.organicMatterMassPerCell = Float.valueOf(stringArray[9]).floatValue();
        this.solidMassPerCell = Float.valueOf(stringArray[10]).floatValue();
        this.fractalMassPerCell = Float.valueOf(stringArray[11]).floatValue();
        return this;
    }

    public Particle findParticle(IScope iScope, SoilLocation soilLocation) {
        if (soilLocation.equals(this.getLocation())) {
            return this;
        }
        int[] nArray = new int[3];
        SoilLocation soilLocation2 = this.getLocation();
        nArray = Particle.getMatrixId(soilLocation, soilLocation2.getScale() + 1);
        String string = Particle.getKey(nArray[0], nArray[1], nArray[2]);
        if (soilLocation.getScale() == soilLocation2.getScale() + 1) {
            Particle particle = this.subParticle.get(string);
            if (particle != null) {
                return particle;
            }
            return this;
        }
        Particle particle = this.subParticle.get(string);
        if (particle != null) {
            if (particle instanceof Agglomerate) {
                return ((Agglomerate)particle).findParticle(iScope, soilLocation);
            }
            return particle;
        }
        return this;
    }

    public void removeSubParticle(Particle particle) {
        this.subParticle.remove(particle.getKey());
        this.porosityHaveBeenModified = true;
    }

    @Override
    public void putParticle(IScope iScope, Particle particle) throws APSFException {
        this.porosityHaveBeenModified = true;
        SoilLocation soilLocation = this.getLocation();
        SoilLocation soilLocation2 = particle.getLocation();
        int[] nArray = Particle.getMatrixId(soilLocation2, soilLocation, soilLocation.getScale() + 1);
        if (soilLocation2.getScale() == soilLocation.getScale() + 1) {
            particle.setMatrixCoordinate(nArray[0], nArray[1], nArray[2]);
            Particle particle2 = this.subParticle.get(particle.getKey());
            if (particle2 != null) {
                throw new AlreadyCreatedParticle();
            }
            particle.setMatrixCoordinate(nArray[0], nArray[1], nArray[2]);
            this.subParticle.put(particle.getKey(), particle);
            particle.setParent(this);
        } else {
            String string = Particle.getKey(nArray[0], nArray[1], nArray[2]);
            Particle particle3 = this.subParticle.get(string);
            if (particle3 != null) {
                if (!(particle3 instanceof Agglomerate)) {
                    throw new UnBreakableParticle();
                }
                particle3.putParticle(iScope, particle);
            } else {
                SoilLocation soilLocation3 = SoilLocation.changeScale(particle.getLocation(), soilLocation.getScale() + 1);
                SoilLocation soilLocation4 = new SoilLocation(soilLocation3.getX() + nArray[0], soilLocation3.getY() + nArray[1], soilLocation3.getZ() + nArray[2], soilLocation.getScale() + 1, soilLocation3.getWorld());
                particle3 = this.getTemplate().getNewParticleInstance(iScope, soilLocation4);
                particle3.putParticle(iScope, particle);
            }
        }
    }

    public int getNbCellWithType(Class<WhiteParticle> clazz) {
        int n = 0;
        Enumeration<Particle> enumeration = this.subParticle.elements();
        while (enumeration.hasMoreElements()) {
            Particle particle = enumeration.nextElement();
            if (particle.getClass().equals(clazz)) {
                if (this.template.getParticleClass(particle.getPI(), particle.getPJ(), particle.getPK()).equals(clazz)) continue;
                ++n;
                continue;
            }
            if (!this.template.getParticleClass(particle.getPI(), particle.getPJ(), particle.getPK()).equals(clazz)) continue;
            --n;
        }
        int n2 = this.template.getSize();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n2) {
                    if (this.template.getParticleClass(n3, n4, n5).equals(clazz)) {
                        ++n;
                    }
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        return n;
    }

    public double getPorosityInFractalCells() {
        Object object;
        Object object2;
        Object object3;
        double d = 0.0;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        Enumeration<Particle> enumeration = this.subParticle.elements();
        while (enumeration.hasMoreElements()) {
            Particle particle = enumeration.nextElement();
            Particle particle2 = this.template.getParticle(particle.getPI(), particle.getPJ(), particle.getPK());
            if (particle instanceof Agglomerate) {
                d += ((Agglomerate)particle).getPorosity();
            }
            if (!(particle2 instanceof Agglomerate)) continue;
            object3 = ((Agglomerate)particle2).getTemplate();
            if (hashtable2.containsKey(((Template)object3).getTemplateName())) {
                object2 = (Integer)hashtable.get(((Template)object3).getTemplateName());
                hashtable.remove(((Template)object3).getTemplateName());
                hashtable.put(((Template)object3).getTemplateName(), new Integer((Integer)object2 - 1));
                continue;
            }
            hashtable.put(((Template)object3).getTemplateName(), new Integer(-1));
            hashtable2.put(((Template)object3).getTemplateName(), object3);
        }
        int n = this.template.getSize();
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n) {
                    object = this.template.getParticle(n2, n3, n4);
                    if (object instanceof Agglomerate) {
                        String string = ((Agglomerate)object).getTemplateName();
                        if (hashtable2.containsKey(string)) {
                            Integer n5 = (Integer)hashtable.get(string);
                            hashtable.remove(string);
                            hashtable.put(string, new Integer(n5 + 1));
                        } else {
                            hashtable.put(string, new Integer(1));
                            hashtable2.put(string, ((Agglomerate)object).getTemplate());
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        Enumeration enumeration2 = hashtable2.keys();
        while (enumeration2.hasMoreElements()) {
            object3 = (String)enumeration2.nextElement();
            object2 = (Template)hashtable2.get(object3);
            object = (Integer)hashtable.get(object3);
            d += (double)((Integer)object).intValue() * ((Template)object2).getPorosity(this.location.getWorld());
        }
        return d / (double)this.getWorld().getDivisionPerLevel();
    }

    public double getPorosityAtCurrentSubSpaceLevel() {
        int n = this.getNbCellWithType(WhiteParticle.class);
        double d = this.getWorld().getDivisionPerLevel();
        return (double)n / d;
    }

    @Override
    public double getPorosity() {
        double d = this.getPorosityAtCurrentSubSpaceLevel();
        double d2 = this.getPorosityInFractalCells();
        this.porosityHaveBeenModified = false;
        this.porosity = d += d2;
        return d;
    }

    public double getOrganicMatter() {
        return this.organicMatterWeight;
    }

    protected void setOrganicMatter(float f) {
        this.organicMatterWeight = f;
        this.referenceOMWeight = f;
    }

    @Override
    public Particle clone() {
        return new Agglomerate(this);
    }

    public Template getTemplate() {
        return this.template;
    }

    public double getReferenceOMQte() {
        return this.referenceOMWeight;
    }

    public void setReferenceOMQte(double d) {
        this.referenceOMWeight = d;
    }

    public double getReferenceMineralWeight() {
        return this.referenceSolidWeight;
    }

    public void setReferenceMineralWeight(double d) {
        this.referenceSolidWeight = d;
    }

    public double getReferenceOMWeight() {
        return this.referenceOMWeight;
    }

    public void setReferenceOMWeight(double d) {
        this.referenceOMWeight = d;
    }

    public double getFractalMass() {
        return this.fractalMassPerCell;
    }

    public void setFractalMass(double d) {
        this.fractalMassPerCell = d;
    }

    public double getOrganicMatterMass() {
        return this.organicMatterMassPerCell;
    }

    public void setOrganicMatterMass(double d) {
        this.organicMatterMassPerCell = d;
    }

    public double getSolidMass() {
        return this.solidMassPerCell;
    }

    public void setSolidMass(double d) {
        this.solidMassPerCell = d;
    }

    @Override
    public void initMatters(double d, double d2) {
        this.organicMatterWeight = d;
        this.solidWeight = d2;
        this.precomputeMatters();
    }

    private void precomputeMatters() {
        this.referenceOMWeight = this.organicMatterWeight;
        this.referenceSolidWeight = this.solidWeight;
        double d = 0.0;
        if (this.getParent() == null) {
            d = SoilLocation.getCellSize(1, this.getWorld());
        } else {
            SoilLocation soilLocation = this.getParent().getLocation();
            d = SoilLocation.getCellSize(soilLocation.getScale() + 2, this.getWorld());
        }
        double d2 = d * d * d;
        this.organicMatterMassPerCell = (double)this.getTemplate().getOrganicMatterVolumicMass() * d2;
        this.solidMassPerCell = (double)this.getTemplate().getSolidVolumicMass() * d2;
        this.fractalMassPerCell = this.referenceOMWeight + this.referenceSolidWeight - (double)this.getWorld().getDivisionPerLevel() * (this.getTemplate().getOrganic() * this.organicMatterMassPerCell + this.getTemplate().getSolid() * this.solidMassPerCell);
    }

    @Override
    public String getTemplateName() {
        return this.template == null ? null : this.template.getTemplateName();
    }

    public void setTemplate(Template template) {
        this.template = template;
    }
}

