/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.apsf.spaces;

import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.experimental.apsf.exception.UnBreakableParticle;
import gama.experimental.apsf.spaces.Agglomerate;
import gama.experimental.apsf.spaces.Particle;
import gama.experimental.apsf.spaces.SoilLocation;
import gama.experimental.apsf.template.Template;
import gama.gaml.species.GamlSpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class Apsf {
    public static float DEFAULT_WORLD_DIMENSION = 20.0f;
    public static int DIVISION_PER_LEVEL = 10;
    private final double dimension;
    private int division_per_level;
    private Agglomerate spaceRoot;
    private Map<String, Template> templates;
    private final IAgent macroAgent;
    private GamlSpecies mySpecies;

    public void setDefaultSpecies(GamlSpecies gamlSpecies) {
        this.mySpecies = gamlSpecies;
    }

    public GamlSpecies getDefaultSpecies() {
        return this.mySpecies;
    }

    public IAgent getUnderworldAgent() {
        return this.macroAgent;
    }

    public int getDivisionPerLevel() {
        return this.division_per_level;
    }

    public void setDivisionPerLevel(int n) {
        this.division_per_level = n;
    }

    public Apsf(IAgent iAgent) {
        this.dimension = DEFAULT_WORLD_DIMENSION;
        this.templates = new HashMap<String, Template>();
        this.macroAgent = iAgent;
    }

    public Apsf(double d, int n, IAgent iAgent) {
        this.dimension = d;
        this.division_per_level = n;
        this.macroAgent = iAgent;
    }

    public Template getTemplateWithName(String string) {
        return this.templates.get(string);
    }

    public double getDimension() {
        return this.dimension;
    }

    public Agglomerate getAPSF() {
        return this.spaceRoot;
    }

    public void defineTemplateTree(Template template) {
        this.templates = new HashMap<String, Template>();
        ArrayList<Template> arrayList = template.getAllSubTemplate();
        for (Template object2 : arrayList) {
            this.templates.put(object2.getTemplateName(), object2);
        }
        SoilLocation soilLocation = new SoilLocation(0, 0, 0, 0, this);
        this.spaceRoot = new Agglomerate(template);
        this.spaceRoot.setLocation(soilLocation);
    }

    public ArrayList<Template> findBranchTo(Template template) {
        if (template == this.getAPSF().getTemplate()) {
            ArrayList<Template> arrayList = new ArrayList<Template>();
            arrayList.add(template);
            return arrayList;
        }
        Collection<Template> collection = this.templates.values();
        for (Template template2 : collection) {
            if (!template2.isParentOf(template.getTemplateName())) continue;
            ArrayList<Template> arrayList = this.findBranchTo(template2);
            arrayList.add(0, template);
            return arrayList;
        }
        return null;
    }

    SoilLocation chooseLocationInside(Agglomerate agglomerate, String string, boolean bl) {
        Particle particle = agglomerate.getTemplate().getSamplerWithCharacteristics(string);
        SoilLocation soilLocation = agglomerate.getSubParticleLocation(particle.getPI(), particle.getPJ(), particle.getPK());
        return soilLocation;
    }

    public Particle getOneParticleWithCharacteristics(IScope iScope, Template template, int n, String string, boolean bl) {
        SoilLocation soilLocation;
        ++n;
        Particle particle = this.getAPSF();
        ArrayList<Template> arrayList = this.findBranchTo(template);
        int n2 = arrayList.size();
        int n3 = n2 - 1;
        while (n3 >= 0 && n >= n2 - n3) {
            String string2 = string;
            if (n3 > 0 && n2 - n3 != n) {
                string2 = arrayList.get(n3 - 1).getTemplateName();
            }
            soilLocation = this.chooseLocationInside((Agglomerate)particle, string2, bl);
            particle = this.getParticleAtLocation(iScope, soilLocation);
            --n3;
        }
        if (n == n2 - n3) {
            return particle;
        }
        int n4 = n2;
        while (n4 < n) {
            soilLocation = this.chooseLocationInside((Agglomerate)particle, ((Particle)particle).getTemplateName(), bl);
            particle = this.getParticleAtLocation(iScope, soilLocation);
            ++n4;
        }
        soilLocation = this.chooseLocationInside((Agglomerate)particle, string, bl);
        particle = this.getParticleAtLocation(iScope, soilLocation);
        return particle;
    }

    public Particle getParticleAtLocation(IScope iScope, SoilLocation soilLocation) {
        Particle particle = this.spaceRoot.findParticle(iScope, soilLocation);
        while (particle instanceof Agglomerate && particle.getLocation().getScale() != soilLocation.getScale()) {
            SoilLocation soilLocation2 = SoilLocation.changeScale(soilLocation, particle.getLocation().getScale() + 1);
            Particle particle2 = ((Agglomerate)particle).getTemplate().getNewParticleInstance(iScope, soilLocation2);
            particle2.setParent((Agglomerate)particle);
            try {
                particle.putParticle(iScope, particle2);
            }
            catch (UnBreakableParticle unBreakableParticle) {
                particle = this.spaceRoot.findParticle(iScope, soilLocation);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            particle = particle2;
        }
        return particle;
    }

    public double countTotalOrganicMatter() {
        return this.countTotalMatter("green_particle");
    }

    public double countTotalSandMatter() {
        return this.countTotalMatter("black_particle");
    }

    public double countOrganicMatterAtSizeScale(int n) {
        return this.countMatterAtSizeScale(n, "green_particle");
    }

    public double countSandMatterAtSizeScale(int n) {
        return this.countMatterAtSizeScale(n, "black_particle");
    }

    public double countPorousMatterAtSizeScale(int n) {
        return this.countMatterAtSizeScale(n, "white_particle");
    }

    public double countTotalMatter(String string) {
        double d = 0.0;
        int n = 0;
        while (n < 4) {
            double d2 = this.countMatterAtSizeScale(n, string);
            d += d2;
            ++n;
        }
        return d;
    }

    public double countMatterAtSizeScale(int n, String string) {
        long l = (long)Math.pow(this.spaceRoot.getTemplate().getNumberOfCell(), n + 1);
        long l2 = this.countMatterAtSizeScale(n, string, this.spaceRoot.getTemplate(), 0);
        return (double)l2 / (double)l;
    }

    private long countMatterAtSizeScale(int n, String string, Template template, int n2) {
        long l = 0L;
        if (n == n2) {
            l = template.getNbCellsOfTemplateWithName(string);
        } else {
            Enumeration<Template> enumeration = template.getSubTemplates();
            while (enumeration.hasMoreElements()) {
                Template template2 = enumeration.nextElement();
                long l2 = template.getNbCellsOfTemplateWithName(template2.getTemplateName());
                l += l2 * this.countMatterAtSizeScale(n, string, template2, n2 + 1);
            }
        }
        return l;
    }
}

