/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.apsf.template;

import gama.experimental.apsf.spaces.Agglomerate;
import gama.experimental.apsf.spaces.OrganicMatter;
import gama.experimental.apsf.spaces.Particle;
import gama.experimental.apsf.spaces.SandParticle;
import gama.experimental.apsf.spaces.SoilLocation;
import gama.experimental.apsf.spaces.WhiteParticle;
import gama.experimental.apsf.template.Template;
import gama.experimental.camisole.RandomGenerator;
import java.util.ArrayList;

public class SoilTemplate
extends Template {
    public static final String DEFAULT_NAME = "Soil template";
    private int ecartType = 2;
    private int esperance = 5;

    int gaussNbCells(double d, double d2) {
        return Math.round((float)RandomGenerator.getNormalGen(d2, d).nextDouble());
    }

    void pushWhiteParticle(int n, int n2, int n3, int n4) {
        float f = 0.0f;
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            int n7 = n - n6;
            if (n7 < 0) {
                n7 = 0;
            }
            while (n7 < this.size && n7 <= n + n6 && n5 < n4) {
                int n8 = n2 - n6;
                if (n8 < 0) {
                    n8 = 0;
                }
                while (n8 < this.size && n8 <= n2 + n6 && n5 < n4) {
                    int n9 = n3 - n6;
                    if (n9 < 0) {
                        n9 = 0;
                    }
                    while (n9 < this.size && n9 <= n3 + n6 && n5 < n4) {
                        if (this.getParticle(n7, n8, n9) instanceof Agglomerate) {
                            WhiteParticle whiteParticle = new WhiteParticle();
                            whiteParticle.setLocation(new SoilLocation(n7, n8, n9, 1, null));
                            this.setTemplate(whiteParticle, n7, n8, n9, f);
                            ++n5;
                        }
                        ++n9;
                    }
                    ++n8;
                }
                ++n7;
            }
            if (++n6 != 5) continue;
            n4 = 0;
        }
    }

    ArrayList<Agglomerate> getAllAgglomerate() {
        ArrayList<Agglomerate> arrayList = new ArrayList<Agglomerate>();
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < this.size) {
                int n3 = 0;
                while (n3 < this.size) {
                    Particle particle = this.getParticle(n, n2, n3);
                    if (particle instanceof Agglomerate) {
                        arrayList.add((Agglomerate)particle);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    public void generateTemplateFinal(Template template) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        template = template == null ? this : template;
        int n6 = 0;
        while (n6 < this.size) {
            n5 = 0;
            while (n5 < this.size) {
                n4 = 0;
                while (n4 < this.size) {
                    Agglomerate agglomerate = new Agglomerate(template);
                    agglomerate.setLocation(new SoilLocation(n6, n5, n4, 1, null));
                    this.setTemplate(agglomerate, n6, n5, n4, 0.0);
                    ++n4;
                }
                ++n5;
            }
            ++n6;
        }
        n6 = (int)((1.0 - this.solid - this.fractal - this.organic) * (double)(this.size * this.size * this.size));
        n5 = 0;
        while (n5 < n6) {
            n4 = this.gaussNbCells(this.ecartType, this.esperance);
            int n7 = (int)Math.round(Math.random() * (double)this.size) % this.size;
            int n8 = (int)Math.round(Math.random() * (double)this.size) % this.size;
            n3 = (int)Math.round(Math.random() * (double)this.size) % this.size;
            this.pushWhiteParticle(n7, n8, n3, n4);
            n5 += n4;
        }
        n4 = (int)(this.organic * (double)(this.size * this.size * this.size));
        int n9 = 0;
        ArrayList<Agglomerate> arrayList = this.getAllAgglomerate();
        while (n9 < n4 && arrayList.size() > 0) {
            n3 = (int)Math.round(Math.random() * (double)(arrayList.size() - 1));
            Agglomerate agglomerate = arrayList.get(n3);
            arrayList.remove(n3);
            n2 = agglomerate.getPI();
            int n10 = agglomerate.getPJ();
            n = agglomerate.getPK();
            OrganicMatter organicMatter = new OrganicMatter();
            organicMatter.setLocation(new SoilLocation(n2, n10, n, 1, null));
            this.setTemplate(organicMatter, n2, n10, n, 0.0);
            ++n9;
        }
        n3 = (int)(this.solid * (double)(this.size * this.size * this.size));
        int n11 = 0;
        arrayList = this.getAllAgglomerate();
        while (n11 < n3 && arrayList.size() > 0) {
            n2 = (int)Math.round(Math.random() * (double)(arrayList.size() - 1));
            Agglomerate agglomerate = arrayList.get(n2);
            arrayList.remove(n2);
            n = agglomerate.getPI();
            int n12 = agglomerate.getPJ();
            int n13 = agglomerate.getPK();
            SandParticle sandParticle = new SandParticle();
            sandParticle.setLocation(new SoilLocation(n, n12, n13, 1, null));
            this.setTemplate(sandParticle, n, n12, n13, 0.0);
            ++n11;
        }
    }

    public SoilTemplate(String string, float f, float f2, float f3, int n, int n2, int n3) {
        super(string, f, f2, f3, n);
        this.ecartType = n2;
        this.esperance = n3;
        this.generateTemplateFinal(this);
    }

    public SoilTemplate(String string, float f, float f2, float f3, int n, int n2, int n3, Template template) {
        super(string, f, f2, f3, n, template);
        this.ecartType = n2;
        this.esperance = n3;
        this.generateTemplateFinal(template);
    }

    public SoilTemplate(float f, float f2, float f3, int n, int n2, int n3, Template template) {
        super(DEFAULT_NAME, f, f2, f3, n, template);
        this.ecartType = n2;
        this.esperance = n3;
        this.generateTemplateFinal(template);
    }

    public SoilTemplate(float f, float f2, float f3, int n, int n2, int n3) {
        super(DEFAULT_NAME, f, f2, f3, n);
        this.ecartType = n2;
        this.esperance = n3;
        this.generateTemplateFinal(this);
    }

    public SoilTemplate() {
        super(DEFAULT_NAME, 0.0f, 0.0f, 0.0f, 10);
        this.ecartType = 0;
        this.esperance = 0;
    }

    @Override
    public void generateTemplate() {
    }
}

