/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.apsf.template;

import gama.experimental.apsf.spaces.Agglomerate;
import gama.experimental.apsf.spaces.SoilLocation;
import gama.experimental.apsf.spaces.TechnoSoilHorizon;
import gama.experimental.apsf.spaces.WhiteParticle;
import gama.experimental.apsf.template.SoilTemplate;
import gama.experimental.apsf.template.Template;

public class TechnoSolTemplate
extends Template {
    public static final String DEFAULT_NAME = "Soil template";
    private final TechnoSoilHorizon[] horizons;

    private double gaussDistribution(double d, double d2, double d3) {
        double d4 = (d - d3) / d2;
        return 1.0 / (d2 * Math.sqrt(Math.PI * 2)) * Math.exp(-0.5 * (d4 * d4));
    }

    int gaussNbCells(double d, double d2, double d3) {
        double d4 = this.gaussDistribution(0.0, d2, d3);
        int n = 0;
        while (d4 < d) {
            d4 = d4 + this.gaussDistribution(++n, d2, d3) + 0.001;
        }
        int n2 = Math.round(n);
        return n2;
    }

    void pushWhiteParticle(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            int n7 = n - n6;
            if (n7 < 0) {
                n7 = 0;
            }
            while (n7 < this.size && n7 <= n + n6 && n5 < n4) {
                int n8 = n2 - n6;
                if (n8 < 0) {
                    n8 = 0;
                }
                while (n8 < this.size && n8 <= n2 + n6 && n5 < n4) {
                    int n9 = n3 - n6;
                    if (n9 < 0) {
                        n9 = 0;
                    }
                    while (n9 < this.size && n9 <= n3 + n6 && n5 < n4) {
                        if (this.getParticle(n7, n8, n9) instanceof Agglomerate) {
                            WhiteParticle whiteParticle = new WhiteParticle();
                            whiteParticle.setLocation(new SoilLocation(n7, n8, n9, 1, null));
                            this.setTemplate(whiteParticle, n7, n8, n9, 0.0);
                            ++n5;
                        }
                        ++n9;
                    }
                    ++n8;
                }
                ++n7;
            }
            if (++n6 != 5) continue;
            n4 = 0;
        }
    }

    public void generateTemplateFinal() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            int n4 = 0;
            while (n4 < this.size) {
                n = 0;
                n2 = 0;
                TechnoSoilHorizon[] technoSoilHorizonArray = this.horizons;
                int n5 = this.horizons.length;
                int n6 = 0;
                while (n6 < n5) {
                    TechnoSoilHorizon technoSoilHorizon = technoSoilHorizonArray[n6];
                    n2 += technoSoilHorizon.getDepth();
                    int n7 = n;
                    while (n7 < n2) {
                        SoilTemplate soilTemplate = null;
                        soilTemplate = technoSoilHorizon.getHorizon();
                        Agglomerate agglomerate = new Agglomerate(soilTemplate);
                        agglomerate.setLocation(new SoilLocation(n3, n4, n7, 1, null));
                        this.setTemplate(agglomerate, n3, n4, n7, 0.0);
                        ++n7;
                    }
                    n += technoSoilHorizon.getDepth();
                    ++n6;
                }
                ++n4;
            }
            ++n3;
        }
    }

    public TechnoSolTemplate(String string, int n, TechnoSoilHorizon[] technoSoilHorizonArray) {
        super(string, 0.0f, 1.0f, 0.0f, n);
        TechnoSoilHorizon[] technoSoilHorizonArray2 = this.horizons = technoSoilHorizonArray;
        int n2 = this.horizons.length;
        int n3 = 0;
        while (n3 < n2) {
            TechnoSoilHorizon technoSoilHorizon = technoSoilHorizonArray2[n3];
            System.out.println("size horizon = " + technoSoilHorizon.getDepth());
            ++n3;
        }
        this.generateTemplateFinal();
    }

    @Override
    public void generateTemplate() {
    }
}

