/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.apsf.template;

import gama.experimental.apsf.template.DejectionFractal;
import gama.experimental.apsf.template.EmptyTemplate;
import gama.experimental.apsf.template.FractalTemplate;
import gama.experimental.apsf.template.SandTemplate;
import gama.experimental.apsf.template.SoilTemplate;
import gama.experimental.apsf.template.Template;

public class TemplateFactory {
    private Template[] templateList;
    private int size;
    private static final int TEMPLATES_NB = 5;
    public static final int SOIL_TEMPLATE = 0;
    public static final int DEJECTION_TEMPLATE = 1;
    public static final int SAND_TEMPLATE = 2;
    public static final int EMPTY_TEMPLATE = 3;
    public static final int FRACTAL_TEMPLATE = 4;

    public TemplateFactory(int n) {
        if (this.templateList == null) {
            this.templateList = new Template[5];
        }
        this.size = n;
    }

    public void initialiseSoilTemplate(float f, float f2, float f3, int n, int n2) {
        this.templateList[0] = new SoilTemplate(f, f2, f3, this.size, n, n2);
    }

    public void initialiseFractalTemplate(float f, float f2, float f3, Template template) {
        this.templateList[4] = new FractalTemplate(f, f2, f3, this.size, template);
    }

    public void initialiseDejectionTemplate(float f, float f2, float f3) {
        this.templateList[1] = new DejectionFractal(f, f2, f3, this.size);
    }

    public void initialiseSandTemplate() {
        this.templateList[2] = new SandTemplate(this.size);
    }

    public void initialiseEmptyTemplate() {
        this.templateList[3] = new EmptyTemplate(this.size);
    }
}

