/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.camisole;

import gama.core.metamodel.agent.IAgent;
import gama.experimental.apsf.spaces.Apsf;
import gama.experimental.apsf.template.SoilTemplate;
import gama.experimental.camisole.GranulometricScale;
import gama.experimental.camisole.InputData;
import java.util.ArrayList;
import umontreal.ssj.randvarmulti.DirichletGen;
import umontreal.ssj.rng.GenF2w32;
import umontreal.ssj.rng.RandomStream;

public class SoilFactory {
    private final ArrayList<InputData> mineralInputs = new ArrayList();
    private final ArrayList<InputData> organicMatterInputs = new ArrayList();
    private final ArrayList<GranulometricScale> scales = new ArrayList();
    private float bulkDensity = 0.0f;
    private double cubeSize;
    private int cubeDividing;
    private static String GENERIC_SCALE_NAME = "C";
    private static DirichletGen[] generators = null;

    public void addMineralGranulometricScale(double d, double d2, double d3) {
        InputData inputData = new InputData(d, d2, d3);
        this.mineralInputs.add(inputData);
    }

    public void addOMGranulometricScale(double d, double d2, double d3) {
        InputData inputData = new InputData(d, d2, d3);
        this.organicMatterInputs.add(inputData);
    }

    private double getLowBoundary() {
        double d = Double.MAX_VALUE;
        for (InputData inputData : this.mineralInputs) {
            d = Math.min(inputData.maxBoundary, d);
        }
        for (InputData inputData : this.mineralInputs) {
            d = Math.min(inputData.maxBoundary, d);
        }
        return d;
    }

    private int countDefaultNumberOfScale(double d, int n) {
        double d2 = this.getLowBoundary();
        int n2 = 0;
        double d3 = d;
        do {
            ++n2;
        } while ((d3 /= (double)n) > d2);
        return n2 + 1;
    }

    private void generateGranulometricScale(int n) {
        double d = this.cubeSize;
        int n2 = 0;
        while (n2 < n) {
            double d2 = n == n2 + 1 ? 0.0 : d / (double)this.cubeDividing;
            GranulometricScale granulometricScale = new GranulometricScale(GENERIC_SCALE_NAME + n2, d2, d, n2);
            this.scales.add(granulometricScale);
            System.out.println("creation de  " + granulometricScale.getName() + " " + d2 + " " + d);
            d = d2;
            ++n2;
        }
    }

    private float sumScaleRates(ArrayList<InputData> arrayList, double d, double d2, double d3) {
        double d4 = 0.0;
        for (InputData inputData : arrayList) {
            d4 += inputData.getValueBetween(d, d2, d3);
        }
        return (float)d4;
    }

    private void compileGranulometricScale(int n) {
        this.generateGranulometricScale(n);
        for (GranulometricScale granulometricScale : this.scales) {
            double d = granulometricScale.getMinBoundary();
            double d2 = granulometricScale.getMaxBoundary() > this.cubeSize ? this.cubeSize : granulometricScale.getMaxBoundary();
            double d3 = Math.pow(this.cubeSize, 3.0) * (double)this.bulkDensity;
            double d4 = Math.pow(this.cubeDividing, granulometricScale.getScale());
            double d5 = (double)this.sumScaleRates(this.mineralInputs, d, d2, d4) * (d3 / 1000.0) / (double)2.62f;
            double d6 = (double)this.sumScaleRates(this.organicMatterInputs, d, d2, d4) * (d3 / 1000.0) * (double)1.72f / (double)0.8f;
            granulometricScale.setVolume((float)d5, (float)d6);
        }
    }

    private DirichletGen[] configureRandomLaw() {
        double[] dArray = new double[this.scales.size()];
        this.scales.size();
        double d = 0.0;
        double d2 = 0.0;
        this.scales.size();
        double[][] dArrayArray = new double[this.scales.size()][];
        int n = 0;
        double d3 = Math.pow(this.cubeSize, 3.0);
        for (GranulometricScale dirichletGenArray2 : this.scales) {
            d += dirichletGenArray2.getOrganicMatterVolume();
            d2 += dirichletGenArray2.getMineralVolume();
            dArray[n] = (dirichletGenArray2.getMineralVolume() + dirichletGenArray2.getOrganicMatterVolume()) / d3;
            System.out.println(" level rate " + dArray[n]);
            ++n;
        }
        n = 0;
        for (GranulometricScale granulometricScale : this.scales) {
            double d4 = granulometricScale.getMineralVolume() + granulometricScale.getOrganicMatterVolume();
            double d5 = granulometricScale.getMineralVolume() / d2;
            double d6 = granulometricScale.getOrganicMatterVolume() / d;
            double d7 = 1.0 - dArray[n];
            dArrayArray[n] = new double[4];
            dArrayArray[n][0] = Math.max(d5, 0.4);
            dArrayArray[n][1] = d7;
            dArrayArray[n][2] = Math.max(d6, 0.4);
            dArrayArray[n][3] = 1.0;
            System.out.println("alpha " + d4 + " " + dArrayArray[n][0] + " " + dArrayArray[n][1] + " " + dArrayArray[n][2] + " " + dArrayArray[n][3]);
            ++n;
        }
        DirichletGen[] dirichletGenArray = new DirichletGen[this.scales.size()];
        n = 0;
        while (n < this.scales.size()) {
            dirichletGenArray[n] = this.configureRandomLaw((float)dArrayArray[n][0], (float)dArrayArray[n][2], (float)dArrayArray[n][1], (float)dArrayArray[n][3]);
            ++n;
        }
        return dirichletGenArray;
    }

    private DirichletGen configureRandomLaw(float f, float f2, float f3, float f4) {
        System.out.println("trr  \t" + f + "\t" + f3 + "\t" + f2 + "\t" + f4);
        double[] dArray = new double[]{f, f3, f2, f4};
        int[] nArray = new int[25];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (int)(Math.random() * 1000.0) + 1;
            ++n;
        }
        GenF2w32 genF2w32 = new GenF2w32();
        genF2w32.setSeed(nArray);
        DirichletGen dirichletGen = new DirichletGen((RandomStream)genF2w32, dArray);
        return dirichletGen;
    }

    private float[][] generateParameter() {
        int n = this.scales.size();
        double[] dArray = new double[]{1.0, 1.0, 1.0, 1.0};
        float[][] fArrayArray = new float[n][];
        int n2 = 0;
        while (n2 < n) {
            DirichletGen dirichletGen = generators[n2];
            dirichletGen.nextPoint(dArray);
            GranulometricScale granulometricScale = this.getGranulometricData(n2);
            fArrayArray[n2] = new float[3];
            if (n2 == 0) {
                fArrayArray[n2][0] = (float)(granulometricScale.getMineralVolume() / Math.pow(this.cubeSize, 3.0));
                fArrayArray[n2][1] = (float)dArray[1];
                fArrayArray[n2][2] = (float)(granulometricScale.getOrganicMatterVolume() / Math.pow(this.cubeSize, 3.0));
            } else {
                fArrayArray[n2][0] = granulometricScale.getMineralVolume() == 0.0 ? 0.0f : (float)dArray[0];
                fArrayArray[n2][1] = (float)dArray[1];
                fArrayArray[n2][2] = granulometricScale.getOrganicMatterVolume() == 0.0 ? 0.0f : (float)dArray[2];
            }
            ++n2;
        }
        return fArrayArray;
    }

    public Apsf generatApsf(float[][] fArray, IAgent iAgent) {
        Apsf apsf = new Apsf(this.cubeSize, this.cubeDividing, iAgent);
        SoilTemplate soilTemplate = null;
        int n = fArray.length - 1;
        while (n >= 0) {
            SoilTemplate soilTemplate2;
            float[] fArray2 = fArray[n];
            soilTemplate = soilTemplate2 = new SoilTemplate(GENERIC_SCALE_NAME + n, fArray2[0], fArray2[1], fArray2[2], this.cubeDividing, 5, 10, soilTemplate);
            --n;
        }
        apsf.defineTemplateTree(soilTemplate);
        return apsf;
    }

    public GranulometricScale getGranulometricData(int n) {
        for (GranulometricScale granulometricScale : this.scales) {
            if (granulometricScale.getScale() != (float)n) continue;
            return granulometricScale;
        }
        return null;
    }

    public float evaluateRMS(Apsf apsf) {
        int n = this.scales.size();
        double d = 0.0;
        double d2 = Math.pow(this.cubeSize, 3.0);
        int n2 = 0;
        while (n2 < n) {
            GranulometricScale granulometricScale = this.getGranulometricData(n2);
            double d3 = apsf.countSandMatterAtSizeScale(n2) * d2;
            double d4 = apsf.countOrganicMatterAtSizeScale(n2) * d2;
            double d5 = granulometricScale.getMineralVolume() - d3;
            double d6 = granulometricScale.getOrganicMatterVolume() - d4;
            d += d5 * d5 + d6 * d6;
            ++n2;
        }
        return (float)Math.sqrt(d);
    }

    private Apsf buildApsf(int n, IAgent iAgent) {
        Object object;
        Object object2 = null;
        float f = Float.MAX_VALUE;
        generators = this.configureRandomLaw();
        int n2 = 0;
        while (n2 < n) {
            float[][] fArray = this.generateParameter();
            object = this.generatApsf(fArray, iAgent);
            float f2 = this.evaluateRMS((Apsf)object);
            if (f2 < f) {
                f = f2;
                object2 = object;
            }
            ++n2;
        }
        n2 = this.scales.size();
        int n3 = 0;
        while (n3 < n2) {
            object = this.getGranulometricData(n3);
            System.out.println("solid delta\t" + n3 + "\t\t" + ((GranulometricScale)object).getMineralVolume() + "\t\t" + ((Apsf)object2).countSandMatterAtSizeScale(n3) * 20.0 * 20.0 * 20.0);
            System.out.println("oM delta\t" + n3 + "\t\t" + ((GranulometricScale)object).getOrganicMatterVolume() + "\t\t" + ((Apsf)object2).countOrganicMatterAtSizeScale(n3) * 20.0 * 20.0 * 20.0);
            ++n3;
        }
        System.out.println("bstRMSE " + f + "  " + ((Apsf)object2).getAPSF().getTemplate().getOrganicMatterTotalVolumicMass(0, (Apsf)object2));
        double d = ((Apsf)object2).countTotalOrganicMatter() * Math.pow(this.cubeSize, 3.0) * (double)0.8f;
        double d2 = ((Apsf)object2).countTotalSandMatter() * Math.pow(this.cubeSize, 3.0) * (double)2.62f;
        double d3 = d + d2;
        System.out.println("total om " + d);
        System.out.println("total mineral " + d2);
        System.out.println("total Soil " + d3 + " " + d3 / Math.pow(this.cubeSize, 3.0));
        ((Apsf)object2).getAPSF().initMatters(d, d2);
        return object2;
    }

    public Apsf compileAndBuild() {
        return this.compileAndBuild(1.38f, 20.0, 10, 20, null);
    }

    public Apsf compileAndBuild(float f, double d, int n, int n2, IAgent iAgent) {
        this.bulkDensity = f;
        this.cubeSize = d;
        this.cubeDividing = n;
        int n3 = this.countDefaultNumberOfScale(d, n);
        this.compileGranulometricScale(n3);
        return this.buildApsf(n2, iAgent);
    }
}

