/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.camisole.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.experimental.apsf.spaces.Agglomerate;
import gama.experimental.apsf.spaces.Apsf;
import gama.experimental.apsf.spaces.Particle;
import gama.experimental.apsf.template.Template;
import gama.experimental.camisole.InputData;
import gama.experimental.camisole.SoilFactory;
import gama.gaml.skills.Skill;
import gama.gaml.species.GamlSpecies;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="apsf", type=0, doc={@GamlAnnotations.doc(value="Contains the virtual soil")}), @GamlAnnotations.variable(name="apsf_factory", type=0, doc={@GamlAnnotations.doc(value="Contains the virtual soil")}), @GamlAnnotations.variable(name="DEVELOPPED_TEMPLATE", type=10, doc={@GamlAnnotations.doc(value="Contains the virtual soil")}), @GamlAnnotations.variable(name="dividing_factor", type=1, doc={@GamlAnnotations.doc(value="soil dividing")}), @GamlAnnotations.variable(name="size", type=2, doc={@GamlAnnotations.doc(value="size of the soil in m")}), @GamlAnnotations.variable(name="sub_model", type=5, doc={@GamlAnnotations.doc(value="models")})})
@GamlAnnotations.skill(name="camisole", concept={"skill"})
public class ApsfSkill
extends Skill {
    private Apsf getAPSFSoil(IAgent iAgent) {
        Apsf apsf = (Apsf)iAgent.getAttribute("apsf");
        return apsf;
    }

    private Map<Template, Agglomerate> getDeveloppedTemplate(IAgent iAgent) {
        HashMap hashMap = (HashMap)iAgent.getAttribute("DEVELOPPED_TEMPLATE");
        if (hashMap == null) {
            hashMap = new HashMap();
            iAgent.setAttribute("DEVELOPPED_TEMPLATE", hashMap);
        }
        return hashMap;
    }

    private SoilFactory getAPSFSoilFactory(IAgent iAgent) {
        SoilFactory soilFactory = (SoilFactory)iAgent.getAttribute("apsf_factory");
        if (soilFactory == null) {
            soilFactory = new SoilFactory();
            iAgent.setAttribute("apsf_factory", (Object)soilFactory);
        }
        return soilFactory;
    }

    public ArrayList<InputData> getOrganicInputlist(IAgent iAgent) {
        ArrayList arrayList = (ArrayList)iAgent.getAttribute("granulometry_om");
        if (arrayList == null) {
            arrayList = new ArrayList();
            iAgent.setAttribute("granulometry_om", arrayList);
        }
        return arrayList;
    }

    @GamlAnnotations.action(name="granulometry", args={@GamlAnnotations.arg(name="mineral_matter", type=2, optional=true, doc={@GamlAnnotations.doc(value="quantity of minerals")}), @GamlAnnotations.arg(name="organic_matter", type=2, optional=true, doc={@GamlAnnotations.doc(value="quantity of organic matter")}), @GamlAnnotations.arg(name="max", type=2, optional=true, doc={@GamlAnnotations.doc(value="max boundary")}), @GamlAnnotations.arg(name="min", type=2, optional=true, doc={@GamlAnnotations.doc(value="min boundary")}), @GamlAnnotations.arg(name="boundary", type=2, optional=true, doc={@GamlAnnotations.doc(value="boundary of granulometric data")})}, doc={@GamlAnnotations.doc(value="", returns="", examples={@GamlAnnotations.example(value="")})})
    public void defineGranulometricData(IScope iScope) {
        SoilFactory soilFactory;
        IAgent iAgent = iScope.getAgent();
        Object object = iScope.getArg("mineral_matter", 2);
        Object object2 = iScope.getArg("organic_matter", 2);
        Object object3 = iScope.getArg("max", 2);
        Object object4 = iScope.getArg("min", 2);
        Object object5 = iScope.getArg("boundary", 5);
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        if (object4 != null && (Double)object4 != 0.0) {
            d = Math.max(d, (Double)object4 * 100.0);
        }
        if (object3 != null && (Double)object3 != 0.0) {
            d2 = Math.min(d2, (Double)object3 * 100.0);
        }
        if (object5 != null && ((IList)object5).size() >= 2) {
            soilFactory = (IList)object5;
            double d3 = ((Double)soilFactory.get(0)).floatValue();
            double d4 = ((Double)soilFactory.get(1)).floatValue();
            d = Math.min(d, d3);
            d2 = Math.min(d2, d4);
        }
        soilFactory = this.getAPSFSoilFactory(iAgent);
        if (object != null && (Double)object != 0.0) {
            float f = ((Double)object).floatValue() * 1000.0f;
            soilFactory.addMineralGranulometricScale(f, d, d2);
            System.out.println("mineral\t" + f + "\tmin:" + d + "\tmax:" + d2);
        }
        if (object2 != null && ((Double)object2).floatValue() != 0.0f) {
            float f = ((Double)object2).floatValue() * 1000.0f;
            soilFactory.addOMGranulometricScale(f, d, d2);
            System.out.println("organic\t" + f + "\tmin:" + d + "\tmax:" + d2);
        }
    }

    @GamlAnnotations.action(name="initialize_soil", args={@GamlAnnotations.arg(name="size", type=2, optional=false, doc={@GamlAnnotations.doc(value="width of the cube")}), @GamlAnnotations.arg(name="dividing_factor", type=1, optional=false, doc={@GamlAnnotations.doc(value="soil spliting factor")}), @GamlAnnotations.arg(name="default_species", type=14, optional=false, doc={@GamlAnnotations.doc(value="default particle species")}), @GamlAnnotations.arg(name="number_of_try", type=1, optional=false, doc={@GamlAnnotations.doc(value="number of try")}), @GamlAnnotations.arg(name="bulk_density", type=2, optional=false, doc={@GamlAnnotations.doc(value="max boundary")})}, doc={@GamlAnnotations.doc(value="", returns="", examples={@GamlAnnotations.example(value="")})})
    public void configureAndBuild(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        Object object = iScope.getArg("size", 2);
        GamlSpecies gamlSpecies = (GamlSpecies)iScope.getArg("default_species", 14);
        Object object2 = iScope.getArg("dividing_factor", 1);
        Object object3 = iScope.getArg("bulk_density", 2);
        Object object4 = iScope.getArg("number_of_try", 1);
        double d = object == null ? 20.0 : (Double)object * 100.0;
        int n = object2 == null ? 10 : (Integer)object2;
        float f = object3 == null ? 20.0f : ((Double)object3).floatValue();
        int n2 = object4 == null || (Integer)object4 == 0 ? 20000 : (Integer)object4;
        SoilFactory soilFactory = this.getAPSFSoilFactory(iAgent);
        Apsf apsf = soilFactory.compileAndBuild(f, d, n, n2, iAgent);
        iAgent.setAttribute("apsf", (Object)apsf);
        apsf.setDefaultSpecies(gamlSpecies);
    }

    @GamlAnnotations.action(name="list_template", args={}, doc={@GamlAnnotations.doc(value="", returns="", examples={@GamlAnnotations.example(value="")})})
    public IList<String> getCreatedTemplate(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        Apsf apsf = (Apsf)iAgent.getAttribute("apsf");
        IList iList = GamaListFactory.create();
        for (Template template : apsf.getAPSF().getTemplate().getAllSubTemplate()) {
            iList.add((Object)template.getTemplateName());
        }
        return iList;
    }

    public static String userToApsf(String string) {
        if (string.equalsIgnoreCase("pore")) {
            return "white_particle";
        }
        if (string.equalsIgnoreCase("organic")) {
            return "green_particle";
        }
        if (string.equalsIgnoreCase("mineral")) {
            return "black_particle";
        }
        return string;
    }

    public static String apsfToUser(Particle particle) {
        if (particle.getTemplateName().equalsIgnoreCase("white_particle")) {
            return "pore";
        }
        if (particle.getTemplateName().equalsIgnoreCase("green_particle")) {
            return "organic";
        }
        if (particle.getTemplateName().equalsIgnoreCase("black_particle")) {
            return "mineral";
        }
        return particle.getTemplateName();
    }

    @GamlAnnotations.action(name="associate", args={@GamlAnnotations.arg(name="from_canvas", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the template")}), @GamlAnnotations.arg(name="at_scale", type=1, optional=false, doc={@GamlAnnotations.doc(value="name of the template")}), @GamlAnnotations.arg(name="with_process", type=14, optional=false, doc={@GamlAnnotations.doc(value="name of the process species")}), @GamlAnnotations.arg(name="particle", type=4, optional=false, doc={@GamlAnnotations.doc(value="porous, sand, organic")})}, doc={@GamlAnnotations.doc(value="", returns="", examples={@GamlAnnotations.example(value="")})})
    public void associateSpeciesToTemplate(IScope iScope) {
        Apsf apsf;
        ArrayList<Template> arrayList;
        IAgent iAgent = iScope.getAgent();
        String string = (String)iScope.getArg("from_canvas", 4);
        int n = (Integer)iScope.getArg("at_scale", 1);
        GamlSpecies gamlSpecies = (GamlSpecies)iScope.getArg("with_process", 14);
        String string2 = (String)iScope.getArg("particle", 4);
        ArrayList<Object[]> arrayList2 = (ArrayList<Object[]>)iAgent.getAttribute("sub_model");
        if (arrayList2 == null) {
            arrayList2 = new ArrayList<Object[]>();
            iAgent.setAttribute("sub_model", arrayList2);
        }
        if (!this.containsTemplate(arrayList = (apsf = this.getAPSFSoil(iAgent)).getAPSF().getTemplate().getAllSubTemplate(), string)) {
            return;
        }
        Template template = apsf.getTemplateWithName(string);
        template.addProcess(gamlSpecies, ApsfSkill.userToApsf(string2), n);
        Object[] objectArray = new Object[]{gamlSpecies, template, string2, new Integer(n)};
        arrayList2.add(objectArray);
    }

    @GamlAnnotations.action(name="apply_processes")
    public void initializeProcesses(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        Apsf apsf = this.getAPSFSoil(iAgent);
        Map<Template, Agglomerate> map = this.getDeveloppedTemplate(iAgent);
        List list = (List)iAgent.getAttribute("sub_model");
        for (Object[] objectArray : list) {
            Agglomerate agglomerate = map.get(objectArray[1]);
            Particle particle = apsf.getOneParticleWithCharacteristics(iScope, (Template)objectArray[1], (Integer)objectArray[3], ApsfSkill.userToApsf((String)objectArray[2]), true);
            agglomerate = particle.getParent();
            map.put((Template)objectArray[1], agglomerate);
            agglomerate.deploySubParticles(iScope);
        }
    }

    private boolean containsTemplate(ArrayList<Template> arrayList, String string) {
        string = string.toUpperCase();
        for (Template template : arrayList) {
            if (!template.getTemplateName().toUpperCase().equals(string)) continue;
            return true;
        }
        return string.equals("mineral".toUpperCase()) || string.equals("organic".toUpperCase()) || string.equals("pore".toUpperCase());
    }
}

