/*
 * Decompiled with CFR 0.152.
 */
package core.configuration.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import core.configuration.GenstarConfigurationFile;
import core.configuration.dictionary.IGenstarDictionary;
import core.metamodel.attribute.Attribute;
import core.metamodel.io.GSSurveyType;
import core.metamodel.io.GSSurveyWrapper;
import core.metamodel.value.IValue;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenstarConfigurationFileDeserializer
extends StdDeserializer<GenstarConfigurationFile> {
    private static final long serialVersionUID = 1L;

    protected GenstarConfigurationFileDeserializer() {
        this(null);
    }

    public GenstarConfigurationFileDeserializer(Class<GenstarConfigurationFile> clazz) {
        super(clazz);
    }

    public GenstarConfigurationFile deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        GenstarConfigurationFile genstarConfigurationFile = new GenstarConfigurationFile();
        ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
        JsonNode jsonNode = (JsonNode)objectMapper.readTree(jsonParser);
        JsonNode jsonNode2 = jsonNode.get("CONFIGURATION FILE");
        genstarConfigurationFile.setBaseDirectory(Paths.get(jsonNode2.get("MAIN DIRECTORY").asText(), new String[0]));
        genstarConfigurationFile.setWrappers(this.getWrappers(jsonNode2.get("INPUT FILES"), deserializationContext));
        genstarConfigurationFile.setDictionaries(this.getDictionaries(jsonNode2.get("DICTIONARIES"), jsonParser));
        return genstarConfigurationFile;
    }

    private Set<IGenstarDictionary<Attribute<? extends IValue>>> getDictionaries(JsonNode jsonNode, JsonParser jsonParser) throws IOException {
        HashSet<IGenstarDictionary<Attribute<? extends IValue>>> hashSet = new HashSet<IGenstarDictionary<Attribute<? extends IValue>>>();
        int n = -1;
        while (jsonNode.has(++n)) {
            hashSet.add((IGenstarDictionary)jsonNode.get(n).traverse(jsonParser.getCodec()).readValueAs(IGenstarDictionary.class));
        }
        return hashSet;
    }

    private Map<GSSurveyWrapper, List<Integer>> getWrappers(JsonNode jsonNode, DeserializationContext deserializationContext) throws IOException {
        HashMap<GSSurveyWrapper, List<Integer>> hashMap = new HashMap<GSSurveyWrapper, List<Integer>>();
        if (!jsonNode.isArray()) {
            throw new IllegalArgumentException("INPUT FILES tag is not parsed correctly: " + jsonNode.toString());
        }
        int n = -1;
        while (jsonNode.has(++n)) {
            String string2 = jsonNode.get(n++).asText().replace("LAYER LEVEL", "").split(" : ")[1].trim();
            List<Integer> list = Arrays.asList(string2.split(";")).stream().map(string -> Integer.valueOf(string.trim())).toList();
            JsonNode jsonNode2 = jsonNode.get(n);
            GSSurveyWrapper gSSurveyWrapper = new GSSurveyWrapper(Paths.get(jsonNode2.get("RELATIVE PATH").asText(), new String[0]), GSSurveyType.valueOf(jsonNode2.get("SURVEY TYPE").asText()));
            gSSurveyWrapper.setCsvSeparator(jsonNode2.get("SEPARATOR").asText().toCharArray()[0]);
            gSSurveyWrapper.setFirstRowIndex(jsonNode2.get("FRI").asInt());
            gSSurveyWrapper.setFirstColumnIndex(jsonNode2.get("FCI").asInt());
            gSSurveyWrapper.setSheetNumber(jsonNode2.get("SHEET NB").asInt());
            gSSurveyWrapper.setStoredInMemory(jsonNode2.get("STORE DATA").asBoolean());
            hashMap.put(gSSurveyWrapper, list);
        }
        return hashMap;
    }
}

