/*
 * Decompiled with CFR 0.152.
 */
package core.configuration.jackson.attribute;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import core.metamodel.attribute.mapper.IAttributeMapper;
import core.metamodel.value.IValue;
import core.util.data.GSEnumDataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class AttributeMapperSerializer
extends StdSerializer<IAttributeMapper<? extends IValue, ? extends IValue>> {
    private static final long serialVersionUID = 1L;

    protected AttributeMapperSerializer() {
        this(null);
    }

    protected AttributeMapperSerializer(Class<IAttributeMapper<? extends IValue, ? extends IValue>> clazz) {
        super(clazz);
    }

    public void serialize(IAttributeMapper<? extends IValue, ? extends IValue> iAttributeMapper, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
    }

    public void serializeWithType(IAttributeMapper<? extends IValue, ? extends IValue> iAttributeMapper, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        GSEnumDataType gSEnumDataType = iAttributeMapper.getRelatedAttribute().getValueSpace().getType();
        List<String> list = null;
        list = gSEnumDataType.equals((Object)GSEnumDataType.Order) ? this.getOrderedMapperEntries(iAttributeMapper) : this.getMapperEntries(iAttributeMapper);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(typeSerializer.getPropertyName(), typeSerializer.getTypeIdResolver().idFromValue(iAttributeMapper));
        jsonGenerator.writeArrayFieldStart("THE MAP");
        for (String string : list) {
            jsonGenerator.writeString(string);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }

    private List<String> getMapperEntries(IAttributeMapper<? extends IValue, ? extends IValue> iAttributeMapper) {
        return iAttributeMapper.getRawMapper().entrySet().stream().map(entry -> this.getStringValues((Collection)entry.getKey()) + " : " + this.getStringValues((Collection)entry.getValue())).toList();
    }

    private List<String> getOrderedMapperEntries(IAttributeMapper<? extends IValue, ? extends IValue> iAttributeMapper) {
        ArrayList arrayList = new ArrayList();
        iAttributeMapper.getRelatedAttribute().getValueSpace().getValues().iterator().forEachRemaining(arrayList::add);
        return iAttributeMapper.getRawMapper().entrySet().stream().map(entry -> this.getStringValues(arrayList.stream().filter(iValue -> ((Collection)entry.getKey()).contains(iValue)).toList()) + " : " + this.getStringValues((Collection)entry.getValue())).toList();
    }

    private String getStringValues(Collection<? extends IValue> collection) {
        if (collection.isEmpty()) {
            return "";
        }
        if (collection.size() == 1) {
            return collection.iterator().next().getStringValue();
        }
        return collection.stream().map(IValue::getStringValue).collect(Collectors.joining(";"));
    }
}

