/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import core.metamodel.attribute.IAttribute;
import core.metamodel.attribute.mapper.value.EncodedValueMapper;
import core.metamodel.value.IValue;
import core.metamodel.value.IValueSpace;
import java.util.Collection;
import java.util.Collections;

@JsonTypeName(value="ATTRIBUTE")
public class Attribute<V extends IValue>
implements IAttribute<V> {
    public static final String SELF = "ATTRIBUTE";
    private IValueSpace<V> valueSpace;
    private EncodedValueMapper<V> encodedValues;
    private final String name;
    @JsonIgnore
    private String description = null;

    protected Attribute(String string) {
        this.name = string;
    }

    @Override
    public final String getAttributeName() {
        return this.name;
    }

    @Override
    public IValueSpace<V> getValueSpace() {
        return this.valueSpace;
    }

    @Override
    public void setValueSpace(IValueSpace<V> iValueSpace) {
        this.valueSpace = iValueSpace;
    }

    @Override
    public EncodedValueMapper<V> getEncodedValueMapper() {
        return this.encodedValues;
    }

    @Override
    public void setEncodedValueMapper(EncodedValueMapper<V> encodedValueMapper) {
        this.encodedValues = encodedValueMapper;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void addRecords(String string, String ... stringArray) {
        if (this.encodedValues == null) {
            this.setEncodedValueMapper(new EncodedValueMapper<V>(this.valueSpace));
        }
        this.encodedValues.putMapping(string, stringArray);
    }

    @JsonIgnore
    public Attribute<? extends IValue> getReferentAttribute() {
        return this;
    }

    public boolean isLinked(Attribute<? extends IValue> attribute) {
        return this.equals(attribute) || this.equals(attribute.getReferentAttribute()) || this.getReferentAttribute().equals(attribute) || this.getReferentAttribute().equals(attribute.getReferentAttribute());
    }

    @JsonIgnore
    public IValue getEmptyValue() {
        return this.valueSpace.getEmptyValue();
    }

    public Collection<? extends IValue> findMappedAttributeValues(IValue iValue) {
        if (this.getValueSpace().contains(iValue) || this.getValueSpace().isValidCandidate(iValue.getStringValue())) {
            return Collections.singleton(iValue);
        }
        if (this.encodedValues.getRecords().contains(iValue)) {
            return Collections.singleton(this.encodedValues.getRelatedValue(iValue));
        }
        throw new NullPointerException();
    }

    public boolean isEmergent() {
        return false;
    }

    public String toString() {
        return this.name + " (" + String.valueOf((Object)this.getValueSpace().getType()) + ")";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.description == null ? 0 : this.description.hashCode());
        return 31 * n + this.getHashCode();
    }

    public boolean equals(Object object) {
        return this.isEqual(object);
    }
}

