/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.mapper.IAttributeMapper;
import core.metamodel.value.IValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

@JsonTypeName(value="MAPPED ATTRIBUTE")
public class MappedAttribute<K extends IValue, V extends IValue>
extends Attribute<K> {
    public static final String SELF = "MAPPED ATTRIBUTE";
    public static final String REF = "REFERENT ATTRIBUTE";
    public static final String MAP = "MAPPER";
    @JsonProperty(value="REFERENT ATTRIBUTE")
    private Attribute<V> referentAttribute;
    private IAttributeMapper<K, V> attributeMapper;

    protected MappedAttribute(String string, Attribute<V> attribute, IAttributeMapper<K, V> iAttributeMapper) {
        super(string);
        this.referentAttribute = attribute;
        this.attributeMapper = iAttributeMapper;
    }

    @Override
    public boolean isLinked(Attribute<? extends IValue> attribute) {
        return attribute.equals(this.referentAttribute);
    }

    @Override
    public Attribute<V> getReferentAttribute() {
        return this.referentAttribute;
    }

    protected void setReferentAttribute(Attribute<V> attribute) {
        this.referentAttribute = attribute;
    }

    @Override
    public Collection<? extends IValue> findMappedAttributeValues(IValue iValue) {
        try {
            return this.attributeMapper.getMappedValues(iValue);
        }
        catch (NullPointerException nullPointerException) {
            Object object;
            if (iValue == null) {
                throw nullPointerException;
            }
            if (this.getEncodedValueMapper() != null && this.getEncodedValueMapper().hasValueOrRecord(iValue.getStringValue())) {
                object = this.getEncodedValueMapper().getRelatedValue(iValue.getStringValue());
                try {
                    return this.attributeMapper.getMappedValues((IValue)object);
                }
                catch (NullPointerException nullPointerException2) {}
            }
            if (this.referentAttribute.getEncodedValueMapper() != null && this.referentAttribute.getEncodedValueMapper().hasValueOrRecord(iValue.getStringValue())) {
                object = this.referentAttribute.getEncodedValueMapper().transpose(iValue);
                try {
                    return this.attributeMapper.getMappedValues((IValue)object);
                }
                catch (NullPointerException nullPointerException3) {}
            }
            if (this.getReferentAttribute().getValueSpace().contains(iValue)) {
                return Arrays.asList(this.getEmptyValue());
            }
            if (this.getValueSpace().contains(iValue)) {
                return Arrays.asList(this.getReferentAttribute().getEmptyValue());
            }
            if (this.getEmptyValue().equals(iValue) || this.getReferentAttribute().getValueSpace().getEmptyValue().equals(iValue)) {
                return Arrays.asList(iValue);
            }
            throw nullPointerException;
        }
    }

    @JsonProperty(value="MAPPER")
    public IAttributeMapper<K, V> getAttributeMapper() {
        return this.attributeMapper;
    }

    public boolean addMappedValue(K k, V v) {
        return this.attributeMapper.add(k, v);
    }

    public Collection<K> getKey(V v) {
        Optional<Collection> optional = this.attributeMapper.getRawMapper().entrySet().stream().filter(entry -> ((Collection)entry.getValue()).contains(v)).map(entry -> (Collection)entry.getKey()).findAny();
        return optional.isPresent() ? optional.get() : Collections.emptyList();
    }

    public Collection<V> getValue(K k) {
        Optional<Collection> optional = this.attributeMapper.getRawMapper().entrySet().stream().filter(entry -> ((Collection)entry.getKey()).contains(k)).map(entry -> (Collection)entry.getValue()).findAny();
        return optional.isPresent() ? optional.get() : Collections.emptyList();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.attributeMapper == null ? 0 : this.attributeMapper.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.isEqual(object)) {
            return false;
        }
        MappedAttribute mappedAttribute = (MappedAttribute)object;
        return !(this.attributeMapper == null ? mappedAttribute.attributeMapper != null : !this.attributeMapper.equals(mappedAttribute.attributeMapper));
    }
}

