/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute.emergent.aggregator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import core.metamodel.attribute.emergent.aggregator.IAggregatorValueFunction;
import core.metamodel.value.IValueSpace;
import core.metamodel.value.binary.BooleanValue;
import java.util.Collection;

@JsonTypeName(value="DEFAULT - BOOL AGGREGATOR")
public class BooleanValueAggregator
implements IAggregatorValueFunction<BooleanValue> {
    public static final String SELF = "DEFAULT - BOOL AGGREGATOR";
    private static final BooleanValueAggregator INSTANCE = new BooleanValueAggregator();
    private BooleanAggregationStyle boolAgg = BooleanAggregationStyle.getDefault();

    private BooleanValueAggregator() {
    }

    @JsonCreator
    public static BooleanValueAggregator getInstance() {
        return INSTANCE;
    }

    public void setBoolAggregatorStyle(BooleanAggregationStyle booleanAggregationStyle) {
        this.boolAgg = booleanAggregationStyle;
    }

    @Override
    public BooleanValue aggregate(Collection<BooleanValue> collection, IValueSpace<BooleanValue> iValueSpace) {
        switch (this.boolAgg) {
            case MOST: {
                return iValueSpace.getValue(Boolean.toString((double)collection.stream().filter(booleanValue -> booleanValue.getActualValue()).count() >= (double)collection.size() / 2.0));
            }
            case ATLEASTONE: {
                return iValueSpace.getValue(Boolean.toString(collection.stream().anyMatch(booleanValue -> booleanValue.getActualValue())));
            }
        }
        return iValueSpace.getValue(Boolean.toString(collection.stream().anyMatch(booleanValue -> booleanValue.getActualValue().equals(Boolean.FALSE))));
    }

    @Override
    public String getType() {
        return SELF;
    }

    public static enum BooleanAggregationStyle {
        MOST,
        ALL,
        ATLEASTONE;


        public static BooleanAggregationStyle getDefault() {
            return ALL;
        }
    }
}

