/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute.emergent.aggregator;

import com.fasterxml.jackson.annotation.JsonTypeName;
import core.metamodel.attribute.emergent.aggregator.IAggregatorValueFunction;
import core.metamodel.value.IValueSpace;
import core.metamodel.value.categoric.OrderedSpace;
import core.metamodel.value.categoric.OrderedValue;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;

@JsonTypeName(value="DEFAULT - ORDERED VALUE AGGREGATOR")
public class OrderedValueAggregator
implements IAggregatorValueFunction<OrderedValue> {
    public static final String SELF = "DEFAULT - ORDERED VALUE AGGREGATOR";
    private static final OrderedValueAggregator INSTANCE = new OrderedValueAggregator();

    private OrderedValueAggregator() {
    }

    public static OrderedValueAggregator getInstance() {
        return INSTANCE;
    }

    @Override
    public OrderedValue aggregate(Collection<OrderedValue> collection, IValueSpace<OrderedValue> iValueSpace) {
        return ((OrderedSpace)iValueSpace).addValue(this.getAggregate(collection), collection.stream().map(orderedValue -> orderedValue.getStringValue()).collect(Collectors.joining(this.getDefaultCharConcat())));
    }

    @Override
    public String getType() {
        return SELF;
    }

    private double getAggregate(Collection<OrderedValue> collection) {
        double d = collection.stream().mapToDouble(orderedValue -> orderedValue.getOrder().doubleValue()).sum() / (double)collection.size();
        return Math.floor(d) + (d - Math.floor(d) + Double.valueOf("0." + collection.stream().map(orderedValue -> (int)Math.round(orderedValue.getOrder().doubleValue())).sorted(new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return n > n2 ? -1 : (n < n2 ? 1 : 0);
            }
        }).map(n -> n.toString()).collect(Collectors.joining())));
    }
}

