/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute.emergent.aggregator;

import com.fasterxml.jackson.annotation.JsonTypeName;
import core.metamodel.attribute.emergent.aggregator.IAggregatorValueFunction;
import core.metamodel.value.IValueSpace;
import core.metamodel.value.numeric.RangeSpace;
import core.metamodel.value.numeric.RangeValue;
import java.util.Collection;

@JsonTypeName(value="DEFAULT - RANGE AGGREGATOR")
public class RangeValueAggregator
implements IAggregatorValueFunction<RangeValue> {
    public static final String SELF = "DEFAULT - RANGE AGGREGATOR";
    private static final RangeValueAggregator INSTANCE = new RangeValueAggregator();

    private RangeValueAggregator() {
    }

    public static RangeValueAggregator getInstance() {
        return INSTANCE;
    }

    @Override
    public RangeValue aggregate(Collection<RangeValue> collection, IValueSpace<RangeValue> iValueSpace) {
        Number number3 = collection.stream().map(rangeValue -> rangeValue.getBottomBound()).reduce(0, (number, number2) -> this.add((Number)number, (Number)number2));
        Number number4 = collection.stream().map(rangeValue -> rangeValue.getTopBound()).reduce(0, (number, number2) -> this.add((Number)number, (Number)number2));
        return iValueSpace.getInstanceValue(((RangeSpace)iValueSpace).getRangeTemplate().getMiddleTemplate(number3, number4));
    }

    private Number add(Number number, Number number2) {
        if (number.getClass().equals(Integer.class) && number2.getClass().equals(Integer.class)) {
            return number.intValue() + number2.intValue();
        }
        return number.doubleValue() + number2.doubleValue();
    }

    @Override
    public String getType() {
        return SELF;
    }
}

