/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.entity.comparator;

import com.fasterxml.jackson.annotation.JsonProperty;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.IAttribute;
import core.metamodel.entity.IEntity;
import core.metamodel.entity.comparator.ImplicitEntityComparator;
import core.metamodel.entity.matcher.AttributeVectorMatcher;
import core.metamodel.value.IValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HammingEntityComparator
extends ImplicitEntityComparator {
    public static final String SELF = "HAMMING ENTITY COMPARATOR";
    public static final String HAMMING_VECTOR = "HAMMING VECTOR MATCHER";
    @JsonProperty(value="HAMMING VECTOR MATCHER")
    private AttributeVectorMatcher vector;

    public HammingEntityComparator(IEntity<Attribute<? extends IValue>> iEntity) {
        super(new ArrayList<IAttribute<? extends IValue>>(iEntity.getAttributes()));
        this.vector = new AttributeVectorMatcher(iEntity);
    }

    public HammingEntityComparator(Map<IAttribute<? extends IValue>, Set<IValue>> map) {
        super(new ArrayList<IAttribute<? extends IValue>>(map.keySet()));
        this.vector = new AttributeVectorMatcher(map);
    }

    public HammingEntityComparator(IValue ... iValueArray) {
        super(new ArrayList<IAttribute<? extends IValue>>(Arrays.asList(iValueArray).stream().map(iValue -> iValue.getValueSpace().getAttribute()).collect(Collectors.toSet())));
        this.vector = new AttributeVectorMatcher();
        this.vector.addMatchToVector(iValueArray);
    }

    @JsonProperty(value="HAMMING VECTOR MATCHER")
    public AttributeVectorMatcher getVectorMatcher() {
        return this.vector;
    }

    @JsonProperty(value="HAMMING VECTOR MATCHER")
    public void setVectorMatcher(AttributeVectorMatcher attributeVectorMatcher) {
        this.vector = attributeVectorMatcher;
    }

    @Override
    public int compare(IEntity<? extends IAttribute<? extends IValue>> iEntity, IEntity<? extends IAttribute<? extends IValue>> iEntity2) {
        int n = 0;
        int n2 = 0;
        if (this.vector != null) {
            n = this.vector.getHammingDistance(iEntity);
            n2 = this.vector.getHammingDistance(iEntity2);
        }
        return n > n2 ? -1 : (n < n2 ? 1 : super.compare(iEntity, iEntity2));
    }
}

