/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.entity.matcher;

import com.fasterxml.jackson.annotation.JsonTypeName;
import core.metamodel.attribute.IAttribute;
import core.metamodel.entity.IEntity;
import core.metamodel.entity.matcher.IGSEntityMatcher;
import core.metamodel.entity.matcher.MatchType;
import core.metamodel.entity.tag.EntityTag;
import core.metamodel.value.IValue;
import core.util.GSDisplayUtil;
import core.util.exception.GenstarException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

@JsonTypeName(value="TAG MATCHER")
public class TagMatcher
implements IGSEntityMatcher<EntityTag> {
    public static final String SELF = "TAG MATCHER";
    Collection<EntityTag> tags = new HashSet<EntityTag>();

    public TagMatcher() {
    }

    public TagMatcher(EntityTag ... entityTagArray) {
        this();
        this.addMatchToVector(entityTagArray);
    }

    @Override
    public boolean valueMatch(EntityTag entityTag) {
        return this.tags.contains((Object)entityTag);
    }

    @Override
    public boolean valuesMatch(Collection<? extends EntityTag> collection) {
        return this.tags.containsAll(collection);
    }

    @Override
    public boolean entityMatch(IEntity<? extends IAttribute<? extends IValue>> iEntity, MatchType matchType) {
        return switch (matchType) {
            case MatchType.ALL -> this.valuesMatch((Collection<? extends EntityTag>)iEntity.getTags());
            case MatchType.ANY -> iEntity.getTags().stream().anyMatch(this::valueMatch);
            case MatchType.NONE -> iEntity.getTags().stream().noneMatch(this::valueMatch);
            default -> throw new GenstarException();
        };
    }

    @Override
    public int getHammingDistance(IEntity<? extends IAttribute<? extends IValue>> iEntity) {
        return (int)this.tags.stream().filter(entityTag -> iEntity.hasTags((EntityTag)((Object)entityTag))).count();
    }

    public void addMatchToVector(EntityTag ... entityTagArray) {
        this.tags.addAll(Arrays.asList(entityTagArray));
    }

    public String toString() {
        return GSDisplayUtil.prettyPrint(this.tags, ";");
    }

    @Override
    public void setVector(Collection<EntityTag> collection) {
        this.tags = collection;
    }

    @Override
    public Collection<EntityTag> getVector() {
        return Collections.unmodifiableCollection(this.tags);
    }
}

