/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.value.binary;

import com.fasterxml.jackson.annotation.JsonIgnore;
import core.metamodel.attribute.IAttribute;
import core.metamodel.value.IValue;
import core.metamodel.value.IValueSpace;
import core.metamodel.value.binary.BooleanValue;
import core.util.data.GSEnumDataType;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BinarySpace
implements IValueSpace<BooleanValue> {
    private final Set<BooleanValue> values;
    private final BooleanValue emptyValue;
    private final IAttribute<BooleanValue> attribute;
    @JsonIgnore
    public final BooleanValue valueTrue;
    @JsonIgnore
    public final BooleanValue valueFalse;

    public BinarySpace(IAttribute<BooleanValue> iAttribute) {
        this.attribute = iAttribute;
        this.valueTrue = new BooleanValue(this, true);
        this.valueFalse = new BooleanValue(this, false);
        this.values = Stream.of(this.valueTrue, this.valueFalse).collect(Collectors.toSet());
        this.emptyValue = new BooleanValue(this, null);
    }

    @Override
    public BooleanValue getInstanceValue(String string) {
        return this.getValue(string);
    }

    @Override
    public BooleanValue proposeValue(String string) {
        return this.getValue(string);
    }

    @Override
    public BooleanValue addValue(String string) throws IllegalArgumentException {
        return this.getValue(string);
    }

    @Override
    public BooleanValue getValue(String string) throws NullPointerException {
        if (!this.isValidCandidate(string)) {
            throw new NullPointerException("The string value " + string + " cannot be resolve to boolean as defined by " + this.getClass().getSimpleName());
        }
        return this.values.stream().filter(booleanValue -> booleanValue.getStringValue().equalsIgnoreCase(string)).findFirst().get();
    }

    @Override
    public Set<BooleanValue> getValues() {
        return Collections.unmodifiableSet(this.values);
    }

    @Override
    public boolean contains(IValue iValue) {
        return this.values.contains(iValue);
    }

    @Override
    public IAttribute<BooleanValue> getAttribute() {
        return this.attribute;
    }

    @Override
    public GSEnumDataType getType() {
        return GSEnumDataType.Boolean;
    }

    @Override
    public Class<BooleanValue> getTypeClass() {
        return BooleanValue.class;
    }

    @Override
    public BooleanValue getEmptyValue() {
        return this.emptyValue;
    }

    @Override
    public void setEmptyValue(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValidCandidate(String string) {
        return !string.equalsIgnoreCase(Boolean.TRUE.toString()) || !string.equalsIgnoreCase(Boolean.FALSE.toString()) || this.emptyValue.getStringValue().equalsIgnoreCase(string);
    }

    public int hashCode() {
        return this.getHashCode();
    }

    public boolean equals(Object object) {
        return this.isEqual(object);
    }

    public String toString() {
        return this.toPrettyString();
    }

    @Override
    public boolean contains(String string) {
        return false;
    }

    @Override
    public boolean containsAllLabels(Collection<String> collection) {
        return this.values.stream().allMatch(booleanValue -> collection.contains(booleanValue.getStringValue()));
    }

    @Override
    public IValueSpace<BooleanValue> clone(IAttribute<BooleanValue> iAttribute) {
        return new BinarySpace(iAttribute);
    }

    @Override
    public void addExceludedValue(String string) {
    }
}

