/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.value.categoric;

import com.fasterxml.jackson.annotation.JsonIgnore;
import core.metamodel.attribute.IAttribute;
import core.metamodel.value.IValue;
import core.metamodel.value.IValueSpace;
import core.metamodel.value.categoric.OrderedValue;
import core.metamodel.value.categoric.template.GSCategoricTemplate;
import core.util.data.GSEnumDataType;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

public class OrderedSpace
implements IValueSpace<OrderedValue> {
    @JsonIgnore
    private static Comparator<OrderedValue> comp = OrderedValue::compareTo;
    private final TreeSet<OrderedValue> values;
    private OrderedValue emptyValue;
    private final Set<String> excludedValues;
    private final IAttribute<OrderedValue> attribute;
    private final GSCategoricTemplate template;
    private final Map<String, OrderedValue> str2value = new HashMap<String, OrderedValue>();
    private int instanceIndex;

    public OrderedSpace(IAttribute<OrderedValue> iAttribute, GSCategoricTemplate gSCategoricTemplate) {
        this.values = new TreeSet<OrderedValue>(comp);
        this.excludedValues = new HashSet<String>();
        this.attribute = iAttribute;
        this.template = gSCategoricTemplate;
        this.emptyValue = new OrderedValue(this, null, 0);
        this.instanceIndex = 0;
    }

    public int compare(OrderedValue orderedValue, OrderedValue orderedValue2) {
        return orderedValue.compareTo(orderedValue2);
    }

    @Override
    public GSEnumDataType getType() {
        return GSEnumDataType.Order;
    }

    @Override
    public Class<OrderedValue> getTypeClass() {
        return OrderedValue.class;
    }

    @Override
    public boolean isValidCandidate(String string) {
        return true;
    }

    @Override
    public OrderedValue getInstanceValue(String string) {
        return new OrderedValue(this, string, ++this.instanceIndex);
    }

    @Override
    public OrderedValue proposeValue(String string) {
        return new OrderedValue(this, string, 0);
    }

    @Override
    public OrderedValue addValue(String string) throws IllegalArgumentException {
        return this.addValue(this.values.size(), string);
    }

    public OrderedValue addValue(Number number, String string) throws IllegalArgumentException {
        if (this.excludedValues.contains(string)) {
            return this.getEmptyValue();
        }
        OrderedValue orderedValue = null;
        try {
            orderedValue = this.getValue(string);
            if (orderedValue.getOrder().equals(number)) {
                throw new IllegalArgumentException("Ordered value " + string + " already exists with order " + String.valueOf(orderedValue.getOrder()));
            }
        }
        catch (NullPointerException nullPointerException) {
            orderedValue = new OrderedValue(this, string, number);
            this.values.add(orderedValue);
        }
        return orderedValue;
    }

    @Override
    public Set<OrderedValue> getValues() {
        return Collections.unmodifiableSet(this.values);
    }

    @Override
    public OrderedValue getValue(String string) throws NullPointerException {
        OrderedValue orderedValue2 = this.str2value.get(string);
        if (orderedValue2 != null) {
            return orderedValue2;
        }
        Optional<OrderedValue> optional = this.values.stream().filter(orderedValue -> orderedValue.getStringValue().equals(this.template.format(string))).findAny();
        if (optional.isPresent()) {
            orderedValue2 = optional.get();
            this.str2value.put(string, orderedValue2);
            return orderedValue2;
        }
        throw new NullPointerException("The string value " + string + " is not comprise in the value space " + this.toString());
    }

    @Override
    public boolean contains(IValue iValue) {
        if (!iValue.getClass().equals(OrderedValue.class)) {
            return false;
        }
        return new HashSet<OrderedValue>(this.values).contains(iValue);
    }

    @Override
    public OrderedValue getEmptyValue() {
        return this.emptyValue;
    }

    @Override
    public void setEmptyValue(String string) {
        try {
            this.emptyValue = this.getValue(string);
        }
        catch (NullPointerException nullPointerException) {
            this.emptyValue = new OrderedValue(this, string, 0);
        }
    }

    @Override
    public void addExceludedValue(String string) {
        this.excludedValues.add(string);
    }

    @Override
    public IAttribute<OrderedValue> getAttribute() {
        return this.attribute;
    }

    public GSCategoricTemplate getCategoricTemplate() {
        return this.template;
    }

    public int hashCode() {
        int n = this.getHashCode();
        return 31 * n + this.template.hashCode();
    }

    public boolean equals(Object object) {
        OrderedSpace orderedSpace;
        return object instanceof OrderedSpace && this.isEqual(orderedSpace = (OrderedSpace)object) && this.template.equals(orderedSpace.getCategoricTemplate());
    }

    public String toString() {
        return this.toPrettyString();
    }

    @Override
    public boolean contains(String string) {
        return this.values.stream().anyMatch(orderedValue -> orderedValue.getStringValue().equals(string));
    }

    @Override
    public boolean containsAllLabels(Collection<String> collection) {
        return this.values.stream().allMatch(orderedValue -> collection.contains(orderedValue.getStringValue()));
    }

    @Override
    public IValueSpace<OrderedValue> clone(IAttribute<OrderedValue> iAttribute) {
        return new OrderedSpace(iAttribute, this.getCategoricTemplate());
    }
}

