/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.value.categoric;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import core.metamodel.value.IValue;
import core.metamodel.value.categoric.OrderedSpace;
import core.util.data.GSEnumDataType;

public class OrderedValue
implements IValue {
    private final String value;
    private Number order;
    @JsonManagedReference
    private final OrderedSpace sv;

    protected OrderedValue(OrderedSpace orderedSpace, String string, Number number) {
        this.sv = orderedSpace;
        this.value = string;
        this.order = number;
    }

    @Override
    public GSEnumDataType getType() {
        return GSEnumDataType.Order;
    }

    @Override
    @JsonIgnore
    public <T> T getActualValue() {
        return (T)this.value;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    public OrderedSpace getValueSpace() {
        return this.sv;
    }

    protected int compareTo(OrderedValue orderedValue) {
        return Double.compare(this.order.doubleValue(), orderedValue.getOrder().doubleValue());
    }

    protected void setOrder(int n) {
        this.order = n;
    }

    public Number getOrder() {
        return this.order;
    }

    public int hashCode() {
        return this.getHashCode();
    }

    public boolean equals(Object object) {
        return this.isEquals(object);
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public <T> void setActualValue(T t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("cannot change the actual value of a Ordered attribute");
    }
}

