/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.value.numeric;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import core.metamodel.value.IValue;
import core.metamodel.value.numeric.ContinuousSpace;
import core.util.data.GSEnumDataType;

public class ContinuousValue
implements IValue,
Comparable<ContinuousValue> {
    private final Double value;
    @JsonManagedReference
    private final ContinuousSpace cs;

    public ContinuousValue(ContinuousSpace continuousSpace, double d) {
        this.cs = continuousSpace;
        this.value = d;
    }

    @Override
    public GSEnumDataType getType() {
        return GSEnumDataType.Continue;
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.value);
    }

    @Override
    public int compareTo(ContinuousValue continuousValue) {
        return this.value.compareTo(continuousValue.getActualValue());
    }

    public ContinuousSpace getValueSpace() {
        return this.cs;
    }

    @JsonIgnore
    public Double getActualValue() {
        return this.value;
    }

    public int hashCode() {
        return this.getHashCode();
    }

    public boolean equals(Object object) {
        return this.isEquals(object);
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public <T> void setActualValue(T t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("cannot change the actual value of a Continuous attribute, it will always be a Double");
    }
}

