/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.value.numeric;

import com.fasterxml.jackson.annotation.JsonIgnore;
import core.metamodel.value.IValue;
import core.metamodel.value.numeric.IntegerSpace;
import core.util.data.GSEnumDataType;

public class IntegerValue
implements IValue {
    private final Integer value;
    private final IntegerSpace is;

    protected IntegerValue(IntegerSpace integerSpace) {
        this.is = integerSpace;
        this.value = null;
    }

    protected IntegerValue(IntegerSpace integerSpace, int n) {
        this.is = integerSpace;
        this.value = n;
    }

    @Override
    public GSEnumDataType getType() {
        return GSEnumDataType.Integer;
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.value);
    }

    public IntegerSpace getValueSpace() {
        return this.is;
    }

    @JsonIgnore
    public Integer getActualValue() {
        return this.value;
    }

    public int hashCode() {
        return this.getHashCode();
    }

    public boolean equals(Object object) {
        return this.isEquals(object);
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public <T> void setActualValue(T t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("cannot change the actual value of an Integer attribute, it will always be the corresponding Integer value");
    }
}

