/*
 * Decompiled with CFR 0.152.
 */
package core.util;

import gama.dev.DEBUG;

public class GSPerformanceUtil {
    private int stempCalls;
    private long latestStemp;
    private double cumulStemp;
    private boolean firstSyso;
    private String performanceTestDescription;
    private double objectif;
    private final Level level;
    private static final String END = "END OF PROCESS";

    public GSPerformanceUtil(String string) {
        this(string, Level.INFO);
    }

    public GSPerformanceUtil(String string, Level level) {
        this.level = level;
        this.resetStemp();
        this.performanceTestDescription = string;
    }

    public String getStempPerformance(String string) {
        long l = System.currentTimeMillis();
        double d = (double)(l - this.latestStemp) / 1000.0;
        if (this.latestStemp != 0L) {
            this.cumulStemp += d;
        }
        this.latestStemp = l;
        if (END.equals(string)) {
            double d2 = (double)Math.round(this.cumulStemp * 1000.0) / 1000.0;
            this.resetStemp();
            return "END OF PROCESS -> overall time = " + d2 + " s.";
        }
        return string + " -> " + d + " s / " + (double)Math.round(this.cumulStemp * 1000.0) / 1000.0 + " s";
    }

    public String getStempPerformance(int n) {
        this.stempCalls += n;
        return this.getStempPerformance((String)(n == 0 ? "Init." : "Step " + this.stempCalls));
    }

    public String getStempPerformance(double d) {
        if (d == 1.0) {
            return this.getStempPerformance(END);
        }
        return this.getStempPerformance(Math.round(d * 100.0) + "%");
    }

    public void sysoStempPerformance(int n, Object object) {
        this.sysoStempMessage(this.getStempPerformance(n), object);
    }

    public void sysoStempPerformance(int n, String string, Object object) {
        this.sysoStempMessage(this.getStempPerformance(n) + " | " + string, object);
    }

    public void sysoStempPerformance(double d, Object object) {
        this.sysoStempMessage(this.getStempPerformance(d), object);
    }

    public void sysoStempPerformance(double d, String string, Object object) {
        this.sysoStempMessage(this.getStempPerformance(d) + " | " + string, object);
    }

    public void sysoStempPerformance(String string, Object object) {
        this.sysoStempMessage(this.getStempPerformance(string), object);
    }

    public void sysoStempMessage(String string) {
        this.printLog(string, Level.INFO);
    }

    public void sysoStempMessage(String string, Level level) {
        this.printLog(string, level);
    }

    private void sysoStempMessage(String string, Object object) {
        String string2 = object.getClass().getSimpleName();
        if (object.getClass().equals(String.class)) {
            string2 = object.toString();
        }
        if (this.firstSyso) {
            this.printLog("\nMethod caller: " + string2 + "\n-------------------------\n" + this.performanceTestDescription + "\n-------------------------", null);
            this.firstSyso = false;
        }
        this.printLog(string, this.level);
    }

    public void sysoStempMessage(String string, Object ... objectArray) {
        DEBUG.OUT((Object)(String.valueOf((Object)this.level) + "->" + string));
    }

    public void setObjectif(double d) {
        this.objectif = d;
    }

    public double getObjectif() {
        return this.objectif;
    }

    public void resetStemp() {
        this.resetStempCalls();
        this.firstSyso = true;
        this.performanceTestDescription = "no reason";
    }

    public void resetStempCalls() {
        this.stempCalls = 0;
        this.latestStemp = 0L;
        this.cumulStemp = 0.0;
    }

    private void printLog(String string, Level level) {
        if (level == null) {
            level = this.level;
        }
        if (Level.ERROR.equals((Object)level)) {
            DEBUG.ERR((Object)string);
        } else if (Level.WARN.equals((Object)level) || !Level.INFO.equals((Object)level)) {
            DEBUG.OUT((Object)string);
        } else {
            DEBUG.LOG((Object)string);
        }
    }

    public static enum Level {
        INFO,
        ERROR,
        WARN,
        DEBUG,
        TRACE;

    }
}

