/*
 * Decompiled with CFR 0.152.
 */
package core.util.data;

import core.util.exception.GenstarException;
import gama.dev.DEBUG;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Base64;

public class DataLocalRepository {
    private static DataLocalRepository singleton = null;
    protected File baseDirectory = null;

    public static DataLocalRepository getRepository() {
        if (singleton == null) {
            singleton = new DataLocalRepository();
        }
        return singleton;
    }

    private DataLocalRepository() {
    }

    public void setDirectory(File file) {
        if (!file.exists()) {
            throw new GenstarException("this directory does not exists");
        }
        if (!file.canRead() || !file.canWrite()) {
            throw new GenstarException("this directory does not have read and write permissions");
        }
        this.baseDirectory = file;
    }

    public File getBaseDirectory() {
        if (this.baseDirectory == null) {
            File file = new File(System.getProperty("user.home"));
            this.baseDirectory = new File(file, ".genstar" + File.separator + "repo");
            this.baseDirectory.mkdirs();
        }
        return this.baseDirectory;
    }

    public File getDirectoryForUrl(URL uRL) {
        String string = Base64.getUrlEncoder().encodeToString(uRL.toString().getBytes());
        return new File(this.getBaseDirectory(), string);
    }

    protected void downloadFileInto(URL uRL, File file) {
        ReadableByteChannel readableByteChannel;
        DEBUG.OUT((Object)("opening URL {} : " + String.valueOf(uRL)));
        try {
            readableByteChannel = Channels.newChannel(uRL.openStream());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new GenstarException("error while loading data from " + String.valueOf(uRL), iOException);
        }
        DEBUG.OUT((Object)("downloading into {} : " + file.getAbsolutePath()));
        File file2 = new File(file.getAbsolutePath() + ".download");
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                file2.renameTo(file);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new GenstarException(iOException);
        }
    }

    public File getOrDownloadResource(URL uRL, String string) {
        Serializable serializable;
        File file = this.getDirectoryForUrl(uRL);
        if (!file.exists()) {
            file.mkdirs();
            try {
                serializable = null;
                Object var5_7 = null;
                try (PrintStream printStream = new PrintStream(new File(file, "url.txt"));){
                    printStream.println(uRL.toString());
                }
                catch (Throwable throwable) {
                    if (serializable == null) {
                        serializable = throwable;
                    } else if (serializable != throwable) {
                        ((Throwable)serializable).addSuppressed(throwable);
                    }
                    throw serializable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                throw new GenstarException(fileNotFoundException);
            }
        }
        if (!((File)(serializable = new File(file, string))).exists()) {
            DEBUG.OUT((Object)("we don't have a local copy for url {}, let's download it... : " + String.valueOf(uRL)));
            this.downloadFileInto(uRL, (File)serializable);
        }
        return serializable;
    }
}

