/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.generator;

import com.google.common.base.Functions;
import espacedev.gaml.extensions.genstar.generator.IGenstarGenerator;
import espacedev.gaml.extensions.genstar.statement.GenerateStatement;
import espacedev.gaml.extensions.genstar.utils.GenStarConstant;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.IMatrix;
import gama.gaml.operators.Maths;
import gama.gaml.operators.Random;
import gama.gaml.statements.Arguments;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MatrixBasedGenerator
implements IGenstarGenerator {
    private static MatrixBasedGenerator INSTANCE = new MatrixBasedGenerator();
    IType type = Types.MATRIX;

    private MatrixBasedGenerator() {
    }

    public static MatrixBasedGenerator getInstance() {
        return INSTANCE;
    }

    @Override
    public IType sourceType() {
        return this.type;
    }

    @Override
    public boolean sourceMatch(IScope iScope, Object object) {
        return object instanceof GamaFloatMatrix || object instanceof GamaIntMatrix;
    }

    @Override
    public void generate(IScope iScope, List<Map<String, Object>> list, Integer n, Object object, Object object2, Object object3, Arguments arguments, GenerateStatement generateStatement) {
        IAgent iAgent = iScope.getAgent();
        IPopulation iPopulation = iAgent.getPopulationFor(generateStatement.getDescription().getSpeciesContext().getName());
        IMap iMap = (IMap)object2;
        GamaFloatMatrix gamaFloatMatrix = GamaFloatMatrix.from((IScope)iScope, (IMatrix)((IMatrix)object));
        IMap<List<String>, Double> iMap2 = this.getDistributionFromMatrix(iScope, gamaFloatMatrix, (IMap<String, IList<String>>)iMap);
        Map map = iMap.keySet().stream().collect(Collectors.toMap(Functions.identity(), string -> iPopulation.getVar(string).getType()));
        int n2 = n == null ? this.inferGenerateNumber(gamaFloatMatrix) : n.intValue();
        int n3 = 0;
        while (n3 < n2) {
            IMap iMap3 = GamaMapFactory.create((IType)Types.STRING, (IType)Types.NO_TYPE);
            List list2 = (List)Random.opRndCoice((IScope)iScope, iMap2);
            for (String string3 : iMap.keySet()) {
                String string4 = list2.stream().filter(string2 -> ((IList)iMap.get((Object)string3)).contains(string2)).findFirst().get();
                iMap3.put(string3, map.get(string3).cast(iScope, (Object)string4, null, false));
            }
            generateStatement.fillWithUserInit(iScope, (Map)iMap3);
            list.add((Map<String, Object>)iMap3);
            ++n3;
        }
    }

    private IMap<List<String>, Double> getDistributionFromMatrix(IScope iScope, GamaFloatMatrix gamaFloatMatrix, IMap<String, IList<String>> iMap) {
        IMap iMap2 = GamaMapFactory.create();
        String string = null;
        String string2 = null;
        for (String string3 : iMap.getKeys()) {
            if (gamaFloatMatrix.numCols == ((IList)iMap.get((Object)string3)).size() && string == null) {
                string = string3;
                continue;
            }
            if (gamaFloatMatrix.numRows == ((IList)iMap.get((Object)string3)).size() && string2 == null) {
                string2 = string3;
                continue;
            }
            GamaRuntimeException.error((String)("Attribute " + string3 + " values (" + String.valueOf(iMap.get((Object)string3)) + ") mismatch matrix size " + gamaFloatMatrix.numCols + ":" + gamaFloatMatrix.numRows), (IScope)iScope);
        }
        int n = 0;
        while (n < gamaFloatMatrix.numCols) {
            int n2 = 0;
            while (n2 < gamaFloatMatrix.numRows) {
                iMap2.put(Arrays.asList((String)((IList)iMap.get((Object)string)).get(n), (String)((IList)iMap.get((Object)string2)).get(n2)), (Object)gamaFloatMatrix.get(iScope, n, n2));
                ++n2;
            }
            ++n;
        }
        return iMap2;
    }

    private int inferGenerateNumber(GamaFloatMatrix gamaFloatMatrix) {
        double d = Arrays.stream(gamaFloatMatrix.getMatrix()).sum();
        return Math.abs(d - 1.0) < GenStarConstant.EPSILON ? 1 : Maths.round((Double)d);
    }
}

