/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.old;

import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.AttributeFactory;
import core.metamodel.attribute.IAttribute;
import core.metamodel.attribute.record.RecordAttribute;
import core.metamodel.io.GSSurveyWrapper;
import core.metamodel.value.IValue;
import core.metamodel.value.numeric.RangeValue;
import core.util.exception.GSIllegalRangedData;
import espacedev.gaml.extensions.genstar.type.GamaPopGenerator;
import espacedev.gaml.extensions.genstar.utils.GenStarConstant;
import espacedev.gaml.extensions.genstar.utils.GenStarGamaUtils;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMap;
import gama.core.util.IList;
import gama.gaml.types.IType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GenstarAdderOperators {
    @GamlAnnotations.operator(value={"with_generation_algo"}, can_be_const=true, category={"Gen*"}, concept={"Gen*"})
    @GamlAnnotations.doc(value="define the algorithm used for the population generation among: IS (independant hypothesis Algorothm) and simple_draw (simple draw of entities in a sample)", examples={@GamlAnnotations.example(value="my_pop_generator with_generation_algo \"simple_draw\"", test=false)})
    public static GamaPopGenerator withGenerationAlgo(GamaPopGenerator gamaPopGenerator, String string) {
        if (gamaPopGenerator == null) {
            gamaPopGenerator = new GamaPopGenerator();
        }
        GenStarConstant.GenerationAlgorithm generationAlgorithm = GenStarConstant.GenerationAlgorithm.getAlgorithm(string);
        gamaPopGenerator.setGenerationAlgorithm(generationAlgorithm.getDefault());
        return gamaPopGenerator;
    }

    @GamlAnnotations.operator(value={"add_census_file"}, can_be_const=true, category={"Gen*"}, concept={"Gen*"})
    @GamlAnnotations.doc(value="add a census data file defined by its path (string), its type (\"ContingencyTable\", \"GlobalFrequencyTable\", \"LocalFrequencyTable\" or  \"Sample\"), its separator (string), the index of the first row of data (int) and the index of the first column of data (int) to a population_generator", examples={@GamlAnnotations.example(value="add_census_file(pop_gen, \"../data/Age_Couple.csv\", \"ContingencyTable\", \";\", 1, 1)", test=false)})
    public static GamaPopGenerator addCensusFile(IScope iScope, GamaPopGenerator gamaPopGenerator, String string, String string2, String string3, int n, int n2) throws GamaRuntimeException {
        Path path = Paths.get(FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)string, (boolean)false), new String[0]);
        gamaPopGenerator.getInputFiles().add(new GSSurveyWrapper(path, GenStarGamaUtils.toSurveyType(string2), string3.isEmpty() ? (char)',' : (char)string3.charAt(0), n, n2));
        return gamaPopGenerator;
    }

    @GamlAnnotations.operator(value={"add_mapper"}, can_be_const=true, category={"Gen*"}, concept={"Gen*"})
    @GamlAnnotations.doc(value="add a mapper between source of data for a attribute to a population_generator. A mapper is defined by the name of the attribute, the datatype of attribute (type), the corresponding value (map<list,list>) and the type of attribute (\"unique\" or \"range\")", examples={@GamlAnnotations.example(value=" add_mapper(pop_gen, \"Age\", int, [[\"0 to 18\"]::[\"1 to 10\",\"11 to 18\"], [\"18 to 100\"]::[\"18 to 50\",\"51 to 100\"] , \"range\");", test=false)})
    public static GamaPopGenerator addMapper(IScope iScope, GamaPopGenerator gamaPopGenerator, String string, IType iType, GamaMap gamaMap) {
        return GenstarAdderOperators.addMapper(iScope, gamaPopGenerator, string, iType, gamaMap, false);
    }

    @GamlAnnotations.operator(value={"add_mapper"}, can_be_const=true, category={"Gen*"}, concept={"Gen*"})
    @GamlAnnotations.doc(value="add a mapper between source of data for a attribute to a population_generator. A mapper is defined by the name of the attribute, the datatype of attribute (type), the corresponding value (map<list,list>) and the type of attribute (\"unique\" or \"range\")", examples={@GamlAnnotations.example(value=" add_mapper(pop_gen, \"Age\", int, [[\"0 to 18\"]::[\"1 to 10\",\"11 to 18\"], [\"18 to 100\"]::[\"18 to 50\",\"51 to 100\"] , \"range\");", test=false)})
    public static GamaPopGenerator addMapper(IScope iScope, GamaPopGenerator gamaPopGenerator, String string, IType iType, GamaMap gamaMap, Boolean bl) {
        if (gamaPopGenerator == null) {
            gamaPopGenerator = new GamaPopGenerator();
        }
        if (string == null) {
            return gamaPopGenerator;
        }
        AttributeFactory attributeFactory = AttributeFactory.getFactory();
        IAttribute iAttribute = gamaPopGenerator.getInputAttributes().getAttribute(string);
        if (iAttribute != null) {
            try {
                String string2 = ((Attribute)iAttribute).getAttributeName() + "_" + (gamaPopGenerator.getInputAttributes().getAttributes().size() + 1);
                gamaPopGenerator.getInputAttributes().addAttributes(new Attribute[]{attributeFactory.createSTSMappedAttribute(string2, GenStarGamaUtils.toDataType(iType, bl), iAttribute, (Map<Collection<String>, Collection<String>>)gamaMap)});
            }
            catch (GSIllegalRangedData gSIllegalRangedData) {
                throw GamaRuntimeException.error((String)("Wrong type in the record." + gSIllegalRangedData.getMessage()), (IScope)iScope);
            }
        }
        return gamaPopGenerator;
    }

    @GamlAnnotations.operator(value={"add_attribute"}, can_be_const=true, category={"Gen*"}, concept={"Gen*"})
    @GamlAnnotations.doc(value="add an attribute defined by its name (string), its datatype (type), its list of values (list) to a population_generator", examples={@GamlAnnotations.example(value="add_attribute(pop_gen, \"Sex\", string,[\"Man\", \"Woman\"])", test=false)})
    public static GamaPopGenerator addAttribute(IScope iScope, GamaPopGenerator gamaPopGenerator, String string, IType iType, IList iList) {
        return GenstarAdderOperators.addAttribute(iScope, gamaPopGenerator, string, iType, iList, false);
    }

    @GamlAnnotations.operator(value={"add_range_attribute"}, can_be_const=true, category={"Gen*"}, concept={"Gen*"})
    @GamlAnnotations.doc(value="add a rangee attribute defined by its name (string), the list of ranges (list) to a population_generator", examples={@GamlAnnotations.example(value="add_attribute(pop_gen, \"Sex\", string,[\"Man\", \"Woman\"])", test=false)})
    public static GamaPopGenerator addAttribute(IScope iScope, GamaPopGenerator gamaPopGenerator, String string, IList iList, int n, int n2) {
        if (gamaPopGenerator == null) {
            gamaPopGenerator = new GamaPopGenerator();
        }
        Attribute<RangeValue> attribute = null;
        try {
            attribute = gamaPopGenerator.getAttf().createRangeAttribute(string, (List<String>)iList, (Number)n, (Number)n2);
        }
        catch (GSIllegalRangedData | NullPointerException exception) {
            GamaRuntimeException.create((Throwable)exception, (IScope)iScope);
        }
        gamaPopGenerator.getInputAttributes().addAttributes(attribute);
        return gamaPopGenerator;
    }

    @GamlAnnotations.operator(value={"add_attribute"}, can_be_const=true, category={"Gen*"}, concept={"Gen*"})
    @GamlAnnotations.doc(value="add an attribute defined by its name (string), its datatype (type), its list of values (list) and attributeType name (type of the attribute among \"range\" and \"unique\") to a population_generator", examples={@GamlAnnotations.example(value="add_attribute(pop_gen, \"iris\", string, liste_iris, \"unique\")", test=false)})
    public static GamaPopGenerator addAttribute(IScope iScope, GamaPopGenerator gamaPopGenerator, String string, IType iType, IList iList, String string2, IType iType2) {
        return GenstarAdderOperators.addAttribute(iScope, gamaPopGenerator, string, iType, iList, false, string2, iType2);
    }

    @GamlAnnotations.operator(value={"add_attribute"}, can_be_const=true, category={"Gen*"}, concept={"Gen*"})
    @GamlAnnotations.doc(value="add an attribute defined by its name (string), its datatype (type), its list of values (list) to a population_generator", examples={@GamlAnnotations.example(value="add_attribute(pop_gen, \"Sex\", string,[\"Man\", \"Woman\"])", test=false)})
    public static GamaPopGenerator addAttribute(IScope iScope, GamaPopGenerator gamaPopGenerator, String string, IType iType, IList iList, Boolean bl, String string2, IType iType2) {
        if (gamaPopGenerator == null) {
            gamaPopGenerator = new GamaPopGenerator();
        }
        GamaPopGenerator gamaPopGenerator2 = GenstarAdderOperators.addAttribute(iScope, gamaPopGenerator, string, iType, iList, bl);
        gamaPopGenerator2.getInputAttributes().addRecords(new RecordAttribute[0]);
        try {
            gamaPopGenerator2.getInputAttributes().addRecords(new RecordAttribute[]{gamaPopGenerator.getAttf().createRecordAttribute(string2, GenStarGamaUtils.toDataType(iType2, false), (Attribute<? extends IValue>)gamaPopGenerator2.getInputAttributes().getAttribute(string))});
        }
        catch (GSIllegalRangedData gSIllegalRangedData) {
            throw GamaRuntimeException.error((String)("Wrong type for the record. " + gSIllegalRangedData.getMessage()), (IScope)iScope);
        }
        return gamaPopGenerator2;
    }

    @GamlAnnotations.operator(value={"add_attribute"}, can_be_const=true, category={"Gen*"}, concept={"Gen*"})
    @GamlAnnotations.doc(value="add an attribute defined by its name (string), its datatype (type), its list of values (list) and record name (name of the attribute to record) to a population_generator", examples={@GamlAnnotations.example(value="add_attribute(pop_gen, \"iris\", string,liste_iris, \"unique\", \"P13_POP\")", test=false)})
    public static GamaPopGenerator addAttribute(IScope iScope, GamaPopGenerator gamaPopGenerator, String string, IType iType, IList iList, Boolean bl) {
        if (gamaPopGenerator == null) {
            gamaPopGenerator = new GamaPopGenerator();
        }
        try {
            Attribute<? extends IValue> attribute = gamaPopGenerator.getAttf().createAttribute(string, GenStarGamaUtils.toDataType(iType, bl), (List<String>)iList);
            gamaPopGenerator.getInputAttributes().addAttributes(attribute);
        }
        catch (GSIllegalRangedData gSIllegalRangedData) {
            throw GamaRuntimeException.error((String)("Wrong type in the record." + gSIllegalRangedData.getMessage()), (IScope)iScope);
        }
        return gamaPopGenerator;
    }

    @GamlAnnotations.operator(value={"add_marginals"}, category={"Gen*"}, concept={"Gen*"})
    @GamlAnnotations.doc(value="add a list of marginals (name of the attributes) to fit the population with, in any CO based algorithm", examples={@GamlAnnotations.example(value="add_marginals(pop_gen, [\"gender\",\"age\"]);")})
    public static GamaPopGenerator addMarginals(IScope iScope, GamaPopGenerator gamaPopGenerator, IList iList) {
        if (gamaPopGenerator == null) {
            gamaPopGenerator = new GamaPopGenerator();
        }
        gamaPopGenerator.setMarginals(gamaPopGenerator.getInputAttributes().getAttributes().stream().filter(attribute -> iList.contains((Object)attribute.getAttributeName())).toList());
        return gamaPopGenerator;
    }
}

