/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.statement;

import espacedev.gaml.extensions.genstar.generator.IGenstarGenerator;
import espacedev.gaml.extensions.genstar.utils.GenStarGamaUtils;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.types.SpeciesConstantExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.CreateStatement;
import gama.gaml.statements.RemoteSequence;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.List;
import one.util.streamex.StreamEx;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="species", type={14, 11}, optional=true, doc={@GamlAnnotations.doc(value="The species of the agents to be created.")}), @GamlAnnotations.facet(name="from", type={0}, optional=false, doc={@GamlAnnotations.doc(value="To specify the input data used to inform the generation process. Various data input can be used:\n * list of csv_file: can be aggregated or micro data\n * matrix: describe the joint distribution of two attributes\n * genstar generator: a dedicated gaml type to enclose various genstar options all in one")}), @GamlAnnotations.facet(name="attributes", type={10}, optional=false, doc={@GamlAnnotations.doc(value="To specify the explicit link between agent attributes and file based attributes")}), @GamlAnnotations.facet(name="number", type={1}, optional=true, doc={@GamlAnnotations.doc(value="To specify the number of created agents interpreted as an int value.\nIf facet is ommited or value is 0 or less, generator will treat data used in the 'from' facet as contingencies\n(i.e. a count of entities) and infer a number to generate (if distribution is used, then only one entity will be created")}), @GamlAnnotations.facet(name="generator", type={4}, optional=true, doc={@GamlAnnotations.doc(value="To specify the type of generator you want to use: as of now there is only DS (or DirectSampling) available")})}, omissible="species")
@GamlAnnotations.doc(value="Allows to create a synthetic population of agent from a set of given rules", usages={@GamlAnnotations.usage(value="The synthax to create a minimal synthetic population from aggregated file is:", examples={@GamlAnnotations.example(value="generate species:people number: 10000\nfrom:[csv_file(\"../includes/Age & Sexe-Tableau 1.csv\",\";\")]\nattributes:[\"Age\"::[\"Moins de 5 ans\", \"5 \u00e0 9 ans\", \"10 \u00e0 14 ans\", \"15 \u00e0 19 ans\", \"20 \u00e0 24 ans\",\n\"25 \u00e0 29 ans\", \"30 \u00e0 34 ans\", \"35 \u00e0 39 ans\", \"40 \u00e0 44 ans\", \"45 \u00e0 49 ans\",\n\"50 \u00e0 54 ans\", \"55 \u00e0 59 ans\", \"60 \u00e0 64 ans\", \"65 \u00e0 69 ans\", \"70 \u00e0 74 ans\", \"75 \u00e0 79 ans\",\n\"80 \u00e0 84 ans\", \"85 \u00e0 89 ans\", \"90 \u00e0 94 ans\", \"95 \u00e0 99 ans\", \"100 ans ou plus\"],\n\"Sexe\"::[\"Hommes\", \"Femmes\"]];", isExecutable=false)})})
@validator(value=GenerateValidator.class)
public class GenerateStatement
extends CreateStatement {
    public static final String GENERATE = "generate";
    private Arguments init;
    private final IExpression from;
    private final IExpression number;
    private final IExpression attributes;
    private final IExpression algorithm;
    private final String returns = this.getLiteral("return");
    private final RemoteSequence sequence;

    public GenerateStatement(IDescription iDescription) {
        super(iDescription);
        this.from = this.getFacet(new String[]{"from"});
        this.number = this.getFacet(new String[]{"number"});
        this.attributes = this.getFacet(new String[]{"attributes"});
        this.algorithm = this.getFacet(new String[]{"generator"});
        this.sequence = new RemoteSequence(this.description);
        this.sequence.setName("commands of generate ");
        this.setName(GENERATE);
    }

    public IList<? extends IAgent> privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Integer n;
        Integer n2 = n = this.number == null ? null : Cast.asInt((IScope)iScope, (Object)this.number.value(iScope));
        if (this.from == null && n != null && n <= 0) {
            return GamaListFactory.EMPTY_LIST;
        }
        IPopulation iPopulation = super.findPopulation(iScope);
        if (iPopulation == null || iPopulation.getSpecies() == null) {
            throw GamaRuntimeException.error((String)"Impossible to determine the species of the agents to generate", (IScope)iScope);
        }
        this.checkPopulationValidity(iPopulation, iScope);
        List list = GamaListFactory.create((IContainerType)Types.MAP, (int)(n == null ? 10 : n));
        Object object = this.from.value(iScope);
        ((IGenstarGenerator)StreamEx.of((Object[])GenStarGamaUtils.getGamaGenerator()).findFirst(iGenstarGenerator -> iGenstarGenerator.sourceMatch(iScope, object)).orElseThrow(IllegalArgumentException::new)).generate(iScope, list, n, object, this.attributes.value(iScope), this.algorithm == null ? null : this.algorithm.value(iScope), this.init, this);
        IList iList = iPopulation.createAgents(iScope, list.size(), list, false, false, this.sequence);
        if (this.returns != null) {
            iScope.setVarValue(this.returns, (Object)iList);
        }
        return iList;
    }

    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.sequence.setChildren(iterable);
    }

    public static class GenerateValidator
    implements IDescriptionValidator<StatementDescription> {
        public void validate(StatementDescription statementDescription) {
            IType iType;
            IExpression iExpression = statementDescription.getFacetExpr(new String[]{"species"});
            if (iExpression == null) {
                statementDescription.error("The species is not found", "gaml.unknown.species.issue", "species", new String[0]);
                return;
            }
            SpeciesDescription speciesDescription = iExpression.getGamlType().getDenotedSpecies();
            if (speciesDescription == null) {
                statementDescription.error("The species to instantiate cannot be determined", "gaml.unknown.species.issue", "species", new String[]{iExpression.getName()});
                return;
            }
            if (iExpression instanceof SpeciesConstantExpression) {
                boolean bl = speciesDescription.isAbstract();
                boolean bl2 = speciesDescription.isMirror();
                boolean bl3 = speciesDescription.isGrid();
                boolean bl4 = speciesDescription.isBuiltIn();
                if (bl || bl2 || bl3 || bl4) {
                    String string2 = bl ? "abstract" : (bl2 ? "a mirror" : (bl3 ? "a grid" : (bl4 ? "built-in" : "")));
                    statementDescription.error(speciesDescription.getName() + " is " + string2 + " and cannot be instantiated", "gaml.wrong.type.issue", "species", new String[0]);
                    return;
                }
            } else if (!(speciesDescription instanceof ModelDescription)) {
                statementDescription.info("The actual species will be determined at runtime. This can lead to errors if it cannot be instantiated", "gaml.wrong.type.issue", "species", new String[0]);
            }
            if (speciesDescription instanceof ModelDescription && !(statementDescription.getSpeciesContext() instanceof ExperimentDescription)) {
                statementDescription.error("Simulations can only be created within experiments", "gaml.wrong.context.issue", "species", new String[0]);
                return;
            }
            SpeciesDescription speciesDescription2 = statementDescription.getSpeciesContext();
            SpeciesDescription speciesDescription3 = speciesDescription.getMacroSpecies();
            if (speciesDescription3 == null) {
                statementDescription.error("The macro-species of " + String.valueOf(iExpression) + " cannot be determined");
                return;
            }
            if (!(speciesDescription3 instanceof ModelDescription && speciesDescription2 instanceof ModelDescription || speciesDescription2 == speciesDescription3 || speciesDescription2.hasMacroSpecies(speciesDescription3) || speciesDescription2.hasParent(speciesDescription3))) {
                statementDescription.error("No instance of " + speciesDescription3.getName() + " available for creating instances of " + speciesDescription.getName());
                return;
            }
            IExpression iExpression2 = statementDescription.getFacetExpr(new String[]{"from"});
            if (iExpression2 != null && (iType = iExpression2.getGamlType()).id() != 938373948) {
                boolean bl = false;
                List list = StreamEx.of((Object[])GenStarGamaUtils.getGamaGenerator()).map(IGenstarGenerator::sourceType).toList();
                for (IType iType2 : list) {
                    bl = iType2.isAssignableFrom(iType);
                    if (bl) break;
                }
                if (!bl) {
                    statementDescription.warning("Facet 'from' expects an expression with one of the following types: " + String.valueOf(list), "gaml.wrong.type.issue", "from", new String[0]);
                }
            }
            Arguments arguments = statementDescription.getPassedArgs();
            arguments.forEachFacet((string, iExpressionDescription) -> {
                boolean bl;
                boolean bl2 = bl = !speciesDescription.isExperiment() && !speciesDescription.hasAttribute(string);
                if (bl) {
                    statementDescription.error("Attribute " + string + " is not defined in species " + iExpression.getName(), "gaml.unknown.var.issue");
                }
                return !bl;
            });
        }
    }
}

