/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.statement;

import espacedev.gaml.extensions.genstar.utils.GenStarGamaUtils;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.RemoteSequence;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="species", type={14, 11, 16}, optional=false, doc={@GamlAnnotations.doc(value="The species of the agents to be localised.")}), @GamlAnnotations.facet(name="nests", type={16, 14}, optional=false, doc={@GamlAnnotations.doc(value="To specify the input data used to inform the localisation process. Various data input can be used: <br/>\n * a list of geometry <br/>\n * a shapefile or a rasterfile\n")}), @GamlAnnotations.facet(name="max_dist_loc", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The maximal distance acceptable for the relaxation of the localization constraint\n")}), @GamlAnnotations.facet(name="step_dist_loc", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The distance added at each step for the relaxation of the localization constraint\n")}), @GamlAnnotations.facet(name="nest_attribute", type={4}, optional=true, doc={@GamlAnnotations.doc(value="To specify the attribute of the nest\n")}), @GamlAnnotations.facet(name="distribution", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The type of distribution to use ('area', 'uniform',)\n")}), @GamlAnnotations.facet(name="min_dist", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The min distance to the nest geometry\n")}), @GamlAnnotations.facet(name="max_dist", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The max distance to the nest geometry\n")}), @GamlAnnotations.facet(name="matcher", type={10}, optional=true, doc={@GamlAnnotations.doc(value="To specify the matcher, map with three elements:\n'entities': list of entities with the ;\n'data_id': name of the property that contains the id of the census spatial areas in the shapefile;\n'pop_id': name of the property that contains the id of the census spatial areas in the population\n")}), @GamlAnnotations.facet(name="mapper", type={10}, optional=true, doc={@GamlAnnotations.doc(value="To specify the mapper, map with three elements:\n'entities': list of entities with the ;\n'data_id': name of the property that contains the id of the census spatial areas in the shapefile;\n")}), @GamlAnnotations.facet(name="constraints", type={5}, optional=true, doc={@GamlAnnotations.doc(value="To specify the constraints, a list of maps, each map representing a constraint with its own parameters\n")}), @GamlAnnotations.facet(name="feature", type={4}, optional=true, doc={@GamlAnnotations.doc(value="To specify the attribute of a geometry to be used to inform localisation process")})})
@GamlAnnotations.doc(value="Allows to localise a set of agent within a given set of geometries", usages={@GamlAnnotations.usage(value="The synthax to monitor the simplest localisation process", examples={@GamlAnnotations.example(value="localise species:people from:[shape_file(\"../includes/minimalexample.shp\")];\n", isExecutable=false)})})
@validator(value=LocaliseValidator.class)
public class LocaliseStatement
extends AbstractStatementSequence
implements IStatement.WithArgs {
    private Arguments init;
    private final IExpression nests = this.getFacet(new String[]{"nests"});
    private final IExpression nestAttribute;
    private final IExpression matcher;
    private final IExpression mapper;
    private final IExpression distribution;
    private final IExpression constraints;
    private final IExpression species = this.getFacet(new String[]{"species"});
    private final IExpression feature = this.getFacet(new String[]{"feature"});
    private final IExpression minDist;
    private final IExpression maxDist;
    private final IExpression maxDistLocCst;
    private final IExpression stepDistLocCst;
    private final RemoteSequence sequence;

    public LocaliseStatement(IDescription iDescription) {
        super(iDescription);
        this.matcher = this.getFacet(new String[]{"matcher"});
        this.mapper = this.getFacet(new String[]{"mapper"});
        this.nestAttribute = this.getFacet(new String[]{"nest_attribute"});
        this.distribution = this.getFacet(new String[]{"distribution"});
        this.minDist = this.getFacet(new String[]{"min_dist"});
        this.maxDist = this.getFacet(new String[]{"max_dist"});
        this.constraints = this.getFacet(new String[]{"constraints"});
        this.maxDistLocCst = this.getFacet(new String[]{"max_dist_loc"});
        this.stepDistLocCst = this.getFacet(new String[]{"step_dist_loc"});
        this.sequence = new RemoteSequence(this.description);
        this.sequence.setName("commands for the localisation");
        this.setName("localize");
    }

    public IContainer<?, IAgent> privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Object object;
        IPopulation iPopulation = null;
        Object object2 = this.species.value(iScope);
        if (object2 instanceof ISpecies) {
            iPopulation = ((ISpecies)object2).getPopulation(iScope);
        }
        if (object2 instanceof IAgent) {
            object = Cast.asAgent((IScope)iScope, (Object)object2);
            iPopulation = GamaListFactory.create();
            ((IList)iPopulation).add(object);
        } else {
            iPopulation = Cast.asList((IScope)iScope, (Object)object2);
        }
        object = GenStarGamaUtils.getGamaLocaliser()[0];
        object.localise(iScope, (IContainer<?, IAgent>)iPopulation, this.nests.value(iScope), this);
        return iPopulation;
    }

    public void setFormalArgs(Arguments arguments) {
        this.init = arguments;
    }

    public IExpression getDistribution() {
        return this.distribution;
    }

    public IExpression getMatcher() {
        return this.matcher;
    }

    public IExpression getMapper() {
        return this.mapper;
    }

    public IExpression getMinDist() {
        return this.minDist;
    }

    public IExpression getMaxDist() {
        return this.maxDist;
    }

    public IExpression getNestAttribute() {
        return this.nestAttribute;
    }

    public IExpression getMaxDistLocCst() {
        return this.maxDistLocCst;
    }

    public IExpression getStepDistLocCst() {
        return this.stepDistLocCst;
    }

    public IExpression getConstraints() {
        return this.constraints;
    }

    public static class LocaliseValidator
    implements IDescriptionValidator<StatementDescription> {
        public void validate(StatementDescription statementDescription) {
        }
    }
}

