/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.statement;

import espacedev.gaml.extensions.genstar.localisation.IGenstarLinker;
import espacedev.gaml.extensions.genstar.utils.GenStarGamaUtils;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.RemoteSequence;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="entities", type={16}, optional=false, doc={@GamlAnnotations.doc(value="The species of the agents to be linked.")}), @GamlAnnotations.facet(name="nests", type={16}, optional=false, doc={@GamlAnnotations.doc(value="The species of the agents linked with the species.")}), @GamlAnnotations.facet(name="nest_attribute", type={4}, optional=false, doc={@GamlAnnotations.doc(value="To specify the attribute of the nest\n")}), @GamlAnnotations.facet(name="distribution", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The type of distribution to use ('area', 'uniform',)\n")}), @GamlAnnotations.facet(name="parameters", type={10}, optional=true, doc={@GamlAnnotations.doc(value="The parameters of the linker")})})
@GamlAnnotations.doc(value="Allows to localise a set of agent within a given set of geometries", usages={@GamlAnnotations.usage(value="The synthax to monitor the simplest localisation process", examples={@GamlAnnotations.example(value="localise species:people from:[shape_file(\"../includes/minimalexample.shp\")];\n", isExecutable=false)})})
@validator(value=LocaliseValidator.class)
public class SpatialLinkerStatement
extends AbstractStatementSequence
implements IStatement.WithArgs {
    private final IExpression nests = this.getFacet(new String[]{"nests"});
    private final IExpression distribution;
    private final IExpression entities = this.getFacet(new String[]{"entities"});
    private final IExpression nestAttribute;
    private final IExpression parameters;
    private final RemoteSequence sequence;

    public SpatialLinkerStatement(IDescription iDescription) {
        super(iDescription);
        this.distribution = this.getFacet(new String[]{"distribution"});
        this.nestAttribute = this.getFacet(new String[]{"nest_attribute"});
        this.parameters = this.getFacet(new String[]{"parameters"});
        this.sequence = new RemoteSequence(this.description);
        this.sequence.setName("commands for the localisation");
        this.setName("localize");
    }

    public IList<? extends IAgent> privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Object object = null;
        Object object2 = this.entities.value(iScope);
        object = object2 instanceof ISpecies ? ((ISpecies)object2).getPopulation(iScope) : Cast.asList((IScope)iScope, (Object)object2);
        Object object3 = null;
        Object object4 = this.nests.value(iScope);
        object3 = object4 instanceof ISpecies ? ((ISpecies)object4).getPopulation(iScope) : Cast.asList((IScope)iScope, (Object)object4);
        IGenstarLinker iGenstarLinker = GenStarGamaUtils.getGamaLinker()[0];
        iGenstarLinker.link(iScope, (IContainer<?, IAgent>)object, (IContainer<?, IShape>)object3, this);
        return object;
    }

    public IExpression getDistribution() {
        return this.distribution;
    }

    public IExpression getParameters() {
        return this.parameters;
    }

    public IExpression getNestAttribute() {
        return this.nestAttribute;
    }

    public IExpression getNests() {
        return this.nests;
    }

    public IExpression getEntities() {
        return this.entities;
    }

    public void setFormalArgs(Arguments arguments) {
    }

    public static class LocaliseValidator
    implements IDescriptionValidator<StatementDescription> {
        public void validate(StatementDescription statementDescription) {
        }
    }
}

